/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

public abstract class PopupWindow {
    private final JPopupMenu popup;
    private final JPanel popupRootContent;
    private final JLabel title;
    protected final JPanel content;
    private static final int DEF_WIDTH = 100;
    private static final int DEF_HEIGHT = 200;
    private static final int OUTER_PADDING = 2;

    public PopupWindow() {
        this(100, 200);
    }

    public PopupWindow(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.popup = new JPopupMenu();
        this.popupRootContent = new JPanel();
        this.title = new JLabel();
        this.content = new JPanel();
        this.popup.setLayout(new FlowLayout(1, 2, 2));
        this.popup.add(this.popupRootContent);
        this.popup.setBackground(SystemColor.control);
        this.popupRootContent.setLayout(new BorderLayout());
        this.popupRootContent.add((Component)this.title, "North");
        this.popupRootContent.add((Component)this.content, "Center");
        this.popupRootContent.setBackground(this.popup.getBackground());
        this.content.setBackground(this.popupRootContent.getBackground());
        this.title.setVisible(false);
        this.setSize(new Dimension(n, n2));
    }

    public final JPanel getContentPanel() {
        return this.content;
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.title.setText(string);
        this.title.setVisible(!string.isEmpty());
    }

    public Dimension getSize() {
        return this.popup.getSize();
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    public void setSize(Dimension dimension) throws IllegalArgumentException {
        if (dimension == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.popup.setSize(dimension);
        this.popupRootContent.setPreferredSize(dimension);
        this.content.setPreferredSize(dimension);
    }

    public void setSize(JComponent jComponent) throws IllegalArgumentException {
        if (jComponent == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setSize(jComponent.getPreferredSize().width + 4, jComponent.getPreferredSize().height + 4);
    }

    public void show(Component component, int n, int n2) {
        this.show(component, n, n2, 0);
    }

    public void show(Component component, int n, int n2, int n3) {
        this.popup.show(component, n, n2);
        if (n3 > 0) {
            Timer timer = new Timer(n3, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupWindow.this.popup.setVisible(false);
                }
            });
            timer.start();
        }
    }

    public void close() {
        this.popup.setVisible(false);
    }
}

