/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.utils;

import java.awt.Point;
import java.text.NumberFormat;

public class MathUtils {
    private MathUtils() {
    }

    public static String formatFloat(float f) {
        return MathUtils.formatDouble(f);
    }

    public static String formatDouble(double d) {
        int n = (int)d;
        return d % (double)n == 0.0 ? "" + n : NumberFormat.getInstance().format(d);
    }

    public static int max(int ... nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            n = Math.max(n, n2);
        }
        return n;
    }

    public static int ccw(int n, int n2, int n3, int n4, int n5, int n6) {
        double d = (n3 - n) * (n6 - n2) - (n5 - n) * (n4 - n2);
        if (Math.abs(d) <= 1.0E-8) {
            return 0;
        }
        return d > 0.0 ? 1 : -1;
    }

    public static int ccw(Point point, Point point2, Point point3) {
        return MathUtils.ccw(point.x, point.y, point2.x, point2.y, point3.x, point3.y);
    }
}

