/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import lavesdk.math.Matrix;
import lavesdk.math.NumericMatrix;
import lavesdk.math.Set;
import lavesdk.math.graph.DefaultGraphFactory;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.GraphFactory;
import lavesdk.math.graph.Path;
import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Trail;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;
import lavesdk.math.graph.enums.Type;
import lavesdk.math.graph.matching.Matching;
import lavesdk.utils.MutableNumber;

public class GraphUtils {
    private static final Random rand = new Random();

    private GraphUtils() {
    }

    public static <V extends Vertex, E extends Edge> boolean isSimpleGraph(Graph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (graph.getOrder() < 1) {
            return false;
        }
        for (int i = 0; i < graph.getSize(); ++i) {
            if (((Edge)graph.getEdge(i)).getPredecessor() != ((Edge)graph.getEdge(i)).getSuccessor()) continue;
            return false;
        }
        return !GraphUtils.isMultiGraph(graph);
    }

    public static <V extends Vertex, E extends Edge> boolean isMultiGraph(Graph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        for (int i = 0; i < graph.getOrder(); ++i) {
            V v = graph.getVertex(i);
            arrayList.clear();
            for (int j = 0; j < ((Vertex)v).getOutgoingEdgeCount(); ++j) {
                Vertex vertex = ((Vertex)v).getOutgoingEdge(j).getSuccessor((Vertex)v);
                if (arrayList.contains(vertex)) {
                    return true;
                }
                arrayList.add(vertex);
            }
        }
        return false;
    }

    public static <V extends Vertex, E extends Edge> boolean isBipartite(Graph<V, E> graph) throws IllegalArgumentException {
        return GraphUtils.isSimpleGraph(graph) && GraphUtils.is2Colorable(graph);
    }

    public static <V extends Vertex, E extends Edge> List<List<V>> getBipartiteVertexSets(Graph<V, E> graph) throws IllegalArgumentException {
        return GraphUtils.getBipartiteVertexSets(graph, true);
    }

    public static <V extends Vertex, E extends Edge> List<List<V>> getBipartiteVertexSets(Graph<V, E> graph, boolean bl) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        HashMap<Vertex, Integer> hashMap = new HashMap<Vertex, Integer>();
        if (!GraphUtils.is2Colorable(graph, hashMap, bl)) {
            return null;
        }
        ArrayList<List<V>> arrayList = new ArrayList<List<V>>(2);
        arrayList.add(new ArrayList());
        arrayList.add(new ArrayList());
        for (int i = 0; i < graph.getOrder(); ++i) {
            int n = (Integer)hashMap.get(graph.getVertex(i));
            ((List)arrayList.get(n - 1)).add(graph.getVertex(i));
        }
        return arrayList;
    }

    public static <V extends Vertex, E extends Edge> boolean is2Colorable(Graph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (graph.getOrder() == 0) {
            return false;
        }
        return GraphUtils.is2Colorable(graph, new HashMap<Vertex, Integer>(), true);
    }

    public static <V extends Vertex, E extends Edge> boolean isComplete(Graph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!GraphUtils.isSimpleGraph(graph)) {
            return false;
        }
        int n = graph.getType() == Type.DIRECTED ? (graph.getOrder() - 1) * 2 : graph.getOrder() - 1;
        for (int i = 0; i < graph.getOrder(); ++i) {
            if (((Vertex)graph.getVertex(i)).getDegree() == n) continue;
            return false;
        }
        return true;
    }

    public static <V extends Vertex, E extends Edge> boolean isCompleteBipartite(Graph<V, E> graph) throws IllegalArgumentException {
        int n;
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        List<List<V>> list = GraphUtils.getBipartiteVertexSets(graph);
        if (list == null) {
            return false;
        }
        if (!GraphUtils.isSimpleGraph(graph)) {
            return false;
        }
        int n2 = list.get(1).size();
        int n3 = list.get(0).size();
        for (n = 0; n < list.get(0).size(); ++n) {
            if (((Vertex)list.get(0).get(n)).getDegree() == n2) continue;
            return false;
        }
        for (n = 0; n < list.get(1).size(); ++n) {
            if (((Vertex)list.get(1).get(n)).getDegree() == n3) continue;
            return false;
        }
        return true;
    }

    public static <V extends Vertex, E extends Edge> List<List<V>> getConnectedComponents(Graph<V, E> graph) throws IllegalArgumentException {
        int n;
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        ArrayList<List<V>> arrayList = new ArrayList<List<V>>();
        MutableNumber<Integer> mutableNumber = new MutableNumber<Integer>(0);
        Stack<Integer> stack = new Stack<Integer>();
        int[] nArray = new int[graph.getOrder()];
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < graph.getOrder(); ++n) {
            if (nArray[n] != -1) continue;
            GraphUtils.computeConnectedComponents(graph, arrayList, graph.getVertex(n), stack, mutableNumber, nArray, nArray2);
        }
        return arrayList;
    }

    public static <V extends Vertex, E extends Edge> boolean isConnected(Graph<V, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return GraphUtils.getConnectedComponents(graph).size() == 1;
    }

    public static SimpleGraph<Vertex, Edge> createCompleteGraph(int n, boolean bl) throws IllegalArgumentException {
        return GraphUtils.createCompleteGraph(n, bl, new DefaultGraphFactory());
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createCompleteGraph(int n, boolean bl, GraphFactory<V, E> graphFactory) throws IllegalArgumentException {
        return GraphUtils.createCompleteGraph(n, bl, graphFactory, 0.0f);
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createCompleteGraph(int n, boolean bl, GraphFactory<V, E> graphFactory, float f) throws IllegalArgumentException {
        if (n < 1 || graphFactory == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph simpleGraph = new SimpleGraph(bl);
        for (int i = 1; i <= n; ++i) {
            simpleGraph.add((Object)graphFactory.createVertex("" + i));
        }
        for (int i = 0; i < simpleGraph.getOrder(); ++i) {
            Object v = simpleGraph.getVertex(i);
            for (int j = 0; j < simpleGraph.getOrder(); ++j) {
                Object v2 = simpleGraph.getVertex(j);
                if (v2 == v) continue;
                E e = graphFactory.createEdge(v, v2);
                if (f > 0.0f) {
                    ((Edge)e).setWeight(1 + rand.nextInt((int)f));
                }
                simpleGraph.add(e);
            }
        }
        return simpleGraph;
    }

    public static SimpleGraph<Vertex, Edge> createCompleteBipartiteGraph(int n, int n2) throws IllegalArgumentException {
        return GraphUtils.createCompleteBipartiteGraph(n, n2, new DefaultGraphFactory());
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createCompleteBipartiteGraph(int n, int n2, GraphFactory<V, E> graphFactory) throws IllegalArgumentException {
        return GraphUtils.createCompleteBipartiteGraph(n, n2, graphFactory, 0.0f);
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createCompleteBipartiteGraph(int n, int n2, GraphFactory<V, E> graphFactory, float f) throws IllegalArgumentException {
        if (n < 1 || n2 < 1 || graphFactory == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph simpleGraph = new SimpleGraph(false);
        for (int i = 1; i <= n + n2; ++i) {
            simpleGraph.add((Object)graphFactory.createVertex("" + i));
        }
        for (int i = 0; i < n; ++i) {
            for (int j = n; j < n2 + n; ++j) {
                E e = graphFactory.createEdge(simpleGraph.getVertex(i), simpleGraph.getVertex(j));
                if (f > 0.0f) {
                    ((Edge)e).setWeight(1 + rand.nextInt((int)f));
                }
                simpleGraph.add(e);
            }
        }
        return simpleGraph;
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createGraph(Matrix<? extends Number> matrix, GraphFactory<V, E> graphFactory, boolean bl) {
        return GraphUtils.createGraph(matrix, graphFactory, bl, false);
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createGraph(Matrix<? extends Number> matrix, GraphFactory<V, E> graphFactory, boolean bl, boolean bl2) {
        int n;
        if (matrix == null || !matrix.isSquare() || graphFactory == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph simpleGraph = new SimpleGraph(bl);
        for (n = 0; n < matrix.getRowCount(); ++n) {
            simpleGraph.add((Object)graphFactory.createVertex("" + (n + 1)));
        }
        for (n = 0; n < matrix.getRowCount(); ++n) {
            for (int i = 0; i < matrix.getColumnCount(); ++i) {
                Number number = matrix.get(n, i);
                if (number == null || !bl2 && number.floatValue() == 0.0f || bl2 && number.floatValue() == Float.POSITIVE_INFINITY) continue;
                simpleGraph.add(graphFactory.createEdge(simpleGraph.getVertex(n), simpleGraph.getVertex(i), number.floatValue()));
            }
        }
        return simpleGraph;
    }

    public static SimpleGraph<Vertex, Edge> createRandomGraph(int n, boolean bl) {
        return GraphUtils.createRandomGraph(n, bl, new DefaultGraphFactory());
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createRandomGraph(int n, boolean bl, GraphFactory<V, E> graphFactory) {
        return GraphUtils.createRandomGraph(n, bl, graphFactory, 0.0f, 0.0f);
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<V, E> createRandomGraph(int n, boolean bl, GraphFactory<V, E> graphFactory, float f, float f2) {
        if (n < 1 || graphFactory == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph simpleGraph = new SimpleGraph(bl);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < f) {
            f2 = f;
        }
        for (int i = 1; i <= n; ++i) {
            simpleGraph.add((Object)graphFactory.createVertex("" + i));
        }
        int n2 = bl ? 35 : 50;
        for (int i = 0; i < simpleGraph.getOrder(); ++i) {
            Object v = simpleGraph.getVertex(i);
            for (int j = 0; j < simpleGraph.getOrder(); ++j) {
                int n3;
                Object v2 = simpleGraph.getVertex(j);
                if (v2 == v || (n3 = rand.nextInt(100)) < n2) continue;
                E e = graphFactory.createEdge(v, v2);
                if (f2 > 0.0f) {
                    ((Edge)e).setWeight(rand.nextInt((int)(f2 - f) + 1) + (int)f);
                }
                simpleGraph.add(e);
            }
        }
        return simpleGraph;
    }

    public static Graph<Vertex, Edge> invertGraph(Graph<Vertex, Edge> graph) throws IllegalArgumentException {
        return GraphUtils.invertGraph(graph, new DefaultGraphFactory());
    }

    public static <V extends Vertex, E extends Edge> Graph<V, E> invertGraph(Graph<V, E> graph, GraphFactory<V, E> graphFactory) throws IllegalArgumentException {
        if (graph == null || graph.getType() == Type.MIXED || graphFactory == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Graph graph2 = new Graph(graph.getType() == Type.UNDIRECTED ? Type.DIRECTED : Type.UNDIRECTED);
        boolean bl = graph2.getType() == Type.DIRECTED;
        for (int i = 0; i < graph.getOrder(); ++i) {
            graph2.add((Object)graphFactory.createVertex(((Vertex)graph.getVertex(i)).getCaption()));
        }
        for (int i = 0; i < graph.getSize(); ++i) {
            E e = graph.getEdge(i);
            graph2.add(graphFactory.createEdge(graph2.getVertexByCaption(((Edge)e).getPredecessor().getCaption()), graph2.getVertexByCaption(((Edge)e).getSuccessor().getCaption()), bl, ((Edge)e).getWeight()));
        }
        return graph2;
    }

    public static <V extends Vertex, E extends Edge> NumericMatrix<Float> createAdjacencyMatrix(Graph<V, E> graph) throws IllegalArgumentException {
        return GraphUtils.createAdjacencyMatrix(graph, false);
    }

    public static <V extends Vertex, E extends Edge> NumericMatrix<Float> createAdjacencyMatrix(Graph<V, E> graph, boolean bl) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        NumericMatrix<Object> numericMatrix = new NumericMatrix<Object>(graph.getOrder(), graph.getOrder(), null);
        boolean bl2 = bl && graph.getType() == Type.UNDIRECTED && (GraphUtils.isComplete(graph) || GraphUtils.isCompleteBipartite(graph));
        for (int i = 0; i < graph.getOrder(); ++i) {
            int n;
            V v = graph.getVertex(i);
            for (int j = n = bl2 ? i : 0; j < graph.getOrder(); ++j) {
                V v2;
                E e;
                if (i == j || (e = graph.getEdge(v, v2 = graph.getVertex(j))) == null) continue;
                numericMatrix.set(i, j, Float.valueOf(((Edge)e).getWeight()));
            }
        }
        return numericMatrix;
    }

    public static <V extends Vertex, E extends Edge> void findShortestPathFrom(Graph<V, E> graph, V v, Map<V, Float> map, Map<V, V> map2) throws IllegalArgumentException {
        V v2;
        int n;
        if (graph == null || v == null || !graph.contains(v) || map == null || map2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Set<V> set = graph.getVertexSet();
        for (n = 0; n < graph.getOrder(); ++n) {
            v2 = graph.getVertex(n);
            map.put((Float)v2, Float.valueOf(Float.POSITIVE_INFINITY));
            map2.put(v2, null);
        }
        map.put((Float)((Object)v), Float.valueOf(0.0f));
        while (!set.isEmpty()) {
            float f = Float.POSITIVE_INFINITY;
            Vertex vertex = (Vertex)set.get(0);
            for (Vertex vertex2 : set) {
                if (!(map.get(vertex2).floatValue() < f)) continue;
                f = map.get(vertex2).floatValue();
                vertex = vertex2;
            }
            set.remove(vertex);
            for (n = 0; n < vertex.getOutgoingEdgeCount(); ++n) {
                float f2;
                Edge edge = vertex.getOutgoingEdge(n);
                v2 = graph.getVertex(edge.getSuccessor(vertex).getIndex());
                if (!set.contains(v2) || !((f2 = f + edge.getWeight()) < map.get(v2).floatValue())) continue;
                map.put((Float)v2, Float.valueOf(f2));
                map2.put(v2, vertex);
            }
        }
    }

    public static <V extends Vertex, E extends Edge> Path<V> findShortestPathFromTo(Graph<V, E> graph, V v, V v2) throws IllegalArgumentException {
        if (v2 == null || v == v2) {
            throw new IllegalArgumentException("No valid argument!");
        }
        HashMap hashMap = new HashMap();
        Path<V> path = new Path<V>(graph);
        GraphUtils.findShortestPathFrom(graph, v, new HashMap(), hashMap);
        Object object = v2;
        while (object != null) {
            V v3 = object;
            if ((object = (Vertex)hashMap.get(object)) == null && path.length() <= 0) continue;
            path.add(0, v3);
        }
        return path;
    }

    public static <V extends Vertex, E extends Edge> void findShortestPaths(Graph<V, E> graph, Matrix<Float> matrix, Matrix<V> matrix2) throws IllegalArgumentException {
        GraphUtils.findShortestPaths(graph, matrix, matrix2, false);
    }

    public static <V extends Vertex, E extends Edge> void findShortestPaths(Graph<V, E> graph, Matrix<Float> matrix, Matrix<V> matrix2, boolean bl) throws IllegalArgumentException {
        int n;
        int n2;
        if (graph == null || matrix == null || matrix2 == null || matrix.getRowCount() != graph.getOrder() || !matrix.isSquare() || matrix2.getRowCount() != graph.getOrder() || !matrix2.isSquare()) {
            throw new IllegalArgumentException("No valid argument!");
        }
        for (n2 = 0; n2 < graph.getOrder(); ++n2) {
            matrix.set(n2, n2, Float.valueOf(0.0f));
            matrix2.set(n2, n2, graph.getVertex(n2));
        }
        for (n2 = 0; n2 < graph.getOrder(); ++n2) {
            for (n = 0; n < graph.getOrder(); ++n) {
                if (n == n2) continue;
                E e = graph.getEdge(graph.getVertex(n2), graph.getVertex(n));
                if (e != null) {
                    matrix.set(n2, n, Float.valueOf(((Edge)e).getWeight()));
                    matrix2.set(n2, n, graph.getVertex(n2));
                    continue;
                }
                matrix.set(n2, n, Float.valueOf(Float.MAX_VALUE));
                matrix2.set(n2, n, null);
            }
        }
        for (n = 0; n < graph.getOrder(); ++n) {
            for (int i = 0; i < graph.getOrder(); ++i) {
                if (!bl && i == n) continue;
                for (int j = 0; j < graph.getOrder(); ++j) {
                    float f;
                    if (!bl && (j == n || j == i) || !((f = matrix.get(i, n).floatValue() + matrix.get(n, j).floatValue()) < matrix.get(i, j).floatValue())) continue;
                    matrix.set(i, j, Float.valueOf(f));
                    matrix2.set(i, j, matrix2.get(n, j));
                }
            }
        }
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<Vertex, Edge> breadthFirstSearch(Graph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return GraphUtils.breadthFirstSearch(graph, graph.getOrder() > 0 ? (V)graph.getVertex(0) : null);
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<Vertex, Edge> breadthFirstSearch(Graph<V, E> graph, V v) throws IllegalArgumentException {
        if (graph == null || v == null || !graph.contains(v)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph<Vertex, Edge> simpleGraph = new SimpleGraph<Vertex, Edge>(false);
        boolean[] blArray = new boolean[graph.getOrder()];
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        simpleGraph.add((Edge)((Object)new Vertex(v.getCaption())));
        blArray[v.getIndex()] = true;
        arrayList.add(v);
        while (!arrayList.isEmpty()) {
            Vertex vertex = (Vertex)arrayList.get(0);
            arrayList.remove(0);
            Object v2 = simpleGraph.getVertexByCaption(vertex.getCaption());
            for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
                Vertex vertex2 = vertex.getOutgoingEdge(i).getSuccessor(vertex);
                if (blArray[vertex2.getIndex()]) continue;
                Vertex vertex3 = new Vertex(vertex2.getCaption());
                simpleGraph.add((Edge)((Object)vertex3));
                blArray[vertex2.getIndex()] = true;
                arrayList.add(vertex2);
                simpleGraph.add(new Edge((Vertex)v2, vertex3));
            }
        }
        return simpleGraph;
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<Vertex, Edge> depthFirstSearch(Graph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return GraphUtils.depthFirstSearch(graph, graph.getOrder() > 0 ? (V)graph.getVertex(0) : null);
    }

    public static <V extends Vertex, E extends Edge> SimpleGraph<Vertex, Edge> depthFirstSearch(Graph<V, E> graph, V v) throws IllegalArgumentException {
        if (graph == null || v == null || !graph.contains(v)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph<Vertex, Edge> simpleGraph = new SimpleGraph<Vertex, Edge>(false);
        boolean[] blArray = new boolean[graph.getOrder()];
        GraphUtils.depthFirstSearch(graph, v, simpleGraph, blArray);
        return simpleGraph;
    }

    public static <V extends Vertex, E extends Edge> boolean isAugmentingPath(Path<V> path, Matching<E> matching) throws IllegalArgumentException {
        if (path == null || matching == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (path.isClosed() || path.length() < 1) {
            return false;
        }
        if (matching.isMatched((Vertex)path.get(0)) || matching.isMatched((Vertex)path.get(path.length()))) {
            return false;
        }
        for (int i = 1; i < path.length(); ++i) {
            if (matching.isMatched((Vertex)path.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <V extends Vertex, E extends Edge> Path<V> findAugmentingPath(Graph<V, E> graph, V v, Matching<E> matching) throws IllegalArgumentException {
        boolean[] blArray;
        Path<V> path;
        SimpleGraph<Vertex, Edge> simpleGraph = GraphUtils.createAugmentingPathTree(graph, v, matching);
        Object v2 = simpleGraph.getVertexByCaption(v.getCaption());
        if (GraphUtils.findUmatchedLeaf(graph, v2, matching, path = new Path<V>(graph), blArray = new boolean[simpleGraph.getOrder()])) {
            return path;
        }
        return null;
    }

    public static <V extends Vertex, E extends Edge> boolean isEulerian(Graph<V, E> graph) {
        if (!GraphUtils.isConnected(graph)) {
            return false;
        }
        switch (graph.getType()) {
            case UNDIRECTED: {
                for (int i = 0; i < graph.getOrder(); ++i) {
                    if (((Vertex)graph.getVertex(i)).getDegree() % 2 == 0) continue;
                    return false;
                }
                return true;
            }
            case DIRECTED: {
                for (int i = 0; i < graph.getOrder(); ++i) {
                    if (((Vertex)graph.getVertex(i)).getIndegree() == ((Vertex)graph.getVertex(i)).getOutdegree()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static <V extends Vertex> Walk<V> toWalk(String string, Graph<V, ?> graph) {
        Walk<V> walk = new Walk<V>(graph);
        if (!GraphUtils.convertWalk(string, walk, graph)) {
            return null;
        }
        return walk;
    }

    public static <V extends Vertex> Path<V> toPath(String string, Graph<V, ?> graph) {
        Path<V> path = new Path<V>(graph);
        if (!GraphUtils.convertWalk(string, path, graph)) {
            return null;
        }
        return path;
    }

    public static <V extends Vertex> Trail<V> toTrail(String string, Graph<V, ? extends Edge> graph, Trail<Vertex> trail) {
        Trail<Object> trail2 = new Trail<Object>(graph);
        Object v = null;
        string = string.substring((string = string.trim()).startsWith("(") ? 1 : 0, string.endsWith(")") ? string.length() - 1 : string.length());
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            Object v2;
            block6: {
                v2 = graph.getVertexByCaption(stringArray[i].trim());
                if (v2 == null) {
                    return null;
                }
                try {
                    if (trail == null || v == null) {
                        trail2.add(v2);
                        break block6;
                    }
                    List<Edge> list = graph.getEdges(v, v2);
                    for (Edge edge : list) {
                        if (trail.contains(edge) || trail2.contains(edge)) continue;
                        trail2.add(v2, edge);
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            v = v2;
        }
        return trail2;
    }

    private static <V extends Vertex, E extends Edge> boolean findUmatchedLeaf(Graph<V, E> graph, Vertex vertex, Matching<E> matching, Path<V> path, boolean[] blArray) {
        V v = graph.getVertexByCaption(vertex.getCaption());
        boolean bl = false;
        path.add(v);
        blArray[vertex.getIndex()] = true;
        for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
            Vertex vertex2 = vertex.getOutgoingEdge(i).getPredecessor(vertex);
            if (blArray[vertex2.getIndex()]) continue;
            V v2 = graph.getVertexByCaption(vertex2.getCaption());
            if (!matching.isMatched((Vertex)v2)) {
                path.add(v2);
                blArray[vertex2.getIndex()] = true;
                bl = true;
                break;
            }
            bl = GraphUtils.findUmatchedLeaf(graph, vertex2, matching, path, blArray);
            if (bl) break;
            path.removeLast();
        }
        return bl;
    }

    private static <V extends Vertex, E extends Edge> SimpleGraph<Vertex, Edge> createAugmentingPathTree(Graph<V, E> graph, V v, Matching<E> matching) throws IllegalArgumentException {
        if (graph == null || v == null || !graph.contains(v)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        SimpleGraph<Vertex, Edge> simpleGraph = new SimpleGraph<Vertex, Edge>(false);
        boolean[] blArray = new boolean[graph.getOrder()];
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        simpleGraph.add((Edge)((Object)new Vertex(v.getCaption())));
        blArray[v.getIndex()] = true;
        arrayList.add(v);
        arrayList2.add(false);
        while (!arrayList.isEmpty()) {
            Vertex vertex = (Vertex)arrayList.get(0);
            arrayList.remove(0);
            boolean bl = (Boolean)arrayList2.get(0);
            arrayList2.remove(0);
            Object v2 = simpleGraph.getVertexByCaption(vertex.getCaption());
            for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
                E e = graph.getEdgeByID(vertex.getOutgoingEdge(i).getID());
                Vertex vertex2 = ((Edge)e).getSuccessor(vertex);
                if (matching.contains(e) != bl || blArray[vertex2.getIndex()]) continue;
                Vertex vertex3 = new Vertex(vertex2.getCaption());
                simpleGraph.add((Edge)((Object)vertex3));
                blArray[vertex2.getIndex()] = true;
                arrayList.add(vertex2);
                arrayList2.add(!bl);
                simpleGraph.add(new Edge((Vertex)v2, vertex3));
            }
        }
        return simpleGraph;
    }

    private static <V extends Vertex, E extends Edge> void depthFirstSearch(Graph<V, E> graph, Vertex vertex, SimpleGraph<Vertex, Edge> simpleGraph, boolean[] blArray) {
        blArray[vertex.getIndex()] = true;
        simpleGraph.add((Edge)((Object)new Vertex(vertex.getCaption())));
        for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
            Vertex vertex2 = vertex.getOutgoingEdge(i).getSuccessor(vertex);
            if (blArray[vertex2.getIndex()]) continue;
            GraphUtils.depthFirstSearch(graph, vertex2, simpleGraph, blArray);
            simpleGraph.add(new Edge((Vertex)simpleGraph.getVertexByCaption(vertex.getCaption()), (Vertex)simpleGraph.getVertexByCaption(vertex2.getCaption())));
        }
    }

    private static <V extends Vertex, E extends Edge> boolean is2Colorable(Graph<V, E> graph, Map<Vertex, Integer> map, boolean bl) {
        int n;
        for (n = 0; n < graph.getOrder(); ++n) {
            map.put((Vertex)graph.getVertex(n), -1);
        }
        for (n = 0; n < graph.getOrder(); ++n) {
            if (map.get(graph.getVertex(n)) != -1 || GraphUtils.colorVertex(graph.getVertex(n), map, 1, 2, bl ? 1 : 2)) continue;
            return false;
        }
        return true;
    }

    private static boolean colorVertex(Vertex vertex, Map<Vertex, Integer> map, int n, int n2, int n3) {
        boolean bl = true;
        if (vertex.getIncomingEdgeCount() < 1 && vertex.getOutgoingEdgeCount() < 1) {
            map.put(vertex, n3);
        } else {
            map.put(vertex, n);
        }
        for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
            Vertex vertex2 = vertex.getOutgoingEdge(i).getSuccessor(vertex);
            int n4 = map.get(vertex2);
            if (n4 == n) {
                return false;
            }
            if (n4 == -1) {
                bl = GraphUtils.colorVertex(vertex2, map, n2, n, n3);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static <V extends Vertex, E extends Edge> void computeConnectedComponents(Graph<V, E> graph, List<List<V>> list, Vertex vertex, Stack<Integer> stack, MutableNumber<Integer> mutableNumber, int[] nArray, int[] nArray2) {
        nArray[vertex.getIndex()] = mutableNumber.value();
        nArray2[vertex.getIndex()] = mutableNumber.value();
        mutableNumber.value(mutableNumber.value() + 1);
        stack.push(vertex.getID());
        for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
            Vertex vertex2 = vertex.getOutgoingEdge(i).getSuccessor(vertex);
            if (nArray[vertex2.getIndex()] == -1) {
                GraphUtils.computeConnectedComponents(graph, list, vertex2, stack, mutableNumber, nArray, nArray2);
                nArray2[vertex.getIndex()] = Math.min(nArray2[vertex.getIndex()], nArray2[vertex2.getIndex()]);
                continue;
            }
            if (!stack.contains(vertex2.getID())) continue;
            nArray2[vertex.getIndex()] = Math.min(nArray2[vertex.getIndex()], nArray2[vertex2.getIndex()]);
        }
        if (nArray2[vertex.getIndex()] == nArray[vertex.getIndex()]) {
            V v;
            ArrayList<V> arrayList = new ArrayList<V>();
            do {
                if ((v = graph.getVertexByID(stack.pop())) == null) continue;
                arrayList.add(v);
            } while (v != vertex);
            list.add(arrayList);
        }
    }

    private static <V extends Vertex> boolean convertWalk(String string, Walk<V> walk, Graph<V, ?> graph) {
        String[] stringArray;
        string = string.substring((string = string.trim()).startsWith("(") ? 1 : 0, string.endsWith(")") ? string.length() - 1 : string.length());
        for (String string2 : stringArray = string.split(",")) {
            V v = graph.getVertexByCaption(string2 = string2.trim());
            if (v == null) {
                return false;
            }
            try {
                walk.add(v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return true;
    }
}

