/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.utils;

import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static final String FILESEPARATOR = System.getProperty("file.separator");
    public static final String USERHOMEDIR = System.getProperty("user.home") + FILESEPARATOR;
    public static final String LINESEPARATOR = System.getProperty("line.separator");

    private FileUtils() {
    }

    public static File createFilePath(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = FileUtils.getDirFromFilePath(string);
            File file2 = new File(string2);
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("could not create folders");
            }
            file.createNewFile();
        }
        return file;
    }

    public static String getDirFromFilePath(String string) throws IllegalArgumentException {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        int n = string.lastIndexOf(FILESEPARATOR);
        String string3 = string2 = n > 0 ? string.substring(0, n) : "";
        if (!string2.endsWith(FILESEPARATOR)) {
            string2 = string2 + FILESEPARATOR;
        }
        return string2;
    }

    public static boolean hasExtension(File file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return FileUtils.hasExtension(file.getAbsolutePath());
    }

    public static boolean hasExtension(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        int n = string.lastIndexOf(".");
        return n >= 0 && n > string.lastIndexOf(FILESEPARATOR);
    }

    public static File validateFile(File file, String string) throws IllegalArgumentException {
        if (file == null || string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (FileUtils.hasExtension(file)) {
            return file;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        return new File(file.getAbsolutePath() + string);
    }
}

