/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Serializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final String name;
    protected final HashMap<String, Object> data;

    protected Serializer(int n, String string) throws IllegalArgumentException {
        if (n < 1 || string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.id = n;
        this.name = string;
        this.data = new HashMap();
    }

    public final int getID() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final <T extends Serializable> T addObject(String string, T t) throws IllegalArgumentException {
        return this.addData(string, t);
    }

    public final <T extends Serializable> T getObject(String string) {
        return this.getObject(string, null);
    }

    public final <T extends Serializable> T getObject(String string, T t) {
        Object object = this.getData(string, Object.class, t);
        if (object == null) {
            return t;
        }
        try {
            Serializable serializable = (Serializable)object;
            return (T)serializable;
        }
        catch (ClassCastException classCastException) {
            return t;
        }
    }

    public final int addInt(String string, int n) throws IllegalArgumentException {
        return this.addData(string, n);
    }

    public final int getInt(String string) {
        return this.getInt(string, 0);
    }

    public final int getInt(String string, int n) {
        return this.getData(string, Integer.class, n);
    }

    public final String addString(String string, String string2) throws IllegalArgumentException {
        return this.addData(string, string2);
    }

    public final String getString(String string) {
        return this.getString(string, "");
    }

    public final String getString(String string, String string2) {
        Object object = this.data.get(string);
        if (object != null) {
            return object.toString();
        }
        return string2;
    }

    public final float addFloat(String string, float f) throws IllegalArgumentException {
        return this.addData(string, Float.valueOf(f)).floatValue();
    }

    public final float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public final float getFloat(String string, float f) {
        return this.getData(string, Float.class, Float.valueOf(f)).floatValue();
    }

    public final double addDouble(String string, double d) throws IllegalArgumentException {
        return this.addData(string, d);
    }

    public final double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public final double getDouble(String string, double d) {
        return this.getData(string, Double.class, d);
    }

    public final boolean addBoolean(String string, boolean bl) throws IllegalArgumentException {
        return this.addData(string, bl);
    }

    public final boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public final boolean getBoolean(String string, boolean bl) {
        return this.getData(string, Boolean.class, bl);
    }

    public final char addChar(String string, char c) throws IllegalArgumentException {
        return this.addData(string, Character.valueOf(c)).charValue();
    }

    public final char getChar(String string) {
        return this.getChar(string, ' ');
    }

    public final char getChar(String string, char c) {
        return this.getData(string, Character.class, Character.valueOf(c)).charValue();
    }

    public final Serializer addSerializer(String string, Serializer serializer) throws IllegalArgumentException {
        return this.addData(string, serializer);
    }

    public final Serializer getSerializer(String string) {
        return this.getData(string, Serializer.class);
    }

    public final <E extends Serializable> Collection<E> addCollection(String string, Collection<E> collection) throws IllegalArgumentException {
        return this.addData(string, collection);
    }

    public final <E> Collection<E> getCollection(String string) {
        return this.getCollection(string, null);
    }

    public final <E> Collection<E> getCollection(String string, Collection<E> collection) {
        Object object = this.data.get(string);
        if (object == null) {
            return collection;
        }
        try {
            Collection collection2 = (Collection)object;
            return collection2;
        }
        catch (ClassCastException classCastException) {
            return collection;
        }
    }

    public final <E extends Serializable> List<E> addList(String string, List<E> list) throws IllegalArgumentException {
        return this.addData(string, list);
    }

    public final <E> List<E> getList(String string) {
        return this.getList(string, null);
    }

    public final <E> List<E> getList(String string, List<E> list) {
        Object object = this.data.get(string);
        if (object == null) {
            return list;
        }
        try {
            List list2 = (List)object;
            return list2;
        }
        catch (ClassCastException classCastException) {
            return list;
        }
    }

    public final <T extends Serializable> T[] addArray(String string, T[] TArray) throws IllegalArgumentException {
        return (Serializable[])this.addData(string, TArray);
    }

    public final <T> T[] getArray(String string) {
        return this.getArray(string, null);
    }

    public final <T> T[] getArray(String string, T[] TArray) {
        Object object = this.data.get(string);
        if (object == null) {
            return TArray;
        }
        try {
            Object[] objectArray = (Object[])object;
            return objectArray;
        }
        catch (ClassCastException classCastException) {
            return TArray;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Serializer) {
            return this.equals((Serializer)object);
        }
        return false;
    }

    public boolean equals(Serializer serializer) {
        if (serializer == null) {
            return false;
        }
        return this.data.equals(serializer.data);
    }

    public boolean areKeysOverrideable() {
        return false;
    }

    public final String[] keys() {
        Set<String> set = this.data.keySet();
        Iterator<String> iterator = set.iterator();
        String[] stringArray = new String[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        return stringArray;
    }

    protected void checkKey(String string) throws IllegalArgumentException {
        if (string == null || !this.areKeysOverrideable() && this.data.containsKey(string)) {
            throw new IllegalArgumentException("No valid key!");
        }
    }

    protected final <T> T addData(String string, T t) {
        this.checkKey(string);
        this.data.put(string, t);
        return t;
    }

    protected final <T> T getData(String string, Class<T> clazz) {
        return this.getData(string, clazz, null);
    }

    protected final <T> T getData(String string, Class<T> clazz, T t) {
        Object object = this.data.get(string);
        if (object != null && clazz.isAssignableFrom(object.getClass())) {
            return clazz.cast(object);
        }
        return t;
    }

    protected final void removeData(String string) {
        this.data.remove(string);
    }

    protected byte[] freezeData() {
        return this.freezeData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] freezeData(StringBuilder stringBuilder) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = this.createObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.data);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            if (stringBuilder != null) {
                stringBuilder.append(iOException.toString());
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected ObjectOutputStream createObjectOutputStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        return new ObjectOutputStream(byteArrayOutputStream);
    }

    protected boolean unfreezeData(byte[] byArray) throws IllegalArgumentException {
        return this.unfreezeData(byArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unfreezeData(byte[] byArray, StringBuilder stringBuilder) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = this.createObjectInputStream(byteArrayInputStream);
            Map map = (Map)objectInputStream.readObject();
            this.data.clear();
            for (String string : map.keySet()) {
                this.data.put(string, map.get(string));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | ClassNotFoundException exception) {
            if (stringBuilder != null) {
                stringBuilder.append(exception.toString());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected ObjectInputStream createObjectInputStream(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return new ObjectInputStream(byteArrayInputStream);
    }
}

