/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.serialization;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lavesdk.serialization.Serializable;
import lavesdk.serialization.Serializer;
import lavesdk.utils.FileUtils;

public class ObjectFile {
    private final String filename;
    private final Map<Object, Serializer> serializers;
    private final Map<Integer, Object> objects;
    private final List<Integer> objectsOrder;
    private final List<Serializer> unallocatedSerializers;
    private final HashMap<String, Integer> serializerNameCount;
    private int nextID;

    public ObjectFile(File file) throws NullPointerException {
        this(file.getAbsolutePath());
    }

    public ObjectFile(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.filename = string;
        this.serializers = new HashMap<Object, Serializer>();
        this.objectsOrder = new ArrayList<Integer>();
        this.objects = new HashMap<Integer, Object>();
        this.unallocatedSerializers = new ArrayList<Serializer>();
        this.serializerNameCount = new HashMap();
        this.nextID = 1;
    }

    public final void load() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.filename);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        this.serializers.clear();
        this.objectsOrder.clear();
        this.objects.clear();
        this.unallocatedSerializers.clear();
        this.serializerNameCount.clear();
        try {
            Serializer serializer;
            int n = 0;
            ArrayList arrayList = (ArrayList)objectInputStream.readObject();
            for (n = 0; n < arrayList.size(); ++n) {
                serializer = (Serializer)arrayList.get(n);
                if (serializer == null) continue;
                this.unallocatedSerializers.add(serializer);
                this.incSerializerCount(serializer.getName());
            }
            int n2 = 0;
            for (n = 0; n < this.unallocatedSerializers.size(); ++n) {
                serializer = this.unallocatedSerializers.get(n);
                if (serializer.getID() <= n2) continue;
                n2 = serializer.getID();
            }
            if (n2 > this.nextID) {
                this.nextID = n2 + 1;
            }
        }
        catch (EOFException | ClassNotFoundException exception) {
            throw new IOException("File contains invalid data!");
        }
        finally {
            objectInputStream.close();
            fileInputStream.close();
        }
    }

    public final void save() throws IOException {
        File file = FileUtils.createFilePath(this.filename);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        ArrayList<Serializer> arrayList = new ArrayList<Serializer>(this.serializers.values().size());
        try {
            for (Integer n : this.objectsOrder) {
                Serializer serializer = this.serializers.get(this.objects.get(n));
                if (serializer != null) {
                    arrayList.add(serializer);
                    continue;
                }
                throw new IOException("Because of inconsistency the object file cannot be saved (illegal serializer (null))!");
            }
            objectOutputStream.writeObject(arrayList);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            objectOutputStream.close();
            fileOutputStream.close();
        }
    }

    public final int getSerializerCount(String string) {
        Integer n = this.serializerNameCount.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public final <T extends Serializable> Serializer getSerializer(T t, String string) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Serializer serializer = this.serializers.get(t);
        if (serializer == null) {
            boolean bl = false;
            for (int i = 0; i < this.unallocatedSerializers.size(); ++i) {
                Serializer serializer2 = this.unallocatedSerializers.get(i);
                if (!serializer2.getName().equals(string)) continue;
                serializer = serializer2;
                this.unallocatedSerializers.remove(i);
                break;
            }
            if (serializer == null) {
                serializer = new Serializer(this.nextID++, string);
                bl = true;
            }
            this.serializers.put(t, serializer);
            this.objects.put(serializer.getID(), t);
            this.objectsOrder.add(serializer.getID());
            if (bl) {
                this.incSerializerCount(string);
            }
        }
        return serializer;
    }

    public final Object getObject(int n) {
        return this.objects.get(n);
    }

    public final void updateObject(int n, Object object) throws IllegalArgumentException {
        if (!this.objects.containsKey(n) || object == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.objects.put(n, object);
    }

    public void incSerializerCount(String string) {
        Integer n = this.serializerNameCount.get(string);
        if (n == null) {
            n = 1;
        } else {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        this.serializerNameCount.put(string, n);
    }
}

