/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.sandbox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import lavesdk.LAVESDKV;
import lavesdk.algorithm.AlgorithmExerciseProvider;
import lavesdk.algorithm.AlgorithmRTE;
import lavesdk.algorithm.RTEListener;
import lavesdk.algorithm.RTEvent;
import lavesdk.algorithm.enums.AlgorithmStartOption;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.algorithm.plugin.PluginHost;
import lavesdk.algorithm.plugin.ResourceLoader;
import lavesdk.algorithm.plugin.ValidationReport;
import lavesdk.algorithm.plugin.Validator;
import lavesdk.algorithm.plugin.enums.MessageIcon;
import lavesdk.algorithm.plugin.extensions.ToolBarExtension;
import lavesdk.algorithm.plugin.views.ExercisesListView;
import lavesdk.algorithm.plugin.views.ViewContainer;
import lavesdk.algorithm.plugin.views.ViewGroup;
import lavesdk.algorithm.text.AlgorithmText;
import lavesdk.configuration.Configuration;
import lavesdk.gui.widgets.InformationBar;
import lavesdk.gui.widgets.Option;
import lavesdk.gui.widgets.OptionComboButton;
import lavesdk.language.LanguageFile;
import lavesdk.logging.LogFile;
import lavesdk.logging.enums.LogType;
import lavesdk.resources.Resources;
import lavesdk.utils.FileUtils;

public class Sandbox
extends JFrame
implements PluginHost {
    private static final long serialVersionUID = 1L;
    private final AlgorithmPlugin plugin;
    private final AlgorithmRTE rte;
    private LanguageFile langFile;
    private final String langID;
    private final Map<Integer, Float> execSpeedFactors;
    private final int normalExecSpeedKey;
    private final EventController eventController;
    private final JToolBar toolBar;
    private final JPanel contentPanel;
    private final InformationBar infoBar;
    private final ExercisesListView exercisesList;
    private final ViewGroup splitPane;
    private final ViewContainer viewContainer;
    private final JButton newBtn;
    private final JButton saveBtn;
    private final JButton openBtn;
    private final JButton modeBtn;
    private final OptionComboButton startBtn;
    private final Option startBtnNormal;
    private final Option startBtnToFinish;
    private final Option startBtnPlayPause;
    private final JButton pauseBtn;
    private final JButton stopBtn;
    private final JButton nextBtn;
    private final JButton prevBtn;
    private final JToggleButton skipBreakpointsBtn;
    private final JToggleButton pauseBeforeStopBtn;
    private final JSlider execSpeedSlider;
    private final JButton slowerBtn;
    private final JButton fasterBtn;
    private final JButton resetExecSpeedBtn;
    private final JLabel execSpeedLbl;
    private final LogFile logFile;
    private final String msgTitleExerciseMode;
    private final String msgInfoExerciseMode;
    private final boolean validPlugin;
    private static final int EXECSPEED_SLIDER_WIDTH = 100;

    public Sandbox(AlgorithmPlugin algorithmPlugin) throws IllegalArgumentException {
        this(algorithmPlugin, "en");
    }

    public Sandbox(AlgorithmPlugin algorithmPlugin, String string) throws IllegalArgumentException {
        LogFile logFile;
        if (algorithmPlugin == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            exception.printStackTrace();
        }
        this.plugin = algorithmPlugin;
        this.langID = string;
        this.langFile = Resources.getInstance().LANGUAGE_FILE;
        this.execSpeedFactors = new HashMap<Integer, Float>();
        this.normalExecSpeedKey = this.createExecSpeedFactors();
        try {
            logFile = new LogFile("log.txt");
        }
        catch (IOException iOException) {
            logFile = null;
        }
        this.logFile = logFile;
        this.msgTitleExerciseMode = LanguageFile.getLabel(this.langFile, "MSG_INFO_TITLE_EXERCISEMODE", string, "Exercise Mode");
        this.msgInfoExerciseMode = LanguageFile.getLabel(this.langFile, "MSG_INFO_EXERCISEMODE", string, "The exercise mode can only be activated when the algorithm is stopped!");
        algorithmPlugin.initialize(this, new ResourceLoader(algorithmPlugin.getClass().getClassLoader()), new Configuration());
        this.rte = algorithmPlugin.getRuntimeEnvironment();
        this.eventController = new EventController();
        this.contentPanel = new JPanel(new BorderLayout());
        this.infoBar = new InformationBar(this, this.langFile, string);
        this.exercisesList = new ExercisesListView(this.langFile, string);
        this.exercisesList.setVisible(false);
        this.viewContainer = new ViewContainer(0);
        this.splitPane = new ViewGroup(0, 4);
        this.splitPane.add(this.exercisesList);
        this.splitPane.add(this.viewContainer);
        this.splitPane.setWeights(new float[]{0.25f, 0.75f});
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.newBtn = new JButton(Resources.getInstance().NEW_ICON);
        this.newBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "FILE_NEW", string, "New..."));
        this.newBtn.addActionListener(this.eventController);
        this.saveBtn = new JButton(Resources.getInstance().SAVE_ICON);
        this.saveBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "FILE_SAVE_AS", string, "Save as..."));
        this.saveBtn.addActionListener(this.eventController);
        this.openBtn = new JButton(Resources.getInstance().OPEN_ICON);
        this.openBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "FILE_OPEN", string, "Open..."));
        this.openBtn.addActionListener(this.eventController);
        this.modeBtn = new JButton(Resources.getInstance().EXERCISE_MODE_ICON);
        this.modeBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXERCISE_MODE", string, "Exercise Mode"));
        this.modeBtn.addActionListener(this.eventController);
        this.startBtnNormal = new Option(Resources.getInstance().START_ICON, LanguageFile.getLabel(this.langFile, "RTE_START", string, "Start/Resume"));
        this.startBtnNormal.addActionListener(this.eventController);
        this.startBtnToFinish = new Option(Resources.getInstance().START_FINISH_ICON, LanguageFile.getLabel(this.langFile, "RTE_START_TO_FINISH", string, "Start/Resume to Finish"));
        this.startBtnToFinish.addActionListener(this.eventController);
        this.startBtnPlayPause = new Option(Resources.getInstance().PLAY_PAUSE_ICON, LanguageFile.getLabel(this.langFile, "RTE_PLAY_AND_PAUSE", string, "Play And Pause"));
        this.startBtnPlayPause.addActionListener(this.eventController);
        this.startBtn = new OptionComboButton(new Option[]{this.startBtnNormal, this.startBtnToFinish, this.startBtnPlayPause});
        this.stopBtn = new JButton(Resources.getInstance().STOP_ICON);
        this.stopBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_STOP", string, "Stop"));
        this.stopBtn.addActionListener(this.eventController);
        this.pauseBtn = new JButton(Resources.getInstance().PAUSE_ICON);
        this.pauseBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_PAUSE", string, "Pause"));
        this.pauseBtn.addActionListener(this.eventController);
        this.nextBtn = new JButton(Resources.getInstance().NEXTSTEP_ICON);
        this.nextBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_NEXT_STEP", string, "Next Step"));
        this.nextBtn.addActionListener(this.eventController);
        this.prevBtn = new JButton(Resources.getInstance().PREVSTEP_ICON);
        this.prevBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_PREV_STEP", string, "Previous Step"));
        this.prevBtn.addActionListener(this.eventController);
        this.skipBreakpointsBtn = new JToggleButton(Resources.getInstance().SKIP_BREAKPOINTS_ICON);
        this.skipBreakpointsBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_SKIP_BREAKPOINTS", string, "Skip All Breakpoints"));
        this.skipBreakpointsBtn.addActionListener(this.eventController);
        this.pauseBeforeStopBtn = new JToggleButton(Resources.getInstance().PAUSE_BEFORE_STOP_ICON);
        this.pauseBeforeStopBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_PAUSE_BEFORE_STOP", string, "Pause Before Stop"));
        this.pauseBeforeStopBtn.addActionListener(this.eventController);
        this.execSpeedSlider = new JSlider(1, this.execSpeedFactors.size(), this.normalExecSpeedKey);
        this.execSpeedSlider.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_CHANGE", string, "Change Execution Speed"));
        this.slowerBtn = new JButton(Resources.getInstance().SLOWER_ICON);
        this.slowerBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_SLOWER", string, "Slower"));
        this.slowerBtn.addActionListener(this.eventController);
        this.fasterBtn = new JButton(Resources.getInstance().FASTER_ICON);
        this.fasterBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_FASTER", string, "Faster"));
        this.fasterBtn.addActionListener(this.eventController);
        this.resetExecSpeedBtn = new JButton(Resources.getInstance().RESET_EXECSPEED_ICON);
        this.resetExecSpeedBtn.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED_RESET", string, "Reset Execution Speed"));
        this.resetExecSpeedBtn.addActionListener(this.eventController);
        this.execSpeedLbl = new JLabel(this.getExecSpeedFactorAsText(1.0f));
        this.execSpeedLbl.setToolTipText(LanguageFile.getLabel(this.langFile, "RTE_EXECSPEED", string, "Execution Speed"));
        this.setTitle("Sandbox - Plugin: " + algorithmPlugin.getName() + ", Plugin-Version: " + algorithmPlugin.getVersion() + " (LAVESDK-Version: " + LAVESDKV.CURRENT + ")");
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.contentPanel.add((Component)this.infoBar, "North");
        this.contentPanel.add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.toolBar.add(this.newBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(this.saveBtn);
        this.toolBar.add(this.openBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(this.modeBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(this.startBtn);
        this.toolBar.add(this.pauseBtn);
        this.toolBar.add(this.stopBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(this.prevBtn);
        this.toolBar.add(this.nextBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(this.pauseBeforeStopBtn);
        this.toolBar.add(this.skipBreakpointsBtn);
        this.toolBar.addSeparator();
        this.toolBar.add(this.slowerBtn);
        this.toolBar.add(this.execSpeedSlider);
        this.toolBar.add(this.fasterBtn);
        this.toolBar.add(this.execSpeedLbl);
        this.toolBar.add(this.resetExecSpeedBtn);
        Dimension dimension = new Dimension(100, this.execSpeedSlider.getPreferredSize().height);
        this.execSpeedSlider.setPreferredSize(dimension);
        this.execSpeedSlider.setMaximumSize(dimension);
        this.execSpeedSlider.setMinimumSize(dimension);
        this.execSpeedSlider.addChangeListener(this.eventController);
        this.saveBtn.setEnabled(algorithmPlugin.getSaveFileFilters() != null);
        this.openBtn.setEnabled(algorithmPlugin.getOpenFileFilters() != null);
        this.modeBtn.setEnabled(algorithmPlugin.hasExerciseMode());
        ValidationReport validationReport = Validator.validate(algorithmPlugin, false);
        if (!validationReport.ok) {
            JOptionPane.showMessageDialog(this, validationReport.message, "Invalid plugin", 0);
            this.validPlugin = validationReport.errorCount == 0;
        } else {
            this.validPlugin = true;
        }
        if (LAVESDKV.CURRENT.compareTo(algorithmPlugin.getUsedSDKVersion()) != 0) {
            JOptionPane.showMessageDialog(this, "The \"used SDK version\" property of the plugin returns a wrong version.\nThe plugin uses the SDK version " + LAVESDKV.CURRENT + " but the property returns version " + algorithmPlugin.getUsedSDKVersion() + "!", "Used SDK version", 2);
        }
        if (algorithmPlugin.getToolBarExtensions() != null) {
            for (ToolBarExtension toolBarExtension : algorithmPlugin.getToolBarExtensions()) {
                if (toolBarExtension == null) continue;
                toolBarExtension.apply(this.toolBar);
            }
        }
        if (this.rte != null) {
            this.rte.registerHost(this);
            this.rte.addListener(this.eventController);
        }
        this.checkRTECtrlsState();
        this.infoBar.update(algorithmPlugin);
        algorithmPlugin.onCreate(this.viewContainer, null);
    }

    @Override
    public String getLanguageID() {
        return this.langID;
    }

    @Override
    public LanguageFile getLanguageFile() {
        return this.langFile;
    }

    @Override
    public boolean isActivePlugin(AlgorithmPlugin algorithmPlugin) {
        return algorithmPlugin == this.plugin;
    }

    @Override
    public void showMessage(AlgorithmPlugin algorithmPlugin, String string, String string2, MessageIcon messageIcon) {
        if (!this.isActivePlugin(algorithmPlugin)) {
            return;
        }
        JOptionPane.showMessageDialog(this, string, string2, messageIcon.toMessageType());
    }

    @Override
    public void writeLogMessage(AlgorithmPlugin algorithmPlugin, String string, LogType logType) {
        this.writeLogMessage(algorithmPlugin, string, null, logType);
    }

    @Override
    public void writeLogMessage(AlgorithmPlugin algorithmPlugin, String string, Exception exception, LogType logType) {
        if (this.logFile != null) {
            this.logFile.writeToLog(algorithmPlugin, string, exception, logType);
        }
    }

    @Override
    public boolean checkPermission(PluginHost pluginHost) {
        return pluginHost == this;
    }

    @Override
    public AlgorithmExerciseProvider getDefaultExerciseProvider() {
        return this.exercisesList;
    }

    @Override
    public void rteModeChanged() {
        this.modeBtn.setSelected(this.rte.isExerciseModeEnabled());
        this.checkRTECtrlsState();
    }

    @Override
    public void adaptDialog(JDialog jDialog) {
        jDialog.setLocationRelativeTo(this);
    }

    @Override
    public int getPluginCount() {
        return 1;
    }

    @Override
    public String getPluginName(int n) throws IndexOutOfBoundsException {
        return this.plugin.getName();
    }

    @Override
    public String getPluginDescription(int n) throws IndexOutOfBoundsException {
        return this.plugin.getDescription();
    }

    @Override
    public String getPluginType(int n) throws IndexOutOfBoundsException {
        return this.plugin.getType();
    }

    @Override
    public String getPluginAuthor(int n) throws IndexOutOfBoundsException {
        return this.plugin.getAuthor();
    }

    @Override
    public String getPluginAuthorContact(int n) throws IndexOutOfBoundsException {
        return this.plugin.getAuthorContact();
    }

    @Override
    public String getPluginAssumptions(int n) throws IndexOutOfBoundsException {
        return this.plugin.getAssumptions();
    }

    @Override
    public String getPluginProblemAffiliation(int n) throws IndexOutOfBoundsException {
        return this.plugin.getProblemAffiliation();
    }

    @Override
    public String getPluginSubject(int n) throws IndexOutOfBoundsException {
        return this.plugin.getSubject();
    }

    @Override
    public String getPluginInstructions(int n) throws IndexOutOfBoundsException {
        return this.plugin.getInstructions();
    }

    @Override
    public String getPluginVersion(int n) throws IndexOutOfBoundsException {
        return this.plugin.getVersion();
    }

    @Override
    public AlgorithmText getPluginText(int n) throws IndexOutOfBoundsException {
        return this.plugin.getText();
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.validPlugin) {
            super.setVisible(bl);
        } else {
            this.dispose();
        }
    }

    private void updateExecSpeed() {
        float f = this.execSpeedFactors.get(this.execSpeedSlider.getValue()).floatValue();
        if (this.rte != null) {
            this.rte.setExecSpeedFactor(f);
        }
        this.execSpeedLbl.setText(this.getExecSpeedFactorAsText(f));
        this.execSpeedLbl.repaint();
    }

    private int createExecSpeedFactors() {
        this.execSpeedFactors.put(1, Float.valueOf(0.1f));
        this.execSpeedFactors.put(2, Float.valueOf(0.125f));
        this.execSpeedFactors.put(3, Float.valueOf(0.25f));
        this.execSpeedFactors.put(4, Float.valueOf(0.5f));
        this.execSpeedFactors.put(5, Float.valueOf(0.75f));
        int n = 6;
        this.execSpeedFactors.put(6, Float.valueOf(1.0f));
        this.execSpeedFactors.put(7, Float.valueOf(2.0f));
        this.execSpeedFactors.put(8, Float.valueOf(4.0f));
        this.execSpeedFactors.put(9, Float.valueOf(8.0f));
        this.execSpeedFactors.put(10, Float.valueOf(16.0f));
        return n;
    }

    private String getExecSpeedFactorAsText(float f) {
        int n = (int)f;
        String string = (float)n == f ? "" + n : "" + f;
        return string + "x";
    }

    private void checkRTECtrlsState() {
        boolean bl = this.rte != null;
        this.modeBtn.setEnabled(bl && this.plugin.hasExerciseMode());
        this.startBtn.setEnabled(bl && !this.rte.isRunning());
        this.pauseBtn.setEnabled(bl && this.rte.isRunning() && !this.rte.isExerciseModeEnabled());
        this.stopBtn.setEnabled(bl && this.rte.isStarted());
        this.nextBtn.setEnabled(bl && this.rte.isStarted() && !this.rte.isExerciseModeEnabled());
        this.prevBtn.setEnabled(bl && this.rte.isStarted() && !this.rte.isExerciseModeEnabled());
        this.skipBreakpointsBtn.setEnabled(bl);
        this.pauseBeforeStopBtn.setEnabled(bl);
        this.slowerBtn.setEnabled(bl);
        this.execSpeedSlider.setEnabled(bl);
        this.fasterBtn.setEnabled(bl);
    }

    private void doNew() {
        this.plugin.onClose();
        this.viewContainer.removeAll();
        this.viewContainer.revalidate();
        this.plugin.onCreate(this.viewContainer, null);
    }

    private void doSaveAs() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (FileNameExtensionFilter fileNameExtensionFilter : this.plugin.getSaveFileFilters()) {
            if (fileNameExtensionFilter == null) continue;
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)jFileChooser.getFileFilter();
            this.plugin.save(FileUtils.validateFile(jFileChooser.getSelectedFile(), fileNameExtensionFilter.getExtensions()[0]));
        }
    }

    private void doOpen() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (FileNameExtensionFilter fileNameExtensionFilter : this.plugin.getOpenFileFilters()) {
            if (fileNameExtensionFilter == null) continue;
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)jFileChooser.getFileFilter();
            this.plugin.open(FileUtils.validateFile(jFileChooser.getSelectedFile(), fileNameExtensionFilter.getExtensions()[0]));
        }
    }

    private void doChangeMode() {
        if (this.rte.isStarted()) {
            JOptionPane.showMessageDialog(this, this.msgInfoExerciseMode, this.msgTitleExerciseMode, 1);
            return;
        }
        this.rte.setExerciseModeEnabled(!this.rte.isExerciseModeEnabled());
    }

    private void doStart(AlgorithmStartOption algorithmStartOption) {
        if (this.rte == null) {
            return;
        }
        this.rte.start(algorithmStartOption);
    }

    private void doPause() {
        if (this.rte == null) {
            return;
        }
        this.rte.pause();
    }

    private void doStop() {
        if (this.rte == null) {
            return;
        }
        this.rte.stop();
    }

    private void doPrevStep() {
        if (this.rte == null) {
            return;
        }
        this.rte.prevStep();
    }

    private void doNextStep() {
        if (this.rte == null) {
            return;
        }
        this.rte.nextStep();
    }

    private void doSkipBreakpoints() {
        if (this.rte == null) {
            return;
        }
        this.rte.setSkipBreakpoints(this.skipBreakpointsBtn.isSelected());
    }

    private void doPauseBeforeStop() {
        if (this.rte == null) {
            return;
        }
        this.rte.setPauseBeforeTerminate(this.pauseBeforeStopBtn.isSelected());
    }

    private void setToolBarExtensionsState(boolean bl) {
        if (this.plugin.getToolBarExtensions() != null) {
            for (ToolBarExtension toolBarExtension : this.plugin.getToolBarExtensions()) {
                if (toolBarExtension == null) continue;
                toolBarExtension.setEnabled(bl);
            }
        }
    }

    private class EventController
    implements ActionListener,
    ChangeListener,
    RTEListener {
        private EventController() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == Sandbox.this.newBtn) {
                Sandbox.this.doNew();
            } else if (actionEvent.getSource() == Sandbox.this.saveBtn) {
                Sandbox.this.doSaveAs();
            } else if (actionEvent.getSource() == Sandbox.this.openBtn) {
                Sandbox.this.doOpen();
            } else if (actionEvent.getSource() == Sandbox.this.modeBtn) {
                Sandbox.this.doChangeMode();
            } else if (actionEvent.getSource() == Sandbox.this.startBtnNormal) {
                Sandbox.this.doStart(AlgorithmStartOption.NORMAL);
            } else if (actionEvent.getSource() == Sandbox.this.startBtnToFinish) {
                Sandbox.this.doStart(AlgorithmStartOption.START_TO_FINISH);
            } else if (actionEvent.getSource() == Sandbox.this.startBtnPlayPause) {
                Sandbox.this.doStart(AlgorithmStartOption.PLAY_AND_PAUSE);
            } else if (actionEvent.getSource() == Sandbox.this.pauseBtn) {
                Sandbox.this.doPause();
            } else if (actionEvent.getSource() == Sandbox.this.stopBtn) {
                Sandbox.this.doStop();
            } else if (actionEvent.getSource() == Sandbox.this.prevBtn) {
                Sandbox.this.doPrevStep();
            } else if (actionEvent.getSource() == Sandbox.this.nextBtn) {
                Sandbox.this.doNextStep();
            } else if (actionEvent.getSource() == Sandbox.this.skipBreakpointsBtn) {
                Sandbox.this.doSkipBreakpoints();
            } else if (actionEvent.getSource() == Sandbox.this.pauseBeforeStopBtn) {
                Sandbox.this.doPauseBeforeStop();
            } else if (actionEvent.getSource() == Sandbox.this.slowerBtn) {
                Sandbox.this.execSpeedSlider.setValue(Sandbox.this.execSpeedSlider.getValue() - 1);
            } else if (actionEvent.getSource() == Sandbox.this.fasterBtn) {
                Sandbox.this.execSpeedSlider.setValue(Sandbox.this.execSpeedSlider.getValue() + 1);
            } else if (actionEvent.getSource() == Sandbox.this.resetExecSpeedBtn) {
                Sandbox.this.execSpeedSlider.setValue(Sandbox.this.normalExecSpeedKey);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Sandbox.this.updateExecSpeed();
        }

        @Override
        public void beforeStart(RTEvent rTEvent) {
        }

        @Override
        public void beforeResume(RTEvent rTEvent) {
        }

        @Override
        public void beforePause(RTEvent rTEvent) {
        }

        @Override
        public void onStop() {
            Sandbox.this.checkRTECtrlsState();
            Sandbox.this.setToolBarExtensionsState(true);
        }

        @Override
        public void onRunning() {
            Sandbox.this.checkRTECtrlsState();
            Sandbox.this.setToolBarExtensionsState(false);
        }

        @Override
        public void onPause() {
            Sandbox.this.checkRTECtrlsState();
        }
    }
}

