/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph.network;

import java.util.List;
import lavesdk.math.graph.MultiGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.Network;
import lavesdk.math.graph.network.Node;
import lavesdk.math.graph.network.RNEdge;

public class ResidualNetwork
extends MultiGraph<Vertex, RNEdge> {
    private final Network<? extends Node, ? extends Arc> network;

    public ResidualNetwork(Network<? extends Node, ? extends Arc> network) throws IllegalArgumentException {
        super(true);
        if (network == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.network = network;
    }

    public Network<? extends Node, ? extends Arc> getNetwork() {
        return this.network;
    }

    @Override
    protected boolean isEdgeAllowed(RNEdge rNEdge) {
        List list = this.getEdges(rNEdge.getPredecessor(), rNEdge.getSuccessor());
        return list == null || list.size() < 2;
    }

    @Override
    protected void beforeEdgeAdded(RNEdge rNEdge) {
        super.beforeEdgeAdded(rNEdge);
        if (rNEdge.getRelationID() < 1) {
            rNEdge.setRelationID(this.findRelationIDOfNewEdge(rNEdge.getPredecessor(), rNEdge.getSuccessor()));
        }
    }

    @Override
    protected void afterEdgeRemoved(RNEdge rNEdge) {
        super.afterEdgeRemoved(rNEdge);
        List list = this.getEdges(rNEdge.getPredecessor(), rNEdge.getSuccessor());
        if (list != null) {
            for (RNEdge rNEdge2 : list) {
                if (rNEdge2.getRelationID() >= 0) continue;
                rNEdge2.setRelationID(this.findRelationIDOfNewEdge(rNEdge2.getPredecessor(), rNEdge2.getSuccessor()));
            }
        }
    }

    private int findRelationIDOfNewEdge(Vertex vertex, Vertex vertex2) {
        Node node = (Node)this.network.getVertexByCaption(vertex.getCaption());
        Node node2 = (Node)this.network.getVertexByCaption(vertex2.getCaption());
        if (node == null || node2 == null) {
            return -1;
        }
        Arc arc = (Arc)this.network.getEdge((Node)node.getID(), (Node)node2.getID());
        Arc arc2 = (Arc)this.network.getEdge((Node)node2.getID(), (Node)node.getID());
        int n = arc == null ? -1 : arc.getID();
        int n2 = arc2 == null ? -1 : arc2.getID();
        List list = this.getEdges(vertex, vertex2);
        if (list == null) {
            return n >= 0 ? n : n2;
        }
        if (list.size() == 1) {
            RNEdge rNEdge = (RNEdge)list.get(0);
            if (rNEdge.getRelationID() == n) {
                return n2;
            }
            if (rNEdge.getRelationID() == n2) {
                return n;
            }
            return n2 >= 0 ? n2 : n;
        }
        return -1;
    }
}

