/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph.network;

import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.Network;
import lavesdk.serialization.Serializer;

public class Node
extends Vertex {
    private float excess = 0.0f;
    private boolean hasExcess = true;

    public Node(String string) throws IllegalArgumentException {
        super(string);
    }

    @Override
    public Arc getIncomingEdge(int n) throws IndexOutOfBoundsException {
        return (Arc)super.getIncomingEdge(n);
    }

    @Override
    public Arc getOutgoingEdge(int n) throws IndexOutOfBoundsException {
        return (Arc)super.getOutgoingEdge(n);
    }

    @Override
    public void setCaption(String string) throws IllegalArgumentException {
        Graph<? extends Vertex, ? extends Edge> graph = this.getGraph();
        Network network = null;
        if (graph instanceof Network) {
            network = (Network)graph;
        }
        if (!(network == null || network.getSource() != this && network.getSink() != this || this.getCaption().isEmpty())) {
            return;
        }
        super.setCaption(string);
    }

    public float getExcess() {
        return this.excess;
    }

    public void setExcess(float f) {
        this.excess = this.hasExcess ? f : 0.0f;
    }

    public boolean hasExcess() {
        return this.hasExcess;
    }

    public static void determineExcess(Node node) throws IllegalArgumentException {
        int n;
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < node.getIncomingEdgeCount(); ++n) {
            f += node.getIncomingEdge(n).getFlow();
        }
        for (n = 0; n < node.getOutgoingEdgeCount(); ++n) {
            f2 += node.getOutgoingEdge(n).getFlow();
        }
        node.setExcess(f - f2);
    }

    @Override
    public void serialize(Serializer serializer) {
        super.serialize(serializer);
        serializer.addFloat("excess", this.excess);
        serializer.addBoolean("hasExcess", this.hasExcess);
    }

    @Override
    public void deserialize(Serializer serializer) {
        super.deserialize(serializer);
        this.excess = serializer.getFloat("excess");
        this.hasExcess = serializer.getBoolean("hasExcess", true);
    }

    void setHasExcess(boolean bl) {
        this.hasExcess = bl;
    }
}

