/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph.network;

import lavesdk.math.graph.SimpleGraph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Arc;
import lavesdk.math.graph.network.Node;
import lavesdk.math.graph.network.RNEdge;
import lavesdk.math.graph.network.ResidualNetwork;
import lavesdk.math.graph.network.enums.FlowType;

public class Network<V extends Node, E extends Arc>
extends SimpleGraph<V, E> {
    private final FlowType flowType;
    private final V source;
    private final V sink;

    public Network(FlowType flowType, V v, V v2) throws IllegalArgumentException {
        super(true);
        if (flowType == null || v == null || v2 == null || v == v2) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.flowType = flowType;
        this.source = v;
        this.sink = v2;
        this.add(v);
        this.add(v2);
        ((Node)v).setHasExcess(false);
        ((Node)v2).setHasExcess(false);
    }

    public final FlowType getFlowType() {
        return this.flowType;
    }

    public final V getSource() {
        return this.source;
    }

    public final V getSink() {
        return this.sink;
    }

    public void determineExcesses() {
        for (int i = 0; i < this.getOrder(); ++i) {
            Node.determineExcess((Node)this.getVertex(i));
        }
    }

    public boolean checkFlowConservationCondition() {
        block4: for (int i = 0; i < this.getOrder(); ++i) {
            int n;
            Node node = (Node)this.getVertex(i);
            if (node == this.source || node == this.sink) continue;
            float f = 0.0f;
            float f2 = 0.0f;
            for (n = 0; n < node.getIncomingEdgeCount(); ++n) {
                f += node.getIncomingEdge(n).getFlow();
            }
            for (n = 0; n < node.getOutgoingEdgeCount(); ++n) {
                f2 += node.getOutgoingEdge(n).getFlow();
            }
            switch (this.flowType) {
                case FLOW: {
                    if (f == f2) continue block4;
                    return false;
                }
                case PREFLOW: {
                    if (!(f < f2)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public ResidualNetwork getResidualNetwork() {
        int n;
        ResidualNetwork residualNetwork = new ResidualNetwork(this);
        residualNetwork.add(new Vertex(((Vertex)this.source).getCaption()));
        residualNetwork.add(new Vertex(((Vertex)this.sink).getCaption()));
        for (n = 0; n < this.getOrder(); ++n) {
            Node node = (Node)this.getVertex(n);
            if (node == this.source || node == this.sink) continue;
            residualNetwork.add(new Vertex(node.getCaption()));
        }
        for (n = 0; n < this.getSize(); ++n) {
            Arc arc = (Arc)this.getEdge(n);
            Object v = residualNetwork.getVertexByCaption(arc.getPredecessor().getCaption());
            Object v2 = residualNetwork.getVertexByCaption(arc.getSuccessor().getCaption());
            if (arc.getWeight() != arc.getFlow()) {
                residualNetwork.add(new RNEdge((Vertex)v, (Vertex)v2, arc.getWeight() - arc.getFlow(), arc.getID()));
            }
            if (!(arc.getFlow() > 0.0f)) continue;
            residualNetwork.add(new RNEdge((Vertex)v2, (Vertex)v, arc.getFlow(), arc.getID()));
        }
        return residualNetwork;
    }

    public float getFlowStrength() {
        int n;
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < ((Vertex)this.source).getIncomingEdgeCount(); ++n) {
            f += ((Node)this.source).getIncomingEdge(n).getFlow();
        }
        for (n = 0; n < ((Vertex)this.source).getOutgoingEdgeCount(); ++n) {
            f2 += ((Node)this.source).getOutgoingEdge(n).getFlow();
        }
        return f2 - f;
    }

    @Override
    protected boolean isRemovable(V v) {
        return v != this.source && v != this.sink;
    }
}

