/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph.network;

import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.network.Node;
import lavesdk.serialization.Serializer;
import lavesdk.utils.MathUtils;

public class Arc
extends Edge {
    private float flow;

    public Arc(Node node, Node node2) throws IllegalArgumentException {
        this(node, node2, 0.0f, 0.0f);
    }

    public Arc(Node node, Node node2, float f) throws IllegalArgumentException {
        this(node, node2, f, 0.0f);
    }

    public Arc(Node node, Node node2, float f, float f2) throws IllegalArgumentException {
        super(node, node2, true, f);
        this.setFlow(f2);
    }

    @Override
    public Node getPredecessor() {
        return (Node)super.getPredecessor();
    }

    @Override
    public Node getPredecessor(Vertex vertex) {
        return (Node)super.getPredecessor(vertex);
    }

    @Override
    public Node getSuccessor() {
        return (Node)super.getSuccessor();
    }

    @Override
    public Node getSuccessor(Vertex vertex) {
        return (Node)super.getSuccessor(vertex);
    }

    @Override
    public void setWeight(float f) throws IllegalArgumentException {
        if (f < 0.0f) {
            throw new IllegalArgumentException("No valid argument!");
        }
        super.setWeight(f);
        if (f < this.flow) {
            this.flow = f;
        }
    }

    public float getFlow() {
        return this.flow;
    }

    public void setFlow(float f) throws IllegalArgumentException {
        if (f > this.getWeight()) {
            throw new IllegalArgumentException("flow value is greater then the weight -> break of the flow preservation condition");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("flow value is less then the zero -> break of the flow preservation condition");
        }
        this.flow = f;
    }

    public boolean equals(Arc arc) {
        return super.equals(arc) && this.flow == arc.flow;
    }

    @Override
    public void serialize(Serializer serializer) {
        super.serialize(serializer);
        serializer.addFloat("flow", this.flow);
    }

    @Override
    public void deserialize(Serializer serializer) {
        super.deserialize(serializer);
        this.flow = serializer.getFloat("flow");
    }

    @Override
    public String toString() {
        return MathUtils.formatFloat(this.flow) + "/" + super.toString();
    }
}

