/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph.matching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.matching.Matching;

public class MatchingByID<E extends Edge>
extends Set<Integer>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Integer> vertices;
    private transient Graph<? extends Vertex, E> graph;

    public MatchingByID(Graph<? extends Vertex, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.vertices = new ArrayList<Integer>();
        this.graph = graph;
    }

    public MatchingByID(MatchingByID<E> matchingByID) {
        this.vertices = new ArrayList<Integer>();
        this.graph = matchingByID.graph;
        for (Integer n : matchingByID) {
            this.add(n);
        }
    }

    public void setGraph(Graph<? extends Vertex, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graph = graph;
    }

    @Override
    public boolean add(Integer n) throws UnsupportedOperationException, NullPointerException, IllegalArgumentException {
        return this.add((int)n);
    }

    @Override
    public boolean add(int n) throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        E e = this.graph.getEdgeByID(n);
        if (e == null) {
            throw new IllegalArgumentException("No valid argument");
        }
        if (this.vertices.contains(((Edge)e).getPredecessor().getID())) {
            throw new IllegalArgumentException("the predecessor of the edge is already matched meaning an endpoint of another edge in the matching");
        }
        if (this.vertices.contains(((Edge)e).getSuccessor().getID())) {
            throw new IllegalArgumentException("the successor of the edge is already matched meaning an endpoint of another edge in the matching");
        }
        if (super.add(n)) {
            this.vertices.add(((Edge)e).getPredecessor().getID());
            this.vertices.add(((Edge)e).getSuccessor().getID());
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) throws UnsupportedOperationException, NullPointerException, IllegalArgumentException {
        return this.add(((Edge)e).getID());
    }

    public void add(Vertex vertex, Vertex vertex2) throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        this.add(this.graph.getEdge((Vertex)vertex.getID(), (Vertex)vertex2.getID()));
    }

    @Override
    public boolean remove(Object object) throws UnsupportedOperationException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        if (super.remove(object) && object instanceof Integer) {
            E e = this.graph.getEdgeByID((Integer)object);
            if (e == null) {
                return false;
            }
            this.vertices.remove(((Edge)e).getPredecessor().getID());
            this.vertices.remove(((Edge)e).getSuccessor().getID());
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) throws UnsupportedOperationException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        if (collection == null) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object obj : collection) {
            E e;
            if (!(obj instanceof Integer) || (e = this.graph.getEdgeByID((Integer)obj)) == null) continue;
            arrayList.add(((Edge)e).getPredecessor().getID());
            arrayList.add(((Edge)e).getSuccessor().getID());
        }
        return super.retainAll(collection) && this.vertices.removeAll(arrayList);
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public int getVertexID(int n) throws UnsupportedOperationException, IndexOutOfBoundsException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        return this.vertices.get(n);
    }

    public boolean isMatched(Vertex vertex) throws UnsupportedOperationException, IllegalArgumentException {
        if (vertex == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return this.isMatched(vertex.getID());
    }

    public boolean isMatched(int n) throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        return this.vertices.contains(n);
    }

    public Matching<E> cast() throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("matching does not have an associated graph");
        }
        Matching<E> matching = new Matching<E>(this.graph);
        for (Integer n : this) {
            matching.add(this.graph.getEdgeByID(n));
        }
        return matching;
    }

    @Override
    public MatchingByID<E> clone() {
        return new MatchingByID<E>(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("{");
        for (Integer n : this) {
            Edge edge;
            if (bl) {
                stringBuilder.append(", ");
            }
            Edge edge2 = edge = this.graph != null ? (Edge)this.graph.getEdgeByID(n) : null;
            if (edge != null) {
                stringBuilder.append("(" + edge.getPredecessor().getCaption() + ", " + edge.getSuccessor().getCaption() + ")");
            }
            bl = true;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

