/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph.matching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.matching.MatchingByID;

public class Matching<E extends Edge>
extends Set<E> {
    private static final long serialVersionUID = 1L;
    private final Graph<? extends Vertex, E> graph;
    private final List<Vertex> vertices;

    public Matching(Graph<? extends Vertex, E> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graph = graph;
        this.vertices = new ArrayList<Vertex>();
    }

    public Matching(Matching<E> matching) {
        this.graph = matching.graph;
        this.vertices = new ArrayList<Vertex>();
        for (Edge edge : matching) {
            this.add((E)edge);
        }
    }

    @Override
    public boolean add(E e) throws NullPointerException, IllegalArgumentException {
        if (!this.graph.contains(e)) {
            throw new IllegalArgumentException("No valid argument");
        }
        if (this.vertices.contains(((Edge)e).getPredecessor())) {
            throw new IllegalArgumentException("the predecessor of the edge is already matched meaning an endpoint of another edge in the matching");
        }
        if (this.vertices.contains(((Edge)e).getSuccessor())) {
            throw new IllegalArgumentException("the successor of the edge is already matched meaning an endpoint of another edge in the matching");
        }
        if (super.add(e)) {
            this.vertices.add(((Edge)e).getPredecessor());
            this.vertices.add(((Edge)e).getSuccessor());
            return true;
        }
        return false;
    }

    public void add(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        this.add(this.graph.getEdge((Vertex)vertex.getID(), (Vertex)vertex2.getID()));
    }

    @Override
    public boolean remove(Object object) {
        if (super.remove(object) && object instanceof Edge) {
            Edge edge = (Edge)object;
            this.vertices.remove(edge.getPredecessor());
            this.vertices.remove(edge.getSuccessor());
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection == null) {
            return false;
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        for (Object obj : collection) {
            if (!(obj instanceof Edge)) continue;
            Edge edge = (Edge)obj;
            arrayList.add(edge.getPredecessor());
            arrayList.add(edge.getSuccessor());
        }
        return super.retainAll(collection) && this.vertices.removeAll(arrayList);
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public Vertex getVertex(int n) throws IndexOutOfBoundsException {
        return this.vertices.get(n);
    }

    public boolean isMatched(Vertex vertex) throws IllegalArgumentException {
        if (vertex == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return this.vertices.contains(vertex);
    }

    public MatchingByID<E> cast() {
        MatchingByID<E> matchingByID = new MatchingByID<E>(this.graph);
        for (Edge edge : this) {
            matchingByID.add(edge.getID());
        }
        return matchingByID;
    }

    @Override
    public Matching<E> clone() {
        return new Matching<E>(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("{");
        for (Edge edge : this) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("(" + edge.getPredecessor().getCaption() + ", " + edge.getSuccessor().getCaption() + ")");
            bl = true;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

