/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;

public class WalkByID<V extends Vertex>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<Integer> vertices;
    protected transient Graph<V, ? extends Edge> graph;
    private float weight;

    public WalkByID(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        this(graph, (List<Integer>)null);
    }

    public WalkByID(Graph<V, ? extends Edge> graph, Integer[] integerArray) throws IllegalArgumentException {
        this(graph, WalkByID.toList(integerArray));
    }

    public WalkByID(Graph<V, ? extends Edge> graph, List<Integer> list) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.vertices = new ArrayList<Integer>();
        this.graph = graph;
        this.weight = 0.0f;
        if (list != null) {
            for (Integer n : list) {
                this.add(n);
            }
        }
    }

    public void setGraph(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.graph = graph;
    }

    public void add(int n) throws UnsupportedOperationException, IllegalArgumentException {
        Integer n2;
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        if (this.graph.getVertexByID(n) == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Integer n3 = n2 = this.vertices.size() > 0 ? this.vertices.get(this.vertices.size() - 1) : null;
        if (n2 != null && this.graph.getEdge(n2.intValue(), n) == null) {
            throw new IllegalArgumentException("there is no edge between the given vertex and the last added vertex");
        }
        this.vertices.add(n);
        this.updateWeight();
    }

    public void add(V v) throws UnsupportedOperationException, IllegalArgumentException {
        if (v == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.add(((Vertex)v).getID());
    }

    public void removeLast() throws UnsupportedOperationException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        if (this.vertices.size() > 0) {
            this.vertices.remove(this.vertices.size() - 1);
        }
        this.updateWeight();
    }

    public int length() {
        return this.vertices.size() > 0 ? this.vertices.size() - 1 : 0;
    }

    public Integer get(int n) throws UnsupportedOperationException, IndexOutOfBoundsException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        return this.vertices.get(n);
    }

    public boolean contains(int n) throws UnsupportedOperationException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        return this.vertices.contains(n);
    }

    public boolean contains(V v) throws UnsupportedOperationException {
        return v != null && this.contains(((Vertex)v).getID());
    }

    public boolean contains(Edge edge) {
        if (edge == null || edge.getGraph() != this.graph) {
            return false;
        }
        for (int i = 0; i < this.vertices.size() - 1; ++i) {
            int n = this.vertices.get(i);
            int n2 = this.vertices.get(i + 1);
            if (edge.isDirected() && n == edge.getPredecessor().getID() && n2 == edge.getSuccessor().getID()) {
                return true;
            }
            if (edge.isDirected() || (n != edge.getPredecessor().getID() || n2 != edge.getSuccessor().getID()) && (n != edge.getSuccessor().getID() || n2 != edge.getPredecessor().getID())) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        return this.vertices.size() > 1 ? this.vertices.get(0) == this.vertices.get(this.vertices.size() - 1) : false;
    }

    public float getWeight() {
        return this.weight;
    }

    public Walk<V> cast() throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        Walk<V> walk = new Walk<V>(this.graph);
        for (Integer n : this.vertices) {
            walk.add(this.graph.getVertexByID(n));
        }
        return walk;
    }

    public List<Integer> asList() {
        return (List)((ArrayList)this.vertices).clone();
    }

    public boolean equals(Object object) {
        if (object instanceof WalkByID) {
            try {
                return this.equals((WalkByID)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(WalkByID<V> walkByID) {
        return walkByID != null ? this.vertices.equals(walkByID.vertices) : false;
    }

    public WalkByID<V> clone() {
        return new WalkByID<V>(this.graph, this.vertices);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("(");
        for (Integer n : this.vertices) {
            V v;
            if (bl) {
                stringBuilder.append(", ");
            }
            if ((v = this.graph.getVertexByID(n)) != null) {
                stringBuilder.append(((Vertex)v).getCaption());
            }
            bl = true;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected static List<Integer> toList(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(integerArray.length);
        for (Integer n : integerArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    protected void updateWeight() {
        this.weight = 0.0f;
        for (int i = 1; i < this.vertices.size(); ++i) {
            Edge edge = this.graph.getEdge(this.vertices.get(i - 1).intValue(), this.vertices.get(i).intValue());
            if (edge == null) continue;
            this.weight += edge.getWeight();
        }
    }
}

