/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.ArrayList;
import java.util.List;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.WalkByID;

public class Walk<V extends Vertex>
implements Cloneable {
    protected final List<V> vertices;
    protected final Graph<V, ? extends Edge> graph;
    private float weight;

    public Walk(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        this(graph, (List)null);
    }

    public Walk(Graph<V, ? extends Edge> graph, V[] VArray) throws IllegalArgumentException {
        this(graph, Walk.toList(VArray));
    }

    public Walk(Graph<V, ? extends Edge> graph, List<V> list) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.vertices = new ArrayList<V>();
        this.graph = graph;
        this.weight = 0.0f;
        if (list != null) {
            for (Vertex vertex : list) {
                this.add(vertex);
            }
        }
    }

    public void add(V v) throws IllegalArgumentException {
        this.addImpl(this.vertices.size(), v);
    }

    public void add(int n, V v) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.addImpl(n, v);
    }

    public void insert(Walk<V> walk, boolean bl) throws IllegalArgumentException {
        Object var3_3;
        Object v0 = var3_3 = walk.length() > 0 ? walk.get(0) : null;
        if (var3_3 == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.vertices.get(i) != var3_3) continue;
            ++n;
        }
        this.insert(walk, bl ? n : 1);
    }

    public void insert(Walk<V> walk, int n) throws IllegalArgumentException {
        if (walk == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (!walk.isClosed()) {
            throw new IllegalArgumentException("walk has to be closed");
        }
        if (walk.graph != this.graph) {
            throw new IllegalArgumentException("walk has a different associated graph");
        }
        V v = walk.get(0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (this.vertices.get(i) != v) continue;
            arrayList.add(i);
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("the start vertex of the walk is not contained in this walk");
        }
        if (n < 1 || n > arrayList.size()) {
            throw new IllegalArgumentException("the index is invalid");
        }
        this.insertImpl((Integer)arrayList.get(n - 1), walk);
    }

    public void removeLast() {
        if (this.vertices.size() > 0) {
            this.vertices.remove(this.vertices.size() - 1);
        }
        this.updateWeight();
    }

    public int length() {
        return this.vertices.size() > 0 ? this.vertices.size() - 1 : 0;
    }

    public V get(int n) throws IndexOutOfBoundsException {
        return (V)((Vertex)this.vertices.get(n));
    }

    public boolean contains(V v) {
        return v != null && ((Vertex)v).getGraph() == this.graph && this.vertices.contains(v);
    }

    public boolean contains(Edge edge) {
        if (edge == null || edge.getGraph() != this.graph) {
            return false;
        }
        for (int i = 0; i < this.vertices.size() - 1; ++i) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            Vertex vertex2 = (Vertex)this.vertices.get(i + 1);
            if (edge.isDirected() && vertex == edge.getPredecessor() && vertex2 == edge.getSuccessor()) {
                return true;
            }
            if (edge.isDirected() || (vertex != edge.getPredecessor() || vertex2 != edge.getSuccessor()) && (vertex != edge.getSuccessor() || vertex2 != edge.getPredecessor())) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        return this.vertices.size() > 1 ? this.vertices.get(0) == this.vertices.get(this.vertices.size() - 1) : false;
    }

    public float getWeight() {
        return this.weight;
    }

    public WalkByID<V> cast() throws IllegalArgumentException {
        WalkByID<V> walkByID = new WalkByID<V>(this.graph);
        for (Vertex vertex : this.vertices) {
            walkByID.add(vertex.getID());
        }
        return walkByID;
    }

    public List<V> asList() {
        return (List)((ArrayList)this.vertices).clone();
    }

    public boolean equals(Object object) {
        if (object instanceof Walk) {
            try {
                return this.equals((Walk)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(Walk<V> walk) {
        return walk != null ? this.vertices.equals(walk.vertices) : false;
    }

    public Walk<V> clone() {
        return new Walk<V>(this.graph, this.vertices);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("(");
        for (Vertex vertex : this.vertices) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(vertex);
            bl = true;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected void addImpl(int n, V v) throws IllegalArgumentException, IndexOutOfBoundsException {
        Vertex vertex;
        if (v == null || ((Vertex)v).getGraph() != this.graph) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Vertex vertex2 = n > 0 ? (Vertex)this.vertices.get(n - 1) : null;
        Vertex vertex3 = vertex = n < this.vertices.size() ? (Vertex)this.vertices.get(n) : null;
        if (vertex2 != null && this.graph.getEdge(vertex2, (Vertex)v) == null) {
            throw new IllegalArgumentException("there is no edge between the given vertex " + v + " and the predecessor " + vertex2);
        }
        if (vertex != null && this.graph.getEdge((Vertex)v, vertex) == null) {
            throw new IllegalArgumentException("there is no edge between the given vertex " + v + " and the successor " + vertex);
        }
        this.vertices.add(n, v);
        this.updateWeight();
    }

    protected void insertImpl(int n, Walk<V> walk) {
        for (int i = 1; i <= walk.length(); ++i) {
            this.addImpl(n + i, walk.get(i));
        }
    }

    protected static <V extends Vertex> List<V> toList(V[] VArray) {
        if (VArray == null) {
            return null;
        }
        ArrayList<V> arrayList = new ArrayList<V>(VArray.length);
        for (V v : VArray) {
            arrayList.add(v);
        }
        return arrayList;
    }

    protected void updateWeight() {
        this.weight = 0.0f;
        for (int i = 1; i < this.vertices.size(); ++i) {
            Edge edge = this.graph.getEdge((Vertex)this.vertices.get(i - 1), (Vertex)this.vertices.get(i));
            if (edge == null) continue;
            this.weight += edge.getWeight();
        }
    }
}

