/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.ArrayList;
import java.util.List;
import lavesdk.math.Set;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.enums.Type;
import lavesdk.serialization.Serializable;
import lavesdk.serialization.Serializer;

public class Vertex
implements Serializable {
    private String caption;
    private final List<Edge> incomingEdges;
    private final List<Edge> outgoingEdges;
    private final Set<Edge> incidentEdges;
    private Graph<? extends Vertex, ? extends Edge> graph;
    private int id;
    private int index;

    public Vertex(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.incomingEdges = new ArrayList<Edge>();
        this.outgoingEdges = new ArrayList<Edge>();
        this.incidentEdges = new Set();
        this.caption = string;
        this.graph = null;
        this.id = -1;
        this.index = -1;
    }

    public final int getID() {
        return this.id;
    }

    public final int getIndex() {
        return this.index;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (this.graph != null && this.graph.existVertexCaption(string)) {
            return;
        }
        this.caption = string;
    }

    public int getIncomingEdgeCount() {
        return this.incomingEdges.size();
    }

    public Edge getIncomingEdge(int n) throws IndexOutOfBoundsException {
        return this.incomingEdges.get(n);
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public Edge getOutgoingEdge(int n) throws IndexOutOfBoundsException {
        return this.outgoingEdges.get(n);
    }

    public int getIncidentEdgeCount() {
        return this.incidentEdges.size();
    }

    public Edge getIncidentEdge(int n) throws IndexOutOfBoundsException {
        return this.incidentEdges.get(n);
    }

    public int getDegree() {
        if (this.graph.getType() == Type.DIRECTED) {
            return this.getOutdegree() + this.getIndegree();
        }
        return this.outgoingEdges.size() + this.getLoopCount();
    }

    public int getIndegree() {
        return this.incomingEdges.size();
    }

    public int getOutdegree() {
        return this.outgoingEdges.size();
    }

    public String toString() {
        return this.caption;
    }

    public boolean equals(Vertex vertex) {
        return vertex != null && vertex.caption.equals(this.caption);
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex) {
            return this.equals((Vertex)object);
        }
        return false;
    }

    @Override
    public void serialize(Serializer serializer) {
        serializer.addString("caption", this.caption);
    }

    @Override
    public void deserialize(Serializer serializer) {
        String string = serializer.getString("caption");
        if (this.graph == null || !this.graph.existVertexCaption(string)) {
            this.caption = string;
        }
    }

    protected final Graph<? extends Vertex, ? extends Edge> getGraph() {
        return this.graph;
    }

    final void setID(int n) {
        this.id = n;
    }

    final void setIndex(int n) {
        this.index = n;
    }

    void addIncomingEdge(Edge edge) {
        if (edge != null) {
            this.incomingEdges.add(edge);
            this.incidentEdges.add(edge);
        }
    }

    void removeIncomingEdge(Edge edge) {
        this.incomingEdges.remove(edge);
        this.incidentEdges.remove(edge);
    }

    void addOutgoingEdge(Edge edge) {
        if (edge != null) {
            this.outgoingEdges.add(edge);
            this.incidentEdges.add(edge);
        }
    }

    void removeOutgoingEdge(Edge edge) {
        this.outgoingEdges.remove(edge);
        this.incidentEdges.remove(edge);
    }

    final void setGraph(Graph<? extends Vertex, ? extends Edge> graph) {
        this.graph = graph;
    }

    private int getLoopCount() {
        int n = 0;
        for (Edge edge : this.outgoingEdges) {
            if (edge.getSuccessor(this) != this) continue;
            ++n;
        }
        return n;
    }
}

