/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.ArrayList;
import java.util.List;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Trail;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.WalkByID;

public class TrailByID<V extends Vertex>
extends WalkByID<V> {
    private static final long serialVersionUID = 1L;
    private final List<Integer> edges = new ArrayList<Integer>();

    public TrailByID(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        this(graph, (List<Integer>)null);
    }

    public TrailByID(Graph<V, ? extends Edge> graph, Integer[] integerArray) throws IllegalArgumentException {
        this(graph, TrailByID.toList(integerArray));
    }

    public TrailByID(Graph<V, ? extends Edge> graph, List<Integer> list) throws IllegalArgumentException {
        super(graph, (List<Integer>)null);
        if (list != null) {
            for (Integer n : list) {
                this.add(n);
            }
        }
    }

    @Override
    public void add(int n) throws UnsupportedOperationException, IllegalArgumentException {
        this.add(n, 0);
    }

    public void add(int n, int n2) throws UnsupportedOperationException, IllegalArgumentException {
        ArrayList<Integer> arrayList;
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        Integer n3 = this.vertices.size() > 0 ? (Integer)this.vertices.get(this.vertices.size() - 1) : null;
        List list = n3 != null ? this.graph.getEdges(n3.intValue(), n) : null;
        ArrayList<Integer> arrayList2 = arrayList = list != null ? new ArrayList<Integer>() : null;
        if (list != null) {
            for (Edge object : list) {
                arrayList.add(object.getID());
            }
        }
        if (n2 > 0 && !arrayList.contains(n2)) {
            throw new IllegalArgumentException("the specified edge is not incident to the specified vertex");
        }
        if (arrayList != null && this.edges.containsAll(arrayList)) {
            throw new IllegalArgumentException("the trail already contains all edges between the vertices with the identifiers " + n3 + " and " + n);
        }
        super.add(n);
        if (arrayList != null) {
            for (Integer n4 : arrayList) {
                if (this.edges.contains(n4) || n2 >= 1 && n2 != n4) continue;
                this.edges.add(n4);
                break;
            }
        }
    }

    @Override
    public void removeLast() throws UnsupportedOperationException {
        super.removeLast();
        if (this.edges.size() > 0) {
            this.edges.remove(this.edges.size() - 1);
        }
    }

    @Override
    public boolean contains(Edge edge) {
        return edge != null && edge.getGraph() == this.graph && this.edges.contains(edge.getID());
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    @Override
    public Trail<V> cast() throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        Trail trail = new Trail(this.graph);
        for (int i = 0; i < this.vertices.size(); ++i) {
            trail.add(this.graph.getVertexByID((Integer)this.vertices.get(i)), i > 0 ? (Edge)this.graph.getEdgeByID(this.edges.get(i - 1)) : null);
        }
        return trail;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TrailByID) {
            try {
                return this.equals((TrailByID)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean equals(TrailByID<V> trailByID) {
        return trailByID != null ? this.vertices.equals(trailByID.vertices) && this.edges.equals(trailByID.edges) : false;
    }

    @Override
    public TrailByID<V> clone() {
        return new TrailByID<V>(this.graph, this.vertices);
    }
}

