/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.ArrayList;
import java.util.List;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.TrailByID;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;

public class Trail<V extends Vertex>
extends Walk<V> {
    private final List<Integer> edges = new ArrayList<Integer>();
    private Edge useEdge = null;

    public Trail(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        this(graph, (List)null);
    }

    public Trail(Graph<V, ? extends Edge> graph, V[] VArray) throws IllegalArgumentException {
        this(graph, Trail.toList(VArray));
    }

    public Trail(Graph<V, ? extends Edge> graph, List<V> list) throws IllegalArgumentException {
        super(graph, (List)null);
        if (list != null) {
            for (Vertex vertex : list) {
                this.add(vertex);
            }
        }
    }

    @Override
    public void add(V v) throws IllegalArgumentException {
        super.add(v);
    }

    @Override
    public void add(int n, V v) throws IllegalArgumentException, IndexOutOfBoundsException {
        super.add(n, v);
    }

    public void add(V v, Edge edge) throws IllegalArgumentException {
        if (edge != null && edge.getGraph() != this.graph) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.useEdge = edge;
        super.add(v);
    }

    @Override
    public void insert(Walk<V> walk, boolean bl) throws IllegalArgumentException {
        super.insert(walk, bl);
    }

    @Override
    public void insert(Walk<V> walk, int n) throws IllegalArgumentException {
        super.insert(walk, n);
    }

    @Override
    public void removeLast() {
        super.removeLast();
        if (this.edges.size() > 0) {
            this.edges.remove(this.edges.size() - 1);
        }
    }

    public Edge getEdge(int n) throws IndexOutOfBoundsException {
        return this.graph.getEdgeByID(this.edges.get(n));
    }

    @Override
    public boolean contains(Edge edge) {
        return edge != null && edge.getGraph() == this.graph && this.edges.contains(edge.getID());
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    @Override
    public TrailByID<V> cast() throws IllegalArgumentException {
        TrailByID trailByID = new TrailByID(this.graph);
        for (int i = 0; i < this.vertices.size(); ++i) {
            trailByID.add(((Vertex)this.vertices.get(i)).getID(), i > 0 ? this.edges.get(i - 1) : 0);
        }
        return trailByID;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Trail) {
            try {
                return this.equals((Trail)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Trail<V> trail) {
        return trail != null ? this.vertices.equals(trail.vertices) && this.edges.equals(trail.edges) : false;
    }

    @Override
    public Trail<V> clone() {
        return new Trail<V>(this.graph, this.vertices);
    }

    @Override
    protected void addImpl(int n, V v) throws IllegalArgumentException {
        int n2;
        Vertex vertex = n > 0 ? (Vertex)this.vertices.get(n - 1) : null;
        Vertex vertex2 = n < this.vertices.size() ? (Vertex)this.vertices.get(n) : null;
        List list = vertex != null && v != null ? this.graph.getEdges(vertex, v) : null;
        List list2 = vertex2 != null && v != null ? this.graph.getEdges(v, vertex2) : null;
        ArrayList<Integer> arrayList = list != null ? new ArrayList<Integer>() : null;
        ArrayList<Integer> arrayList2 = list2 != null ? new ArrayList<Integer>() : null;
        int n3 = n2 = n - 1 < 0 ? 0 : n - 1;
        if (list != null) {
            for (Edge object : list) {
                arrayList.add(object.getID());
            }
        }
        if (list2 != null) {
            for (Edge edge : list2) {
                arrayList2.add(edge.getID());
            }
        }
        if (this.useEdge != null && !arrayList.contains(this.useEdge.getID())) {
            throw new IllegalArgumentException("the specified edge is not incident to the specified vertex");
        }
        if (this.useEdge != null && this.edges.contains(this.useEdge.getID())) {
            throw new IllegalArgumentException("the specified edge is already contained in the trail");
        }
        if (arrayList != null && this.edges.containsAll(arrayList)) {
            throw new IllegalArgumentException("the trail already contains all edges between " + vertex + " and " + v);
        }
        if (arrayList2 != null && this.edges.containsAll(arrayList2)) {
            throw new IllegalArgumentException("the trail already contains all edges between " + v + " and " + vertex2);
        }
        super.addImpl(n, v);
        if (arrayList != null) {
            for (Integer n4 : arrayList) {
                if (this.edges.contains(n4) || this.useEdge != null && this.useEdge.getID() != n4.intValue()) continue;
                this.edges.add(n2, n4);
                break;
            }
        }
        if (arrayList2 != null) {
            for (Integer n5 : arrayList2) {
                if (this.edges.contains(n5)) continue;
                this.edges.add(n2 + 1, n5);
                break;
            }
        }
        this.useEdge = null;
    }

    @Override
    protected void insertImpl(int n, Walk<V> walk) throws IllegalArgumentException {
        int n2;
        if (!(walk instanceof Trail)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Trail trail = (Trail)walk;
        for (n2 = 0; n2 < trail.length(); ++n2) {
            if (!this.edges.contains(trail.get(n2))) continue;
            throw new IllegalArgumentException("the walk contains an edge that already exists in this trail");
        }
        for (n2 = 1; n2 <= trail.length(); ++n2) {
            this.vertices.add(n + n2, trail.get(n2));
            this.edges.add(n + n2 - 1, trail.edges.get(n2 - 1));
        }
        this.updateWeight();
    }
}

