/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.List;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Path;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.WalkByID;

public class PathByID<V extends Vertex>
extends WalkByID<V> {
    private static final long serialVersionUID = 1L;
    private boolean closed;

    public PathByID(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        this(graph, (List<Integer>)null);
    }

    public PathByID(Graph<V, ? extends Edge> graph, Integer[] integerArray) throws IllegalArgumentException {
        this(graph, PathByID.toList(integerArray));
    }

    public PathByID(Graph<V, ? extends Edge> graph, List<Integer> list) throws IllegalArgumentException {
        super(graph, list);
    }

    @Override
    public void add(int n) throws UnsupportedOperationException, IllegalArgumentException {
        Integer n2;
        Integer n3 = n2 = this.vertices.size() > 0 ? (Integer)this.vertices.get(0) : null;
        if (n2 != null && n2 == n && !this.closed) {
            this.closed = true;
        } else {
            if (this.closed) {
                throw new IllegalArgumentException("the path is closed (meaning a circle) so it is not possible to add further vertices");
            }
            if (this.vertices.contains(n)) {
                throw new IllegalArgumentException("the path already contains the vertex with the id " + n);
            }
        }
        super.add(n);
    }

    @Override
    public void removeLast() throws UnsupportedOperationException {
        super.removeLast();
        if (this.closed) {
            this.closed = false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Path<V> cast() throws UnsupportedOperationException, IllegalArgumentException {
        if (this.graph == null) {
            throw new UnsupportedOperationException("the walk does not have an associated graph");
        }
        Path path = new Path(this.graph);
        for (Integer n : this.vertices) {
            path.add(this.graph.getVertexByID(n));
        }
        return path;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PathByID) {
            try {
                return this.equals((PathByID)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public PathByID<V> clone() {
        return new PathByID<V>(this.graph, this.vertices);
    }

    @Override
    public boolean equals(PathByID<V> pathByID) {
        return pathByID != null ? this.vertices.equals(pathByID.vertices) : false;
    }
}

