/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.List;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.PathByID;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.Walk;

public class Path<V extends Vertex>
extends Walk<V> {
    private boolean closed;

    public Path(Graph<V, ? extends Edge> graph) throws IllegalArgumentException {
        this(graph, (List)null);
    }

    public Path(Graph<V, ? extends Edge> graph, V[] VArray) throws IllegalArgumentException {
        this(graph, Path.toList(VArray));
    }

    public Path(Graph<V, ? extends Edge> graph, List<V> list) throws IllegalArgumentException {
        super(graph, list);
    }

    @Override
    public void add(V v) throws IllegalArgumentException {
        super.add(v);
    }

    @Override
    public void add(int n, V v) throws IllegalArgumentException, IndexOutOfBoundsException {
        super.add(n, v);
    }

    @Override
    public void insert(Walk<V> walk, boolean bl) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("it is not possible to insert another path in this path");
    }

    @Override
    public void insert(Walk<V> walk, int n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("it is not possible to insert another path in this path");
    }

    @Override
    public void removeLast() {
        super.removeLast();
        if (this.closed) {
            this.closed = false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public PathByID<V> cast() throws IllegalArgumentException {
        PathByID pathByID = new PathByID(this.graph);
        for (Vertex vertex : this.vertices) {
            pathByID.add(vertex.getID());
        }
        return pathByID;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Path) {
            try {
                return this.equals((Path)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Path<V> path) {
        return path != null ? this.vertices.equals(path.vertices) : false;
    }

    @Override
    public Path<V> clone() {
        return new Path<V>(this.graph, this.vertices);
    }

    @Override
    protected void addImpl(int n, V v) throws IllegalArgumentException {
        Vertex vertex;
        boolean bl = n == this.vertices.size();
        Vertex vertex2 = vertex = this.vertices.size() > 0 ? (Vertex)this.vertices.get(0) : null;
        if (vertex == v && bl && !this.closed) {
            this.closed = true;
        } else {
            if (bl && this.closed) {
                throw new IllegalArgumentException("the path is closed (meaning a cycle) so it is not possible to add further vertices at the end of the path");
            }
            if (this.vertices.contains(v)) {
                throw new IllegalArgumentException("the path already contains the vertex " + v);
            }
        }
        super.addImpl(n, v);
    }
}

