/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lavesdk.math.Set;
import lavesdk.math.graph.AccessibleIDObserver;
import lavesdk.math.graph.AdjacencyMatrix;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;
import lavesdk.math.graph.enums.Type;
import lavesdk.serialization.Serializable;

public class Graph<V extends Vertex, E extends Edge> {
    private final AdjacencyMatrix<V, E> adjacencyMatrix = new AdjacencyMatrix();
    private final List<V> vertices = new ArrayList<V>();
    private final Map<Integer, V> verticesByID = new HashMap<Integer, V>();
    private final List<E> edges = new ArrayList();
    private final Map<Integer, E> edgesByID = new HashMap<Integer, E>();
    private final Type type;
    private int nextVertexID;
    private int nextEdgeID;
    private final List<AccessibleIDObserver> accessibleIDObservers;

    public Graph(Type type) {
        this.type = type;
        this.nextVertexID = 1;
        this.nextEdgeID = 1;
        this.accessibleIDObservers = new ArrayList<AccessibleIDObserver>(0);
    }

    public final Type getType() {
        return this.type;
    }

    public final int getOrder() {
        return this.vertices.size();
    }

    public final V getVertex(int n) throws IndexOutOfBoundsException {
        return (V)((Vertex)this.vertices.get(n));
    }

    public final V getVertexByCaption(String string) {
        for (Vertex vertex : this.vertices) {
            if (!vertex.getCaption().equals(string)) continue;
            return (V)vertex;
        }
        return null;
    }

    public final V getVertexByID(int n) {
        return (V)((Vertex)this.verticesByID.get(n));
    }

    public final int getSize() {
        return this.edges.size();
    }

    public final E getEdge(int n) throws IndexOutOfBoundsException {
        return (E)((Edge)this.edges.get(n));
    }

    public final E getEdgeByID(int n) {
        return (E)((Edge)this.edgesByID.get(n));
    }

    public final E getEdge(int n, int n2) {
        return this.adjacencyMatrix.get(n, n2);
    }

    public final E getEdge(V v, V v2) throws NullPointerException {
        if (((Vertex)v).getGraph() != this || ((Vertex)v2).getGraph() != this) {
            return null;
        }
        return this.adjacencyMatrix.get(v, v2);
    }

    public final List<E> getEdges(int n, int n2) {
        return this.adjacencyMatrix.getAll(n, n2);
    }

    public final List<E> getEdges(V v, V v2) {
        return this.adjacencyMatrix.getAll(v, v2);
    }

    public final boolean add(V v) {
        if (v == null || ((Vertex)v).getGraph() != null) {
            return false;
        }
        this.beforeVertexAdded(v);
        if (!this.isVertexAllowed(v) || this.containsVertex(v)) {
            return false;
        }
        ((Vertex)v).setGraph(this);
        ((Vertex)v).setID(this.nextVertexID++);
        ((Vertex)v).setIndex(this.vertices.size());
        this.verticesByID.put(((Vertex)v).getID(), v);
        if (this.vertices.add(v)) {
            this.afterVertexAdded(v);
            return true;
        }
        return false;
    }

    public final boolean remove(V v) {
        if (v == null || !this.containsVertex(v) || !this.isRemovable((E)v)) {
            return false;
        }
        if (!this.removeEdgesByVertex(v)) {
            return false;
        }
        ((Vertex)v).setGraph(null);
        this.verticesByID.remove(((Vertex)v).getID());
        if (this.vertices.remove(v)) {
            for (int i = ((Vertex)v).getIndex(); i < this.vertices.size(); ++i) {
                ((Vertex)this.vertices.get(i)).setIndex(i);
            }
            this.afterVertexRemoved(v);
            return true;
        }
        return false;
    }

    public final boolean add(E e) throws IllegalArgumentException {
        if (e == null || ((Edge)e).getGraph() != null) {
            return false;
        }
        ((Edge)e).setGraph(this);
        this.beforeEdgeAdded(e);
        if (!this.isEdgeAllowed(e) || this.containsEdge(e) >= 0) {
            return false;
        }
        if (!this.existVertices(e)) {
            throw new IllegalArgumentException("Predecessor and/or successor of the edge do not exist!");
        }
        ((Edge)e).setID(this.nextEdgeID++);
        ((Edge)e).getPredecessor().addOutgoingEdge((Edge)e);
        ((Edge)e).getSuccessor().addIncomingEdge((Edge)e);
        if (!((Edge)e).isDirected()) {
            ((Edge)e).getSuccessor().addOutgoingEdge((Edge)e);
            ((Edge)e).getPredecessor().addIncomingEdge((Edge)e);
        }
        ((Edge)e).setIndex(this.edges.size());
        this.adjacencyMatrix.add(e);
        this.edgesByID.put(((Edge)e).getID(), e);
        if (this.edges.add(e)) {
            this.afterEdgeAdded(e);
            return true;
        }
        return false;
    }

    public final boolean remove(E e) {
        if (e == null || this.containsEdge(e) < 0 || !this.isRemovable(e)) {
            return false;
        }
        ((Edge)e).getPredecessor().removeOutgoingEdge((Edge)e);
        ((Edge)e).getSuccessor().removeIncomingEdge((Edge)e);
        if (!((Edge)e).isDirected()) {
            ((Edge)e).getSuccessor().removeOutgoingEdge((Edge)e);
            ((Edge)e).getPredecessor().removeIncomingEdge((Edge)e);
        }
        this.adjacencyMatrix.remove(e);
        ((Edge)e).setGraph(null);
        this.edgesByID.remove(((Edge)e).getID());
        if (this.edges.remove(e)) {
            for (int i = ((Edge)e).getIndex(); i < this.edges.size(); ++i) {
                ((Edge)this.edges.get(i)).setIndex(i);
            }
            this.afterEdgeRemoved(e);
            return true;
        }
        return false;
    }

    public final void removeAll() {
        int n;
        for (n = this.edges.size() - 1; n >= 0; --n) {
            this.remove((E)((Edge)this.edges.get(n)));
        }
        for (n = this.vertices.size() - 1; n >= 0; --n) {
            this.remove((E)((Vertex)this.vertices.get(n)));
        }
    }

    public Set<Integer> getVertexByIDSet() {
        Set<Integer> set = new Set<Integer>(this.vertices.size());
        for (Vertex vertex : this.vertices) {
            set.add(vertex.getID());
        }
        return set;
    }

    public Set<V> getVertexSet() {
        Set<Vertex> set = new Set<Vertex>(this.vertices.size());
        for (Vertex vertex : this.vertices) {
            set.add(vertex);
        }
        return set;
    }

    public Set<Integer> getEdgeByIDSet() {
        Set<Integer> set = new Set<Integer>(this.edges.size());
        for (Edge edge : this.edges) {
            set.add(edge.getID());
        }
        return set;
    }

    public Set<E> getEdgeSet() {
        Set<Edge> set = new Set<Edge>(this.edges.size());
        for (Edge edge : this.edges) {
            set.add(edge);
        }
        return set;
    }

    public boolean contains(V v) {
        if (v == null || ((Vertex)v).getGraph() != this) {
            return false;
        }
        return this.containsVertex(v);
    }

    public boolean contains(E e) {
        if (e == null || ((Edge)e).getGraph() != this) {
            return false;
        }
        return this.containsEdge(e) >= 0;
    }

    public boolean equals(Graph<V, E> graph) {
        if (graph == null) {
            return false;
        }
        return graph.getVertexSet().equals(this.getVertexSet()) && graph.getEdgeSet().equals(this.getEdgeSet());
    }

    public boolean equals(Object object) {
        if (object instanceof Graph) {
            try {
                return this.equals((Graph)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("G=(");
        stringBuilder.append("{");
        for (Serializable serializable : this.vertices) {
            if (bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append(((Vertex)serializable).getCaption());
            bl = true;
        }
        stringBuilder.append("}, ");
        bl = false;
        stringBuilder.append("{");
        for (Serializable serializable : this.edges) {
            if (bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append("(" + ((Edge)serializable).getPredecessor().getCaption() + ", " + ((Edge)serializable).getSuccessor().getCaption() + ")");
            bl = true;
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    boolean existVertexCaption(String string) {
        for (Vertex vertex : this.vertices) {
            if (!vertex.getCaption().equals(string)) continue;
            return true;
        }
        return false;
    }

    boolean validateEdgeModification(int n) {
        Edge edge = (Edge)this.edgesByID.get(n);
        if (edge == null) {
            return false;
        }
        return this.isEdgeAllowed(edge) && this.containsEdge(edge) < 0;
    }

    void addIDObserver(AccessibleIDObserver accessibleIDObserver) {
        if (accessibleIDObserver == null || this.accessibleIDObservers.contains(accessibleIDObserver)) {
            return;
        }
        this.accessibleIDObservers.add(accessibleIDObserver);
    }

    void removeIDObserver(AccessibleIDObserver accessibleIDObserver) {
        this.accessibleIDObservers.remove(accessibleIDObserver);
    }

    void updateEdgeDirection(int n) {
        Edge edge = (Edge)this.edgesByID.get(n);
        if (!edge.isModifying()) {
            return;
        }
        this.adjacencyMatrix.updateDirection(edge);
        if (edge.isDirected()) {
            edge.getSuccessor().removeOutgoingEdge(edge);
            edge.getPredecessor().removeIncomingEdge(edge);
        } else {
            edge.getSuccessor().addOutgoingEdge(edge);
            edge.getPredecessor().addIncomingEdge(edge);
        }
    }

    void modifyVertexID(int n, int n2) throws IllegalArgumentException {
        if (n == n2) {
            return;
        }
        Vertex vertex = (Vertex)this.verticesByID.get(n);
        if (vertex == null || n2 < 1 || this.verticesByID.containsKey(n2)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.verticesByID.remove(n);
        this.verticesByID.put(n2, vertex);
        vertex.setID(n2);
        for (AccessibleIDObserver accessibleIDObserver : this.accessibleIDObservers) {
            accessibleIDObserver.vertexIDModified(n, n2);
        }
    }

    void modifyEdgeID(int n, int n2) throws IllegalArgumentException {
        if (n == n2) {
            return;
        }
        Edge edge = (Edge)this.edgesByID.get(n);
        if (edge == null || n2 < 1 || this.edgesByID.containsKey(n2)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.edgesByID.remove(n);
        this.edgesByID.put(n2, edge);
        edge.setID(n2);
        for (AccessibleIDObserver accessibleIDObserver : this.accessibleIDObservers) {
            accessibleIDObserver.edgeIDModified(n, n2);
        }
    }

    protected boolean containsVertex(V v) {
        return this.existVertexCaption(((Vertex)v).getCaption());
    }

    protected int containsEdge(E e) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if (!((Edge)this.edges.get(i)).equalsIgnoreWeight((Edge)e)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isVertexAllowed(V v) {
        return true;
    }

    protected boolean isEdgeAllowed(E e) {
        return true;
    }

    protected boolean isRemovable(V v) {
        return true;
    }

    protected boolean isRemovable(E e) {
        return true;
    }

    protected void beforeVertexAdded(V v) {
    }

    protected void beforeEdgeAdded(E e) {
    }

    protected void afterVertexAdded(V v) {
    }

    protected void afterEdgeAdded(E e) {
    }

    protected void afterVertexRemoved(V v) {
    }

    protected void afterEdgeRemoved(E e) {
    }

    private boolean removeEdgesByVertex(V v) {
        int n;
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        boolean bl = true;
        for (n = this.edges.size() - 1; n >= 0; --n) {
            Edge edge = (Edge)this.edges.get(n);
            if (edge.getPredecessor() == v || edge.getSuccessor() == v) {
                arrayList.add(edge);
                bl = this.isRemovable((E)edge);
            }
            if (!bl) break;
        }
        if (bl) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                this.remove((E)((Edge)arrayList.get(n)));
            }
        }
        return bl;
    }

    private boolean existVertices(E e) {
        boolean bl = false;
        boolean bl2 = false;
        for (Vertex vertex : this.vertices) {
            if (!bl && ((Edge)e).getPredecessor() == vertex) {
                bl = true;
            }
            if (!bl2 && ((Edge)e).getSuccessor() == vertex) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            break;
        }
        return bl && bl2;
    }
}

