/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;
import lavesdk.serialization.Serializable;
import lavesdk.serialization.Serializer;
import lavesdk.utils.MathUtils;

public class Edge
implements Serializable {
    protected final Vertex predecessor;
    protected final Vertex successor;
    private boolean directed;
    private boolean orgDirectedFlag;
    private float weight;
    private Graph<? extends Vertex, ? extends Edge> graph;
    private int id;
    private int index;
    private boolean modified;

    public Edge(Vertex vertex, Vertex vertex2) throws IllegalArgumentException {
        this(vertex, vertex2, false);
    }

    public Edge(Vertex vertex, Vertex vertex2, boolean bl) throws IllegalArgumentException {
        this(vertex, vertex2, bl, 0.0f);
    }

    public Edge(Vertex vertex, Vertex vertex2, float f) throws IllegalArgumentException {
        this(vertex, vertex2, false, f);
    }

    public Edge(Vertex vertex, Vertex vertex2, boolean bl, float f) throws IllegalArgumentException {
        if (vertex == null || vertex2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.predecessor = vertex;
        this.successor = vertex2;
        this.weight = f;
        this.orgDirectedFlag = this.directed = bl;
        this.graph = null;
        this.id = -1;
        this.index = -1;
        this.modified = false;
    }

    public final int getID() {
        return this.id;
    }

    public final int getIndex() {
        return this.index;
    }

    public Vertex getPredecessor() {
        return this.predecessor;
    }

    public Vertex getSuccessor() {
        return this.successor;
    }

    public Vertex getPredecessor(Vertex vertex) {
        if (this.directed) {
            return this.predecessor;
        }
        if (vertex == this.predecessor) {
            return this.successor;
        }
        if (vertex == this.successor) {
            return this.predecessor;
        }
        return null;
    }

    public Vertex getSuccessor(Vertex vertex) {
        if (this.directed) {
            return this.successor;
        }
        if (vertex == this.predecessor) {
            return this.successor;
        }
        if (vertex == this.successor) {
            return this.predecessor;
        }
        return null;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public final boolean isDirected() {
        return this.directed;
    }

    public final void setDirected(boolean bl) {
        this.orgDirectedFlag = bl;
        this.directed = this.getDirected();
    }

    public final boolean isLoop() {
        return this.predecessor == this.successor;
    }

    public String toString() {
        return MathUtils.formatFloat(this.weight);
    }

    public boolean equals(Edge edge) {
        if (edge == null) {
            return false;
        }
        if (edge == this) {
            return !this.modified;
        }
        return this.equalsIgnoreWeight(edge) && edge.weight == this.weight;
    }

    public final boolean equalsIgnoreWeight(Edge edge) {
        if (edge == null) {
            return false;
        }
        if (edge == this) {
            return !this.modified;
        }
        if (this.directed) {
            return edge.directed == this.directed && edge.predecessor.equals(this.predecessor) && edge.successor.equals(this.successor);
        }
        return edge.directed == this.directed && (edge.predecessor.equals(this.predecessor) && edge.successor.equals(this.successor) || edge.predecessor.equals(this.successor) && edge.successor.equals(this.predecessor));
    }

    public boolean equals(Object object) {
        if (object instanceof Edge) {
            return this.equals((Edge)object);
        }
        return false;
    }

    @Override
    public void serialize(Serializer serializer) {
        serializer.addFloat("weight", this.weight);
        serializer.addBoolean("orgDirectedFlag", this.orgDirectedFlag);
        serializer.addBoolean("directed", this.directed);
    }

    @Override
    public void deserialize(Serializer serializer) {
        this.weight = serializer.getFloat("weight");
        this.orgDirectedFlag = serializer.getBoolean("orgDirectedFlag");
        this.directed = serializer.getBoolean("directed");
        this.directed = this.getDirected();
    }

    protected final Graph<? extends Vertex, ? extends Edge> getGraph() {
        return this.graph;
    }

    final void setID(int n) {
        this.id = n;
    }

    final void setIndex(int n) {
        this.index = n;
    }

    final void setGraph(Graph<? extends Vertex, ? extends Edge> graph) {
        this.graph = graph;
        this.directed = this.getDirected();
    }

    final boolean isModifying() {
        return this.modified;
    }

    private boolean getDirected() {
        boolean bl;
        if (this.graph == null) {
            return this.directed;
        }
        switch (this.graph.getType()) {
            case DIRECTED: {
                bl = true;
                break;
            }
            case UNDIRECTED: {
                bl = false;
                break;
            }
            default: {
                boolean bl2 = this.directed;
                this.directed = this.orgDirectedFlag;
                if (bl2 != this.directed) {
                    this.modified = true;
                    if (this.graph.validateEdgeModification(this.id)) {
                        this.graph.updateEdgeDirection(this.id);
                        bl = this.orgDirectedFlag;
                    } else {
                        bl = bl2;
                    }
                    this.directed = bl2;
                    this.modified = false;
                    break;
                }
                bl = bl2;
            }
        }
        return bl;
    }
}

