/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Vertex;

public final class AdjacencyMatrix<V extends Vertex, E extends Edge> {
    private final Map<Integer, List<Entry>> matrix;

    public AdjacencyMatrix() {
        this(10);
    }

    public AdjacencyMatrix(int n) {
        this.matrix = new HashMap<Integer, List<Entry>>(n);
    }

    public void add(E e) throws NullPointerException {
        this.add(e, false);
        if (!((Edge)e).isDirected()) {
            this.add(e, true);
        }
    }

    public void remove(E e) throws NullPointerException {
        this.remove(e, false);
        if (!((Edge)e).isDirected()) {
            this.remove(e, true);
        }
    }

    public E get(int n, int n2) {
        List<Entry> list = this.matrix.get(n);
        if (list == null) {
            return null;
        }
        for (Entry entry : list) {
            if (entry.vID != n2) continue;
            return entry.edge;
        }
        return null;
    }

    public List<E> getAll(int n, int n2) {
        List<Entry> list = this.matrix.get(n);
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (Entry entry : list) {
            if (entry.vID != n2) continue;
            arrayList.add(entry.edge);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    public E get(V v, V v2) throws NullPointerException {
        return this.get((V)((Vertex)v).getID(), (V)((Vertex)v2).getID());
    }

    public List<E> getAll(V v, V v2) throws NullPointerException {
        return this.getAll((V)((Vertex)v).getID(), (V)((Vertex)v2).getID());
    }

    void updateDirection(E e) {
        if (!((Edge)e).isModifying()) {
            return;
        }
        if (((Edge)e).isDirected()) {
            this.remove(e, true);
        } else {
            this.add(e, true);
        }
    }

    private void add(E e, boolean bl) throws NullPointerException {
        Vertex vertex = bl ? ((Edge)e).getSuccessor() : ((Edge)e).getPredecessor();
        Vertex vertex2 = bl ? ((Edge)e).getPredecessor() : ((Edge)e).getSuccessor();
        List<Entry> list = this.matrix.get(vertex.getID());
        if (list == null) {
            list = new ArrayList<Entry>(5);
            this.matrix.put(vertex.getID(), list);
        }
        list.add(new Entry(this, vertex2.getID(), e));
    }

    private void remove(E e, boolean bl) throws NullPointerException {
        Vertex vertex = bl ? ((Edge)e).getSuccessor() : ((Edge)e).getPredecessor();
        Vertex vertex2 = bl ? ((Edge)e).getPredecessor() : ((Edge)e).getSuccessor();
        List<Entry> list = this.matrix.get(vertex.getID());
        if (list == null) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get((int)i).vID != vertex2.getID() || list.get((int)i).edge != e) continue;
            list.remove(i);
        }
    }

    private static class Entry {
        public final int vID;
        public final E edge;
        final /* synthetic */ AdjacencyMatrix this$0;

        public Entry(int n, E e) throws IllegalArgumentException {
            this.this$0 = var1_1;
            if (e == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.vID = n;
            this.edge = e;
        }
    }
}

