/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math.graph;

import lavesdk.math.graph.Edge;
import lavesdk.math.graph.Graph;
import lavesdk.math.graph.Vertex;

public class AccessibleID {
    private final Vertex vertex;
    private final Edge edge;
    private final Graph<?, ?> graph;

    public AccessibleID(Vertex vertex) throws IllegalArgumentException {
        if (vertex == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.vertex = vertex;
        this.edge = null;
        this.graph = vertex.getGraph();
    }

    public AccessibleID(Edge edge) throws IllegalArgumentException {
        if (edge == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.vertex = null;
        this.edge = edge;
        this.graph = edge.getGraph();
    }

    public final void modify(int n) throws IllegalArgumentException {
        if (this.vertex != null) {
            this.graph.modifyVertexID(this.vertex.getID(), n);
        } else if (this.edge != null) {
            this.graph.modifyEdgeID(this.edge.getID(), n);
        }
    }
}

