/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lavesdk.math.ElementParser;

public class Set<E>
implements java.util.Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<E> set;

    public Set() {
        this(10);
    }

    public Set(int n) {
        this.set = new ArrayList(n);
    }

    public Set(E[] EArray) throws IllegalArgumentException {
        this(Set.toCollection(EArray));
    }

    public Set(Collection<? extends E> collection) throws NullPointerException {
        this.set = new ArrayList(collection.size());
        this.addAll(collection);
    }

    @Override
    public boolean add(E e) throws NullPointerException {
        if (e == null) {
            throw new NullPointerException("element is null");
        }
        if (e == this || this.set.contains(e)) {
            return false;
        }
        return this.set.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException("collection is null");
        }
        for (E e : collection) {
            if (e == null) {
                throw new NullPointerException("collection contains null element");
            }
            this.add(e);
        }
        return true;
    }

    public boolean addAll(E[] EArray) {
        return this.addAll(Set.toCollection(EArray));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.set.containsAll(collection);
    }

    public boolean containsAll(E[] EArray) throws NullPointerException {
        return this.containsAll(Set.toCollection(EArray));
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.set.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection == null) {
            return false;
        }
        boolean bl = true;
        for (Object obj : collection) {
            bl = bl && this.remove(obj);
        }
        return bl;
    }

    public boolean removeAll(E[] EArray) {
        return this.removeAll(Set.toCollection(EArray));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.set.retainAll(collection);
    }

    public boolean retainAll(E[] EArray) throws NullPointerException {
        return this.retainAll(Set.toCollection(EArray));
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public E get(int n) throws IndexOutOfBoundsException {
        return this.set.get(n);
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.set.toArray(TArray);
    }

    public List<E> asList() {
        return (List)((ArrayList)this.set).clone();
    }

    public Set<E> clone() {
        return new Set<E>(this);
    }

    public boolean equals(Collection<E> collection) {
        if (collection == this) {
            return true;
        }
        return this.size() == collection.size() && this.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Collection) {
            try {
                return this.equals((Collection)object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.set.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.set.get(i).toString());
        }
        return "{" + stringBuilder + "}";
    }

    public static <E> Set<E> union(Set<? extends E> set, Set<? extends E> set2) throws NullPointerException {
        Set<Object> set3 = new Set<Object>();
        set3.addAll(set);
        set3.addAll(set2);
        return set3;
    }

    public static <E> Set<E> union(Collection<Set<? extends E>> collection) throws NullPointerException {
        Set<E> set = new Set<E>();
        Iterator<Set<E>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            set.addAll(iterator.next());
        }
        return set;
    }

    public static <E> Set<E> union(Set<? extends E>[] setArray) throws NullPointerException {
        return Set.union(Set.toCollection(setArray));
    }

    public static <E> Set<E> intersection(Set<? extends E> set, Set<? extends E> set2) throws NullPointerException {
        Set<E> set3 = new Set<E>(set);
        set3.retainAll(set2);
        return set3;
    }

    public static <E> Set<E> intersection(Collection<Set<? extends E>> collection) throws NullPointerException {
        Set<E> set = new Set<E>();
        boolean bl = false;
        for (Set<E> set2 : collection) {
            if (!bl) {
                set.addAll(set2);
                bl = true;
                continue;
            }
            set.retainAll(set2);
        }
        return set;
    }

    public static <E> Set<E> intersection(Set<? extends E>[] setArray) throws NullPointerException {
        return Set.intersection(Set.toCollection(setArray));
    }

    public static <E> Set<E> complement(Set<? extends E> set, Set<? extends E> set2) throws NullPointerException {
        Set<E> set3 = new Set<E>(set);
        set3.removeAll(set2);
        return set3;
    }

    public static <E> Set<E> symDifference(Set<? extends E> set, Set<? extends E> set2) throws NullPointerException {
        return Set.union(Set.complement(set, set2), Set.complement(set2, set));
    }

    public static <E> Set<E> parse(String string, ElementParser<E> elementParser) throws IllegalArgumentException {
        return Set.parse(string, elementParser, ",");
    }

    public static <E> Set<E> parse(String string, ElementParser<E> elementParser, String string2) throws IllegalArgumentException {
        String[] stringArray;
        if (string == null || elementParser == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Set<E> set = new Set<E>();
        boolean bl = string.startsWith("{") && string.endsWith("}");
        int n = bl ? 1 : 0;
        int n2 = bl ? string.length() - 1 : string.length();
        String string3 = string.substring(n, n2);
        for (String string4 : stringArray = string3.split(string2)) {
            String string5 = string4.trim();
            if (string5 == null || string5.isEmpty()) continue;
            set.add(elementParser.parse(string5));
        }
        return set;
    }

    private static <E> Collection<Set<? extends E>> toCollection(Set<? extends E>[] setArray) throws NullPointerException {
        if (setArray == null) {
            throw new NullPointerException();
        }
        ArrayList<Set<Set<? extends E>>> arrayList = new ArrayList<Set<Set<? extends E>>>(setArray.length);
        for (Set<? extends E> set : setArray) {
            arrayList.add(set);
        }
        return arrayList;
    }

    private static <E> Collection<E> toCollection(E[] EArray) throws NullPointerException {
        if (EArray == null) {
            throw new NullPointerException();
        }
        ArrayList<E> arrayList = new ArrayList<E>(EArray.length);
        for (E e : EArray) {
            arrayList.add(e);
        }
        return arrayList;
    }

    public static class DoubleElementParser
    extends ElementParser<Double> {
        @Override
        public Double parse(String string) {
            try {
                return NumberFormat.getInstance().parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                return 0.0;
            }
        }
    }

    public static class FloatElementParser
    extends ElementParser<Float> {
        @Override
        public Float parse(String string) {
            try {
                return Float.valueOf(NumberFormat.getInstance().parse(string).floatValue());
            }
            catch (ParseException parseException) {
                return Float.valueOf(0.0f);
            }
        }
    }

    public static class LongElementParser
    extends ElementParser<Long> {
        @Override
        public Long parse(String string) {
            try {
                return NumberFormat.getInstance().parse(string).longValue();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
    }

    public static class IntegerElementParser
    extends ElementParser<Integer> {
        @Override
        public Integer parse(String string) {
            try {
                return NumberFormat.getInstance().parse(string).intValue();
            }
            catch (ParseException parseException) {
                return 0;
            }
        }
    }

    public static class NumberElementParser
    extends ElementParser<Number> {
        @Override
        public Number parse(String string) {
            try {
                return NumberFormat.getInstance().parse(string);
            }
            catch (ParseException parseException) {
                return 0;
            }
        }
    }

    public static class StringElementParser
    extends ElementParser<String> {
        @Override
        public String parse(String string) {
            return string;
        }
    }
}

