/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math;

import lavesdk.math.Matrix;

public class NumericMatrix<T extends Number>
extends Matrix<T> {
    private static final long serialVersionUID = 1L;

    public NumericMatrix(int n, int n2) throws IllegalArgumentException {
        super(n, n2);
    }

    public NumericMatrix(int n, int n2, T t) throws IllegalArgumentException {
        super(n, n2, t);
    }

    @Override
    public Matrix<T> clone() {
        NumericMatrix<T> numericMatrix = new NumericMatrix<T>(this.n, this.m);
        NumericMatrix.copy(this, numericMatrix);
        return numericMatrix;
    }

    public static NumericMatrix<Number> add(NumericMatrix<? extends Number> numericMatrix, NumericMatrix<? extends Number> numericMatrix2) throws NullPointerException, IllegalArgumentException {
        if (numericMatrix.getRowCount() != numericMatrix2.getRowCount() || numericMatrix.getColumnCount() != numericMatrix2.getColumnCount()) {
            throw new IllegalArgumentException("matrices are not of the same type");
        }
        NumericMatrix<Number> numericMatrix3 = new NumericMatrix<Number>(numericMatrix.getRowCount(), numericMatrix.getColumnCount());
        for (int i = 0; i < numericMatrix3.getRowCount(); ++i) {
            for (int j = 0; j < numericMatrix3.getColumnCount(); ++j) {
                Number number = (Number)numericMatrix.get(i, j);
                Number number2 = (Number)numericMatrix2.get(i, j);
                if (number == null || number2 == null) continue;
                numericMatrix3.set(i, j, new Double(number.doubleValue() + number2.doubleValue()));
            }
        }
        return numericMatrix3;
    }

    public static NumericMatrix<Number> scalarMult(NumericMatrix<? extends Number> numericMatrix, Number number) throws NullPointerException {
        NumericMatrix<Number> numericMatrix2 = new NumericMatrix<Number>(numericMatrix.getRowCount(), numericMatrix.getColumnCount());
        for (int i = 0; i < numericMatrix2.getRowCount(); ++i) {
            for (int j = 0; j < numericMatrix2.getColumnCount(); ++j) {
                Number number2 = (Number)numericMatrix.get(i, j);
                if (number2 == null) continue;
                numericMatrix2.set(i, j, new Double(number2.doubleValue() * number.doubleValue()));
            }
        }
        return numericMatrix2;
    }

    public static NumericMatrix<Number> transpose(NumericMatrix<? extends Number> numericMatrix, Number number) throws NullPointerException {
        NumericMatrix<Number> numericMatrix2 = new NumericMatrix<Number>(numericMatrix.getColumnCount(), numericMatrix.getRowCount());
        for (int i = 0; i < numericMatrix2.getRowCount(); ++i) {
            for (int j = 0; j < numericMatrix2.getColumnCount(); ++j) {
                numericMatrix2.set(i, j, (Number)numericMatrix.get(j, i));
            }
        }
        return numericMatrix2;
    }

    public static NumericMatrix<Number> multiply(NumericMatrix<? extends Number> numericMatrix, NumericMatrix<? extends Number> numericMatrix2) throws NullPointerException, IllegalArgumentException {
        if (numericMatrix.getColumnCount() != numericMatrix2.getRowCount()) {
            throw new IllegalArgumentException("number of columns of a1 does not fit to number of rows of a2");
        }
        NumericMatrix<Number> numericMatrix3 = new NumericMatrix<Number>(numericMatrix.getRowCount(), numericMatrix2.getColumnCount());
        for (int i = 0; i < numericMatrix3.getRowCount(); ++i) {
            for (int j = 0; j < numericMatrix3.getColumnCount(); ++j) {
                Double d = new Double(0.0);
                for (int k = 0; k < numericMatrix.getColumnCount(); ++k) {
                    Number number = (Number)numericMatrix.get(i, k);
                    Number number2 = (Number)numericMatrix2.get(k, j);
                    if (number == null || number2 == null) {
                        d = null;
                        break;
                    }
                    d = d + number.doubleValue() * number2.doubleValue();
                }
                numericMatrix3.set(i, j, d);
            }
        }
        return numericMatrix3;
    }
}

