/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Matrix<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<List<T>> a;
    protected final int n;
    protected final int m;

    public Matrix(int n, int n2) throws IllegalArgumentException {
        this(n, n2, null);
    }

    public Matrix(int n, int n2, T t) throws IllegalArgumentException {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.a = new ArrayList<List<T>>(n);
        this.n = n;
        this.m = n2;
        for (int i = 0; i < n; ++i) {
            this.a.add(new ArrayList(n2));
            for (int j = 0; j < n2; ++j) {
                this.a.get(i).add(t);
            }
        }
    }

    public T get(int n, int n2) throws IndexOutOfBoundsException {
        return this.a.get(n).get(n2);
    }

    public void set(int n, int n2, T t) throws IndexOutOfBoundsException {
        this.a.get(n).set(n2, t);
    }

    public void set(T[][] TArray) throws IllegalArgumentException {
        if (TArray == null || TArray.length != this.n || TArray[0].length != this.m) {
            throw new IllegalArgumentException("No valid argument!");
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                this.set(i, j, TArray[i][j]);
            }
        }
    }

    public final int getRowCount() {
        return this.n;
    }

    public final int getColumnCount() {
        return this.m;
    }

    public final boolean isInDimension(int n, int n2) {
        return n >= 0 && n < this.n && n2 >= 0 && n2 < this.m;
    }

    public final boolean isSquare() {
        return this.n == this.m;
    }

    public abstract Matrix<T> clone();

    public boolean equals(Object object) {
        if (!(object instanceof Matrix)) {
            return false;
        }
        return this.equals((Matrix)object);
    }

    public boolean equals(Matrix<?> matrix) {
        return matrix != null ? this.a.equals(matrix.a) : false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < this.n; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("{");
            for (int j = 0; j < this.m; ++j) {
                T t;
                if (j > 0) {
                    stringBuilder.append(",");
                }
                if ((t = this.get(i, j)) == null) continue;
                stringBuilder.append(t.toString());
            }
            stringBuilder.append("}");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static <T> void copy(Matrix<T> matrix, Matrix<T> matrix2) throws IllegalArgumentException {
        if (matrix == null || matrix2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        for (int i = 0; i < matrix2.getRowCount(); ++i) {
            for (int j = 0; j < matrix2.getColumnCount(); ++j) {
                if (!matrix.isInDimension(i, j)) continue;
                matrix2.set(i, j, matrix.get(i, j));
            }
        }
    }
}

