/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.logging;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.logging.LogFormat;
import lavesdk.logging.enums.LogType;
import lavesdk.utils.FileUtils;

public class LogFile {
    private final Logger logger = Logger.getLogger(LogFile.class.getName());

    public LogFile(String string) throws IOException {
        FileUtils.createFilePath(string);
        FileHandler fileHandler = new FileHandler(string);
        fileHandler.setFormatter(new LogFormat());
        this.logger.addHandler(fileHandler);
        this.logger.setLevel(Level.INFO);
    }

    public void writeToLog(String string, LogType logType) {
        this.writeToLog(null, string, null, logType);
    }

    public void writeToLog(AlgorithmPlugin algorithmPlugin, String string, LogType logType) {
        this.writeToLog(algorithmPlugin, string, null, logType);
    }

    public void writeToLog(String string, Exception exception, LogType logType) {
        this.writeToLog(null, string, exception, logType);
    }

    public void writeToLog(AlgorithmPlugin algorithmPlugin, String string, Exception exception, LogType logType) {
        String string2 = algorithmPlugin != null ? " (plugin: " + algorithmPlugin.getName() + ", plugin-version: " + algorithmPlugin.getVersion() + ")" : "";
        String string3 = exception != null ? FileUtils.LINESEPARATOR + exception.toString() : "";
        this.logger.log(this.getLogLevel(logType), string + string2 + string3);
    }

    private Level getLogLevel(LogType logType) {
        switch (logType) {
            case ERROR: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
        }
        return Level.INFO;
    }
}

