/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lavesdk.language.LabelEntry;
import lavesdk.utils.FileUtils;

public class LanguageFile {
    private final Map<String, List<LabelEntry>> labels;
    private final List<LabelEntry> languages;
    private static final String COMMENT_TOKEN = "//";
    private static final String LABELID_TOKEN = "$";
    private static final String LANGID_TOKEN = "#";
    private static final String LINEBREAK_TOKEN = "%n";
    private static final String ASSIGNEMENTOPERATOR_TOKEN = "=";
    private static final String LANGUAGES_LABEL = "LANGUAGES";
    private static final String LINEBREAK = FileUtils.LINESEPARATOR;
    private static final Pattern LTRIM = Pattern.compile("^\\s+");

    public LanguageFile(String string) throws IOException {
        this(new File(string));
    }

    public LanguageFile(File file) throws IOException {
        this(new FileInputStream(file), "UTF-8");
    }

    public LanguageFile(File file, String string) throws IOException {
        this(new FileInputStream(file), string);
    }

    public LanguageFile(InputStream inputStream) throws IOException {
        this(inputStream, "UTF-8");
    }

    public LanguageFile(InputStream inputStream, String string) throws IOException {
        if (inputStream == null || string == null || string.isEmpty()) {
            throw new IOException("input stream is null");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = null;
        List<Object> list = null;
        boolean bl = false;
        this.labels = new HashMap<String, List<LabelEntry>>();
        this.languages = new ArrayList<LabelEntry>();
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                int n;
                String string4 = this.ltrim(string3);
                if (string4.startsWith(COMMENT_TOKEN) || string4.isEmpty()) continue;
                if (string4.startsWith(LABELID_TOKEN)) {
                    string2 = string4.substring(1, string4.length());
                    if (!string2.equalsIgnoreCase(LANGUAGES_LABEL)) {
                        list = new ArrayList();
                        this.labels.put(string2, list);
                        continue;
                    }
                    list = !bl ? this.languages : null;
                    bl = true;
                    continue;
                }
                if (!string4.startsWith(LANGID_TOKEN) || list == null || (n = string4.indexOf(ASSIGNEMENTOPERATOR_TOKEN)) < 1) continue;
                String string5 = string4.substring(1, n - 1).trim();
                String string6 = this.ltrim(string4.substring(n + 1, string4.length())).replaceAll(LINEBREAK_TOKEN, LINEBREAK);
                list.add(new LabelEntry(string5, string6));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            bufferedReader.close();
            inputStreamReader.close();
        }
    }

    public List<LabelEntry> getAvailableLanguages() {
        return this.languages;
    }

    public String getLabel(String string, String string2) {
        return this.getLabel(string, string2, null);
    }

    public String getLabel(String string, String string2, String string3) {
        List<LabelEntry> list = this.labels.get(string);
        if (list != null) {
            for (LabelEntry labelEntry : list) {
                if (!labelEntry.langID.equalsIgnoreCase(string2)) continue;
                return labelEntry.description;
            }
        }
        return string3 != null ? string3 : string;
    }

    public static String getLabel(LanguageFile languageFile, String string, String string2) {
        return LanguageFile.getLabel(languageFile, string, string2, "");
    }

    public static String getLabel(LanguageFile languageFile, String string, String string2, String string3) {
        String string4 = languageFile != null ? languageFile.getLabel(string, string2, string3) : string3;
        return string4 != null ? string4 : string;
    }

    public void include(LanguageFile languageFile) throws IllegalArgumentException {
        if (languageFile == null || languageFile == this) {
            throw new IllegalArgumentException("No valid argument!");
        }
        Iterator<String> iterator = languageFile.labels.keySet().iterator();
        this.addEntriesToList(this.languages, languageFile.languages);
        while (iterator.hasNext()) {
            String string = iterator.next();
            List<LabelEntry> list = languageFile.labels.get(string);
            if (this.labels.containsKey(string)) {
                this.addEntriesToList(this.labels.get(string), list);
                continue;
            }
            this.labels.put(string, list);
        }
    }

    private void addEntriesToList(List<LabelEntry> list, List<LabelEntry> list2) {
        for (LabelEntry labelEntry : list2) {
            boolean bl = false;
            for (LabelEntry labelEntry2 : list) {
                if (!labelEntry.langID.equals(labelEntry2.langID)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(labelEntry);
        }
    }

    private String ltrim(String string) {
        return LTRIM.matcher(string).replaceAll("");
    }
}

