/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class Symbol
implements Icon {
    private final Icon symbol;
    private static Symbol ALPHA;
    private static Symbol BETA;
    private static Symbol GAMMA;
    private static Symbol DELTA;
    private static Symbol DELTA_BIG;
    private static Symbol THETA;
    private static Symbol LAMBDA;
    private static Symbol PI;
    private static Symbol SIGMA;
    private static Symbol SIGMA_BIG;
    private static Symbol RHO;
    private static Symbol TAU;
    private static Symbol PHI;
    private static Symbol INFINITY;
    private static Symbol SUM;

    public Symbol() {
        this(null);
    }

    public Symbol(Icon icon) {
        this.symbol = icon;
    }

    public static Symbol getPredefinedSymbol(PredefinedSymbol predefinedSymbol) throws IllegalArgumentException {
        if (predefinedSymbol == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        switch (predefinedSymbol) {
            case ALPHA: {
                if (ALPHA == null) {
                    ALPHA = Symbol.createLaTeXSymbol("\\alpha");
                }
                return ALPHA;
            }
            case BETA: {
                if (BETA == null) {
                    BETA = Symbol.createLaTeXSymbol("\\beta");
                }
                return BETA;
            }
            case GAMMA: {
                if (GAMMA == null) {
                    GAMMA = Symbol.createLaTeXSymbol("\\gamma");
                }
                return GAMMA;
            }
            case DELTA: {
                if (DELTA == null) {
                    DELTA = Symbol.createLaTeXSymbol("\\delta");
                }
                return DELTA;
            }
            case DELTA_BIG: {
                if (DELTA_BIG == null) {
                    DELTA_BIG = Symbol.createLaTeXSymbol("\\Delta");
                }
                return DELTA_BIG;
            }
            case THETA: {
                if (THETA == null) {
                    THETA = Symbol.createLaTeXSymbol("\\theta");
                }
                return THETA;
            }
            case LAMBDA: {
                if (LAMBDA == null) {
                    LAMBDA = Symbol.createLaTeXSymbol("\\lambda");
                }
                return LAMBDA;
            }
            case PI: {
                if (PI == null) {
                    PI = Symbol.createLaTeXSymbol("\\pi");
                }
                return PI;
            }
            case SIGMA: {
                if (SIGMA == null) {
                    SIGMA = Symbol.createLaTeXSymbol("\\sigma");
                }
                return SIGMA;
            }
            case SIGMA_BIG: {
                if (SIGMA_BIG == null) {
                    SIGMA_BIG = Symbol.createLaTeXSymbol("\\Sigma");
                }
                return SIGMA_BIG;
            }
            case RHO: {
                if (RHO == null) {
                    RHO = Symbol.createLaTeXSymbol("\\rho");
                }
                return RHO;
            }
            case TAU: {
                if (TAU == null) {
                    TAU = Symbol.createLaTeXSymbol("\\tau");
                }
                return TAU;
            }
            case PHI: {
                if (PHI == null) {
                    PHI = Symbol.createLaTeXSymbol("\\phi");
                }
                return PHI;
            }
            case INFINITY: {
                if (INFINITY == null) {
                    INFINITY = Symbol.createLaTeXSymbol("\\infty");
                }
                return INFINITY;
            }
            case SUM: {
                if (SUM == null) {
                    SUM = Symbol.createLaTeXSymbol("\\sum");
                }
                return SUM;
            }
        }
        return null;
    }

    public static Symbol createLaTeXSymbol(String string) throws IllegalArgumentException {
        return Symbol.createLaTeXSymbol(string, 10.0f);
    }

    public static Symbol createLaTeXSymbol(String string, float f) throws IllegalArgumentException {
        if (string == null || string.isEmpty() || f <= 0.0f) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return new Symbol(new TeXFormula.TeXIconBuilder(new TeXFormula(string)).setStyle(2).setSize(f).build());
    }

    @Override
    public int getIconHeight() {
        return this.symbol != null ? this.symbol.getIconHeight() : 0;
    }

    @Override
    public int getIconWidth() {
        return this.symbol != null ? this.symbol.getIconWidth() : 0;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.symbol != null) {
            if (this.symbol instanceof TeXIcon && component != null) {
                ((TeXIcon)this.symbol).setForeground(component.getForeground());
            }
            this.symbol.paintIcon(component, graphics, n, n2);
        }
    }

    public static enum PredefinedSymbol {
        ALPHA,
        BETA,
        GAMMA,
        DELTA,
        DELTA_BIG,
        THETA,
        LAMBDA,
        PI,
        SIGMA,
        SIGMA_BIG,
        RHO,
        TAU,
        PHI,
        INFINITY,
        SUM;

    }
}

