/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class SliderCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private Number number = 0;
    private final JPanel editorPanel = new JPanel();
    private final JLabel numberLabel = new JLabel();
    private final JSlider slider = new JSlider(0, 100);

    public SliderCellEditor() {
        this.numberLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.numberLabel.setPreferredSize(new Dimension(30, 0));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SliderCellEditor.this.number = SliderCellEditor.this.slider.getValue();
                SliderCellEditor.this.numberLabel.setText(SliderCellEditor.this.number.toString());
            }
        });
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add((Component)this.numberLabel, "West");
        this.editorPanel.add((Component)this.slider, "Center");
    }

    public int getMinimum() {
        return this.slider.getMinimum();
    }

    public void setMinimum(int n) {
        this.slider.setMinimum(n);
    }

    public int getMaximum() {
        return this.slider.getMaximum();
    }

    public void setMaximum(int n) {
        this.slider.setMaximum(n);
    }

    @Override
    public Object getCellEditorValue() {
        return this.number;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        try {
            this.number = (Number)object;
            this.editorPanel.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.numberLabel.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.numberLabel.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            this.slider.setValue(this.number.intValue());
            this.slider.setBackground(jTable.getBackground());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.editorPanel;
    }
}

