/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import javax.swing.AbstractCellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;

public abstract class Property {
    private final String name;
    private final String description;
    protected Object value;
    protected final TableCellEditor editor;
    protected final TableCellRenderer renderer;

    public Property(String string, String string2, Object object, Object[] objectArray) throws IllegalArgumentException, IllegalStateException {
        if (string == null || string.isEmpty() || string2 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.name = string;
        this.description = string2;
        this.editor = this.createEditor(objectArray);
        this.renderer = this.createRenderer(objectArray);
        this.setValue(object);
        if (this.editor == null) {
            throw new IllegalStateException("No valid editor!");
        }
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof AbstractCellEditor) {
                    Property.this.setValue(Property.this.onEditStop(((AbstractCellEditor)changeEvent.getSource()).getCellEditorValue()));
                }
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }
        });
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public Object getValue() {
        if (EDT.isExecutedInEDT()) {
            return this.value;
        }
        return EDT.execute(new GuiRequest<Object>(){

            @Override
            protected Object execute() throws Throwable {
                return Property.this.value;
            }
        });
    }

    public void setValue(final Object object) {
        if (EDT.isExecutedInEDT()) {
            this.value = object;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setValue"){

                @Override
                protected void execute() throws Throwable {
                    Property.this.value = object;
                }
            });
        }
    }

    public String toString() {
        return this.name + "[value=" + this.value + "]";
    }

    protected abstract TableCellEditor createEditor(Object[] var1);

    protected abstract TableCellRenderer createRenderer(Object[] var1);

    protected abstract Class<?> getValueClass();

    protected abstract Object onEditStop(Object var1);

    final TableCellEditor getEditor() {
        return this.editor;
    }

    final TableCellRenderer getRenderer() {
        return this.renderer;
    }
}

