/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.BooleanProperty;
import lavesdk.gui.widgets.ColorProperty;
import lavesdk.gui.widgets.ListProperty;
import lavesdk.gui.widgets.NumericProperty;
import lavesdk.gui.widgets.PropertiesList;
import lavesdk.gui.widgets.Property;
import lavesdk.gui.widgets.TextProperty;
import lavesdk.language.LanguageFile;

public class PropertiesListModel {
    private final List<Property> properties = new ArrayList<Property>(5);
    private final Map<String, Property> propertiesMap = new HashMap<String, Property>();
    private PropertiesList list = null;
    private final String nameCaption;
    private final String valueCaption;

    public PropertiesListModel() {
        this(null, null);
    }

    public PropertiesListModel(LanguageFile languageFile, String string) {
        this.nameCaption = LanguageFile.getLabel(languageFile, "PROPERTIESLIST_NAME_COLUMN", string, "Property Name");
        this.valueCaption = LanguageFile.getLabel(languageFile, "PROPERTIESLIST_VALUE_COLUMN", string, "Value");
    }

    public final boolean add(final Property property) throws IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            return this.internalAdd(property);
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return PropertiesListModel.this.internalAdd(property);
            }
        });
    }

    public final boolean remove(String string) {
        if (EDT.isExecutedInEDT()) {
            return this.internalRemove(string);
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return PropertiesListModel.this.internalRemove(this.name);
            }
        });
    }

    public final void removeAll() {
        if (EDT.isExecutedInEDT()) {
            this.internalRemoveAll();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAll"){

                @Override
                protected void execute() throws Throwable {
                    PropertiesListModel.this.internalRemoveAll();
                }
            });
        }
    }

    public int getPropertyCount() {
        if (EDT.isExecutedInEDT()) {
            return this.properties.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return PropertiesListModel.this.properties.size();
            }
        });
    }

    public Property getProperty(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.properties.get(n);
        }
        return EDT.execute(new GuiRequest<Property>(){

            @Override
            protected Property execute() throws Throwable {
                return (Property)PropertiesListModel.this.properties.get(n);
            }
        });
    }

    public Property getProperty(String string) {
        return this.getProperty(string, Property.class);
    }

    public <T extends Property> T getProperty(String string, final Class<T> clazz) {
        if (EDT.isExecutedInEDT()) {
            return this.internalGetProperty(string, clazz);
        }
        return (T)((Property)EDT.execute(new GuiRequest<T>(){

            @Override
            protected T execute() throws Throwable {
                return PropertiesListModel.this.internalGetProperty(this.name, clazz);
            }
        }));
    }

    public TextProperty getTextProperty(String string) {
        return this.getProperty(string, TextProperty.class);
    }

    public NumericProperty getNumericProperty(String string) {
        return this.getProperty(string, NumericProperty.class);
    }

    public BooleanProperty getBooleanProperty(String string) {
        return this.getProperty(string, BooleanProperty.class);
    }

    public ListProperty getListProperty(String string) {
        return this.getProperty(string, ListProperty.class);
    }

    public ColorProperty getColorProperty(String string) {
        return this.getProperty(string, ColorProperty.class);
    }

    public String getNameColumnCaption() {
        return this.nameCaption;
    }

    public String getValueColumnCaption() {
        return this.valueCaption;
    }

    public boolean isHeaderVisible() {
        return false;
    }

    public int getRowHeight() {
        return 20;
    }

    public boolean hasAutoRowSorter() {
        return false;
    }

    void setList(PropertiesList propertiesList) throws IllegalArgumentException {
        if (this.list != null || propertiesList == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.list = propertiesList;
    }

    PropertiesList getList() {
        return this.list;
    }

    private final boolean internalAdd(Property property) throws IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (this.propertiesMap.containsKey(property.getName())) {
            return false;
        }
        this.properties.add(property);
        this.propertiesMap.put(property.getName(), property);
        if (this.list != null) {
            this.list.getTableModel().addRow(property);
        }
        return true;
    }

    private final boolean internalRemove(String string) {
        Property property = this.propertiesMap.get(string);
        if (property == null) {
            return false;
        }
        this.properties.remove(property);
        this.propertiesMap.remove(string);
        if (this.list != null) {
            this.list.getTableModel().removeRow(property);
        }
        return true;
    }

    private final void internalRemoveAll() {
        this.properties.clear();
        this.propertiesMap.clear();
        if (this.list != null) {
            this.list.getTableModel().removeAll();
        }
    }

    private <T extends Property> T internalGetProperty(String string, Class<T> clazz) {
        Property property;
        if (this.list != null) {
            this.list.closeEditors();
        }
        if ((property = this.propertiesMap.get(string)).getClass().isAssignableFrom(clazz)) {
            return (T)((Property)clazz.cast(property));
        }
        return null;
    }
}

