/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.PropertiesListModel;
import lavesdk.gui.widgets.Property;

public class PropertiesList
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final PropertiesListTableModel tableModel;
    private PropertiesListModel model;
    private final JTable table;
    private final JLabel descriptionLbl;
    private boolean addImplDisabled = false;
    private final EventController eventController;

    public PropertiesList() {
        this((PropertiesListModel)null);
    }

    public PropertiesList(PropertiesListModel propertiesListModel) throws IllegalArgumentException {
        super.setLayout(new BorderLayout());
        this.tableModel = new PropertiesListTableModel();
        this.eventController = new EventController();
        this.table = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                if (this.convertColumnIndexToModel(n2) == 1) {
                    return PropertiesList.this.tableModel.getRow(this.convertRowIndexToModel(n)).getEditor();
                }
                return super.getCellEditor(n, n2);
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                Property property = PropertiesList.this.tableModel.getRow(this.convertRowIndexToModel(n));
                if (this.convertColumnIndexToModel(n2) == 1) {
                    return property.getRenderer() != null ? property.getRenderer() : this.getDefaultRenderer(property.getValueClass());
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this.setModel(propertiesListModel != null ? propertiesListModel : new PropertiesListModel());
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this.eventController);
        this.descriptionLbl = new JLabel();
        this.descriptionLbl.setVisible(false);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.descriptionLbl, "South");
        this.addImplDisabled = true;
    }

    public PropertiesListModel getModel() {
        if (EDT.isExecutedInEDT()) {
            return this.model;
        }
        return EDT.execute(new GuiRequest<PropertiesListModel>(){

            @Override
            protected PropertiesListModel execute() throws Throwable {
                return PropertiesList.this.model;
            }
        });
    }

    public void setModel(final PropertiesListModel propertiesListModel) throws IllegalArgumentException {
        if (propertiesListModel == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalSetModel(propertiesListModel);
        } else {
            EDT.execute(new GuiJob("PropertiesList.setModel"){

                @Override
                protected void execute() throws Throwable {
                    PropertiesList.this.internalSetModel(propertiesListModel);
                }
            });
        }
    }

    public final boolean add(Property property) throws IllegalArgumentException {
        return this.model.add(property);
    }

    public final boolean remove(String string) {
        return this.model.remove(string);
    }

    public <T extends Property> T getProperty(String string, Class<T> clazz) {
        return this.model.getProperty(string, clazz);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void removeAll() {
        this.model.removeAll();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.addImplDisabled) {
            super.addImpl(component, object, n);
        }
    }

    PropertiesListTableModel getTableModel() {
        if (EDT.isExecutedInEDT()) {
            return this.tableModel;
        }
        return EDT.execute(new GuiRequest<PropertiesListTableModel>(){

            @Override
            protected PropertiesListTableModel execute() throws Throwable {
                return PropertiesList.this.tableModel;
            }
        });
    }

    void closeEditors() {
        if (EDT.isExecutedInEDT()) {
            this.table.editCellAt(-1, -1);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".closeEditors"){

                @Override
                protected void execute() throws Throwable {
                    PropertiesList.this.table.editCellAt(-1, -1);
                }
            });
        }
    }

    private void internalSetModel(PropertiesListModel propertiesListModel) {
        this.model = propertiesListModel;
        this.model.setList(this);
        this.table.setAutoCreateRowSorter(this.model.hasAutoRowSorter());
        if (!this.model.isHeaderVisible()) {
            this.table.setTableHeader(null);
        }
        this.table.setRowHeight(this.model.getRowHeight());
        this.tableModel.setNameColumnCaption(this.model.getNameColumnCaption());
        this.tableModel.setValueColumnCaption(this.model.getValueColumnCaption());
        this.tableModel.removeAll();
        for (int i = 0; i < this.model.getPropertyCount(); ++i) {
            this.tableModel.addRow(this.model.getProperty(i));
        }
    }

    private void displayDescription() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.descriptionLbl.setVisible(false);
            return;
        }
        int n2 = this.table.convertRowIndexToModel(n);
        Property property = this.tableModel.getRow(n2);
        this.descriptionLbl.setVisible(!property.getDescription().isEmpty());
        this.descriptionLbl.setText("<html>" + property.getDescription() + "</html>");
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
    }

    private class EventController
    implements ListSelectionListener {
        private EventController() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            PropertiesList.this.displayDescription();
        }
    }

    class PropertiesListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columns = new String[]{"Name", "Value"};
        private final List<Property> rows = new ArrayList<Property>(5);

        public void addRow(Property property) throws IllegalArgumentException {
            if (property == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.rows.add(property);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        public void removeRow(Property property) {
            this.rows.remove(property);
            this.fireTableStructureChanged();
        }

        public void removeAll() {
            this.rows.clear();
            this.fireTableStructureChanged();
        }

        public Property getRow(int n) throws IndexOutOfBoundsException {
            return this.rows.get(n);
        }

        public void setNameColumnCaption(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.columns[0] = string;
        }

        public void setValueColumnCaption(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.columns[1] = string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.rows.get(n).getName();
            }
            return this.rows.get(n).getValue();
        }
    }
}

