/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import lavesdk.resources.Resources;

class OptionIcon
implements Icon {
    private final Icon userIcon;
    private final boolean rolloverEffect;
    private final int width;
    private final int height;
    private static final Icon arrowIcon;
    private static final int arrowAreaWidth;
    private static final int SPACING = 2;
    private static final Color dividerHighlight;
    private static final Color dividerShadow;

    public OptionIcon(Icon icon, boolean bl) throws IllegalArgumentException {
        if (icon == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.userIcon = icon;
        this.rolloverEffect = bl;
        this.width = icon.getIconWidth() + arrowIcon.getIconWidth() + 2;
        this.height = Math.max(icon.getIconHeight(), arrowIcon.getIconHeight());
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public static int getArrowAreaWidth() {
        return arrowAreaWidth;
    }

    public static Icon getArrowIcon() {
        return arrowIcon;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.userIcon.paintIcon(component, graphics, n, n2 + (this.height - this.userIcon.getIconHeight()) / 2);
        arrowIcon.paintIcon(component, graphics, n + this.userIcon.getIconWidth() + 2, n2 + (this.height - arrowIcon.getIconHeight()) / 2);
        if (this.rolloverEffect) {
            Color color = graphics.getColor();
            graphics.setColor(dividerHighlight);
            graphics.drawLine(n + this.userIcon.getIconWidth() + 1, n2, n + this.userIcon.getIconWidth() + 1, n2 + this.height);
            graphics.setColor(dividerShadow);
            graphics.drawLine(n + this.userIcon.getIconWidth() + 2, n2, n + this.userIcon.getIconWidth() + 2, n2 + this.height);
            graphics.setColor(color);
        }
    }

    static {
        dividerHighlight = SystemColor.controlHighlight;
        dividerShadow = SystemColor.controlShadow;
        arrowIcon = Resources.getInstance().DROPDOWN_ARROW_ICON;
        arrowAreaWidth = arrowIcon.getIconWidth();
    }
}

