/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.Option;
import lavesdk.gui.widgets.OptionIcon;

public class OptionComboButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private Option activeOption = null;
    private boolean initialized = false;
    private final OptionComboButtonModel model = new OptionComboButtonModel();
    private final PopupMenuListener popupListener;
    private boolean arrowPressed = false;

    public OptionComboButton() {
        this((Option[])null);
    }

    public OptionComboButton(Option[] optionArray) {
        this.setModel(this.model);
        this.setActiveOption(null, false);
        this.initialized = true;
        if (optionArray != null) {
            for (Option option : optionArray) {
                this.add(option);
            }
        }
        this.popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                OptionComboButton.this.model.setPopUpOpened(false);
                OptionComboButton.this.popupMenu.removePopupMenuListener(this);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OptionComboButton.this.activeOption == null || !OptionComboButton.this.model.isEnabled()) {
                    return;
                }
                if (OptionComboButton.this.isPositionOntoArrow(mouseEvent.getX(), mouseEvent.getY())) {
                    if (!OptionComboButton.this.model.isPopUpOpened() && OptionComboButton.this.popupMenu.getComponentCount() > 0) {
                        OptionComboButton.this.model.setPopUpOpened(true);
                        OptionComboButton.this.popupMenu.addPopupMenuListener(OptionComboButton.this.popupListener);
                        OptionComboButton.this.popupMenu.show(OptionComboButton.this, 0, OptionComboButton.this.getHeight());
                    }
                    OptionComboButton.this.arrowPressed = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (OptionComboButton.this.activeOption == null || !OptionComboButton.this.model.isEnabled()) {
                    return;
                }
                if (!OptionComboButton.this.arrowPressed && !OptionComboButton.this.isPositionOntoArrow(mouseEvent.getX(), mouseEvent.getY())) {
                    OptionComboButton.this.popupMenu.removePopupMenuListener(OptionComboButton.this.popupListener);
                    OptionComboButton.this.model.setPopUpOpened(false);
                    OptionComboButton.this.arrowPressed = false;
                }
                if (!OptionComboButton.this.arrowPressed && OptionComboButton.this.activeOption != null) {
                    OptionComboButton.this.activeOption.fireActionPerformed();
                }
                OptionComboButton.this.arrowPressed = false;
                mouseEvent.consume();
            }
        });
    }

    public Option getActiveOption() {
        if (EDT.isExecutedInEDT()) {
            return this.activeOption;
        }
        return EDT.execute(new GuiRequest<Option>(){

            @Override
            protected Option execute() throws Throwable {
                return OptionComboButton.this.activeOption;
            }
        });
    }

    public void setActiveOption(Option option) throws IllegalArgumentException {
        this.setActiveOption(option, true);
    }

    public void setActiveOption(final Option option, final boolean bl) throws IllegalArgumentException {
        if (option != null && !this.contains(option)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalSetActiveOption(option, bl);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setActiveOption"){

                @Override
                protected void execute() throws Throwable {
                    OptionComboButton.this.internalSetActiveOption(option, bl);
                }
            });
        }
    }

    public boolean contains(final Option option) {
        if (EDT.isExecutedInEDT()) {
            return this.internalContains(option);
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return OptionComboButton.this.internalContains(option);
            }
        });
    }

    public void add(final Option option) throws IllegalArgumentException {
        if (option == null || this.contains(option)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalAdd(option);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    OptionComboButton.this.internalAdd(option);
                }
            });
        }
    }

    public int getOptionCount() {
        if (EDT.isExecutedInEDT()) {
            return this.popupMenu.getComponentCount();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return OptionComboButton.this.popupMenu.getComponentCount();
            }
        });
    }

    public Option getOption(final int n) throws ArrayIndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return (Option)this.popupMenu.getComponent(n);
        }
        return EDT.execute(new GuiRequest<Option>(){

            @Override
            protected Option execute() throws Throwable {
                return (Option)OptionComboButton.this.popupMenu.getComponent(n);
            }
        });
    }

    public void remove(final Option option) throws IllegalArgumentException {
        if (option == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalRemove(option);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".remove"){

                @Override
                protected void execute() throws Throwable {
                    OptionComboButton.this.internalRemove(option);
                }
            });
        }
    }

    @Override
    public void setIcon(Icon icon) {
    }

    @Override
    public void setText(String string) {
    }

    @Override
    public void setRolloverIcon(Icon icon) {
    }

    @Override
    public void setRolloverSelectedIcon(Icon icon) {
    }

    @Override
    public void setDisabledIcon(Icon icon) {
    }

    @Override
    public void setDisabledSelectedIcon(Icon icon) {
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        } else if (component instanceof Option) {
            this.add((Option)component);
        } else {
            throw new IllegalArgumentException("It is only possible to add Option components to an OptionComboButton!");
        }
    }

    private void internalSetActiveOption(Option option, boolean bl) {
        if (option == null || option.isActivatable()) {
            this.activeOption = option;
            Icon icon = this.activeOption != null ? this.activeOption.getCompoundIcon() : OptionIcon.getArrowIcon();
            Icon icon2 = this.activeOption != null ? this.activeOption.getCompoundRolloverIcon() : OptionIcon.getArrowIcon();
            Icon icon3 = this.activeOption != null ? this.activeOption.getCompoundDisabledIcon() : OptionIcon.getArrowIcon();
            super.setIcon(icon);
            super.setRolloverIcon(icon2);
            super.setRolloverSelectedIcon(icon2);
            super.setDisabledIcon(icon3);
            super.setDisabledSelectedIcon(icon3);
            this.setToolTipText(this.activeOption != null ? this.activeOption.getText() : null);
        }
        if (this.activeOption != null && bl) {
            this.activeOption.fireActionPerformed();
        }
    }

    private boolean internalContains(Option option) {
        Component[] componentArray;
        for (Component component : componentArray = this.popupMenu.getComponents()) {
            if (component != option) continue;
            return true;
        }
        return false;
    }

    private void internalAdd(final Option option) {
        if (option.isSeparated()) {
            this.popupMenu.add(new JSeparator());
        }
        this.popupMenu.add(option);
        option.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionComboButton.this.setActiveOption(option, false);
            }
        });
        if (this.activeOption == null) {
            this.setActiveOption(option, false);
        }
    }

    private void internalRemove(Option option) throws IllegalArgumentException {
        this.popupMenu.remove(option);
        if (option == this.activeOption) {
            this.setActiveOption(null, false);
        }
    }

    private boolean isPositionOntoArrow(int n, int n2) {
        return n >= this.getWidth() - OptionIcon.getArrowAreaWidth() - this.getInsets().right;
    }

    private class OptionComboButtonModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = 1L;
        private boolean popupOpened = false;

        public boolean isPopUpOpened() {
            return this.popupOpened;
        }

        public void setPopUpOpened(boolean bl) {
            boolean bl2 = this.popupOpened;
            if (bl2 == bl) {
                return;
            }
            if (bl) {
                if (!this.isPressed() && this.isEnabled()) {
                    this.stateMask |= 5;
                    this.fireStateChanged();
                    this.popupOpened = true;
                }
            } else {
                this.popupOpened = false;
                this.setArmed(false);
                this.setPressed(false);
                this.setRollover(false);
                this.setSelected(false);
            }
        }

        @Override
        public void setPressed(boolean bl) {
            if (!this.popupOpened) {
                super.setPressed(bl);
            }
        }

        @Override
        public void setArmed(boolean bl) {
            if (!this.popupOpened) {
                super.setArmed(bl);
            }
        }

        @Override
        public void setRollover(boolean bl) {
            if (!this.popupOpened) {
                super.setRollover(bl);
            }
        }

        @Override
        public void setSelected(boolean bl) {
            if (!this.popupOpened) {
                super.setSelected(bl);
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            if (!this.popupOpened) {
                super.setEnabled(bl);
            }
        }

        @Override
        protected void fireStateChanged() {
            if (!this.popupOpened) {
                super.fireStateChanged();
            }
        }
    }
}

