/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.OptionIcon;

public class Option
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private final boolean separated;
    private Icon compoundIcon;
    private Icon compoundRolloverIcon;
    private Icon compoundDisabledIcon;
    private Object userData;

    public Option(Icon icon, String string) throws IllegalArgumentException {
        this(icon, string, false);
    }

    public Option(Icon icon, String string, boolean bl) throws IllegalArgumentException {
        super(string, icon);
        this.separated = bl;
        this.userData = null;
    }

    @Override
    public Icon getIcon() {
        if (EDT.isExecutedInEDT()) {
            return super.getIcon();
        }
        return EDT.execute(new GuiRequest<Icon>(){

            @Override
            protected Icon execute() throws Throwable {
                return Option.super.getIcon();
            }
        });
    }

    @Override
    public void setIcon(final Icon icon) throws IllegalArgumentException {
        String string = this.getText();
        if (icon == null && (string == null || string.isEmpty())) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            super.setIcon(icon);
            this.createCompoundIcons(icon);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setIcon"){

                @Override
                protected void execute() throws Throwable {
                    Option.super.setIcon(icon);
                    Option.this.createCompoundIcons(icon);
                }
            });
        }
    }

    @Override
    public String getText() {
        if (EDT.isExecutedInEDT()) {
            return super.getText();
        }
        return EDT.execute(new GuiRequest<String>(){

            @Override
            protected String execute() throws Throwable {
                return Option.super.getText();
            }
        });
    }

    @Override
    public void setText(final String string) throws IllegalArgumentException {
        if (this.getIcon() == null && (string == null || string.isEmpty())) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            super.setText(string);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setText"){

                @Override
                protected void execute() throws Throwable {
                    Option.super.setText(string);
                }
            });
        }
    }

    public final boolean isSeparated() {
        return this.separated;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    Icon getCompoundIcon() {
        return this.compoundIcon;
    }

    Icon getCompoundRolloverIcon() {
        return this.compoundRolloverIcon;
    }

    Icon getCompoundDisabledIcon() {
        return this.compoundDisabledIcon;
    }

    boolean isActivatable() {
        return this.compoundIcon != null;
    }

    void fireActionPerformed() {
        this.doClick(0);
    }

    private void createCompoundIcons(Icon icon) {
        if (icon != null) {
            this.compoundIcon = new OptionIcon(icon, false);
            this.compoundRolloverIcon = new OptionIcon(icon, true);
            BufferedImage bufferedImage = new BufferedImage(this.compoundIcon.getIconWidth(), this.compoundIcon.getIconHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.compoundIcon.paintIcon(null, graphics2D, 0, 0);
            graphics2D.dispose();
            this.compoundDisabledIcon = UIManager.getLookAndFeel().getDisabledIcon(null, new ImageIcon(bufferedImage));
        } else {
            this.compoundIcon = null;
            this.compoundRolloverIcon = null;
            this.compoundDisabledIcon = null;
        }
    }
}

