/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import lavesdk.utils.MathUtils;

public class NumericTextField
extends JTextField {
    private static final long serialVersionUID = 1L;

    public NumericTextField() {
    }

    public NumericTextField(int n) {
        super(n);
    }

    public NumericTextField(Number number) {
        super(number.toString());
    }

    @Override
    public void setText(String string) {
        if (string != null) {
            Double d;
            try {
                d = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = null;
            }
            if (d != null) {
                string = MathUtils.formatDouble(d);
            }
        }
        super.setText(string);
    }

    @Override
    protected Document createDefaultModel() {
        return new NumericDocument();
    }

    private static class NumericDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private NumericDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray;
            if (string == null) {
                return;
            }
            for (char c : cArray = string.toCharArray()) {
                if (Character.isDigit(c) || c == '.' || c == ',' || c == '-') continue;
                return;
            }
            super.insertString(n, new String(cArray), attributeSet);
        }
    }
}

