/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.NumericCellRenderer;
import lavesdk.gui.widgets.NumericTextField;
import lavesdk.gui.widgets.Property;
import lavesdk.gui.widgets.SliderCellEditor;

public class NumericProperty
extends Property {
    public NumericProperty(String string, String string2) throws IllegalArgumentException {
        this(string, string2, 0);
    }

    public NumericProperty(String string, String string2, Number number) throws IllegalArgumentException {
        this(string, string2, number, false);
    }

    public NumericProperty(String string, String string2, boolean bl) throws IllegalArgumentException {
        this(string, string2, 0, bl);
    }

    public NumericProperty(String string, String string2, Number number, boolean bl) throws IllegalArgumentException {
        super(string, string2, number, new Object[]{bl});
    }

    @Override
    public Number getValue() {
        if (EDT.isExecutedInEDT()) {
            return (Number)this.value;
        }
        return EDT.execute(new GuiRequest<Number>(){

            @Override
            protected Number execute() throws Throwable {
                return (Number)NumericProperty.this.value;
            }
        });
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setValue((Number)object);
    }

    public void setValue(final Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.value = number;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setValue"){

                @Override
                protected void execute() throws Throwable {
                    NumericProperty.this.value = number;
                }
            });
        }
    }

    public int getMinimum() {
        if (EDT.isExecutedInEDT()) {
            return this.getSliderRange(true);
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return NumericProperty.this.getSliderRange(true);
            }
        });
    }

    public void setMinimum(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.setSliderRange(n, true);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setMinimum"){

                @Override
                protected void execute() throws Throwable {
                    NumericProperty.this.setSliderRange(n, true);
                }
            });
        }
    }

    public int getMaximum() {
        if (EDT.isExecutedInEDT()) {
            return this.getSliderRange(false);
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return NumericProperty.this.getSliderRange(false);
            }
        });
    }

    public void setMaximum(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.setSliderRange(n, false);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setMaximum"){

                @Override
                protected void execute() throws Throwable {
                    NumericProperty.this.setSliderRange(n, false);
                }
            });
        }
    }

    @Override
    protected TableCellEditor createEditor(Object[] objectArray) {
        if (!((Boolean)objectArray[0]).booleanValue()) {
            return new DefaultCellEditor(new NumericTextField());
        }
        return new SliderCellEditor();
    }

    @Override
    protected TableCellRenderer createRenderer(Object[] objectArray) {
        return new NumericCellRenderer();
    }

    @Override
    protected Class<?> getValueClass() {
        return Number.class;
    }

    @Override
    protected Object onEditStop(Object object) {
        try {
            return NumberFormat.getInstance().parse(object.toString());
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    private int getSliderRange(boolean bl) {
        if (this.editor instanceof SliderCellEditor) {
            return bl ? ((SliderCellEditor)this.editor).getMinimum() : ((SliderCellEditor)this.editor).getMaximum();
        }
        return 0;
    }

    private void setSliderRange(int n, boolean bl) {
        if (this.editor instanceof SliderCellEditor) {
            if (bl) {
                ((SliderCellEditor)this.editor).setMinimum(n);
            } else {
                ((SliderCellEditor)this.editor).setMaximum(n);
            }
        }
    }
}

