/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Transient;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import lavesdk.graphics.CatmullRomSpline;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.BaseComponent;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.MatrixElementFormat;
import lavesdk.math.Matrix;
import lavesdk.math.ObjectMatrix;
import lavesdk.utils.MathUtils;

public class MatrixEditor<T>
extends BaseComponent {
    private static final long serialVersionUID = 1L;
    private Matrix<T> matrix;
    private ObjectMatrix<Mask> matrixMask;
    private final MatrixElementFormat<T> elementFormat;
    private final List<Mask> masks;
    private final EventController eventController;
    private ObjectMatrix<Color> elementBackgrounds;
    private ObjectMatrix<Color> elementForegrounds;
    private int columnSpacing;
    private int rowSpacing;
    private boolean editable;
    private final MatrixDrawingPanel matrixPanel;
    private final JScrollPane scrollPane;
    private boolean initialized;
    private Map<Integer, String> rowLabels;
    private Map<Integer, String> columnLabels;
    private boolean paintLabels;
    private int[] columnWidths;
    private int rowHeight;
    private int rowLabelsWidth;
    private int columnsWidth;
    private int rowFontHeight;
    private int rowFontBaseline;
    private final Dimension largestMaskIcon;
    private CatmullRomSpline leftParenthesisSpline;
    private CatmullRomSpline rightParenthesisSpline;
    private boolean calcRowHeight;
    private boolean calcColumnWidths;
    private boolean calcRowLabelsWidth;
    private Font labelFont;
    private final Stroke parenthesisSplineStroke;
    private final Color selBackground;
    private final Color selForeground;
    private ElementPosition selElement;
    private long lastKeyTyped;
    private String keyTypedString;
    private ElementPosition keyTypedSelElem;
    private final List<Strikeout> rowStrikeouts;
    private final List<Strikeout> columnStrikeouts;
    private boolean autoRepaint;
    private static final Color DEF_BACKGROUND = Color.white;
    private static final Color DEF_FOREGROUND = Color.black;
    private static final int PARENTHESISWIDTH = 2;
    private static final int PARENTHESISAREA_WIDTH = 10;
    private static final int PADDING = 4;
    private static final int DEF_COLUMN_SPACING = 4;
    private static final int DEF_ROW_SPACING = 2;

    public MatrixEditor(MatrixElementFormat<T> matrixElementFormat) throws IllegalArgumentException {
        this(matrixElementFormat, null);
    }

    public MatrixEditor(MatrixElementFormat<T> matrixElementFormat, Matrix<T> matrix) throws IllegalArgumentException {
        if (matrixElementFormat == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.initialized = false;
        this.elementFormat = matrixElementFormat;
        this.matrixPanel = new MatrixDrawingPanel();
        this.scrollPane = new JScrollPane(this.matrixPanel);
        this.masks = new ArrayList<Mask>();
        this.eventController = new EventController();
        this.rowLabels = null;
        this.columnLabels = null;
        this.paintLabels = false;
        this.columnSpacing = 4;
        this.rowSpacing = 2;
        this.editable = true;
        this.columnWidths = null;
        this.rowHeight = 0;
        this.rowLabelsWidth = 0;
        this.columnsWidth = 0;
        this.rowFontHeight = 0;
        this.rowFontBaseline = 0;
        this.largestMaskIcon = new Dimension();
        this.leftParenthesisSpline = null;
        this.rightParenthesisSpline = null;
        this.calcColumnWidths = true;
        this.calcRowHeight = true;
        this.calcRowLabelsWidth = true;
        this.parenthesisSplineStroke = new BasicStroke(2.0f);
        this.selBackground = SystemColor.textHighlight;
        this.selForeground = SystemColor.textHighlightText;
        this.selElement = null;
        this.lastKeyTyped = 0L;
        this.keyTypedString = "";
        this.keyTypedSelElem = null;
        this.rowStrikeouts = new ArrayList<Strikeout>();
        this.columnStrikeouts = new ArrayList<Strikeout>();
        this.autoRepaint = false;
        this.setMatrix(matrix);
        this.internalSetFont(UIManager.getFont("Label.font"));
        this.setFocusable(true);
        super.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setBackground(DEF_BACKGROUND);
        this.matrixPanel.setBackground(DEF_BACKGROUND);
        this.addKeyListener(this.eventController);
        this.matrixPanel.addMouseListener(this.eventController);
        this.matrixPanel.addMouseMotionListener(this.eventController);
        this.initialized = true;
    }

    public boolean getAutoRepaint() {
        return this.autoRepaint;
    }

    public void setAutoRepaint(boolean bl) {
        this.autoRepaint = bl;
    }

    public boolean isEditable() {
        if (EDT.isExecutedInEDT()) {
            return this.editable;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return MatrixEditor.this.editable;
            }
        });
    }

    public void setEditable(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.editable = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEditable"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.editable = bl;
                }
            });
        }
        if (!bl) {
            this.clearSelection();
        }
    }

    public void clearSelection() {
        if (EDT.isExecutedInEDT()) {
            this.selElement = null;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".clearSelection"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.selElement = null;
                }
            });
        }
        this.matrixPanel.repaint();
    }

    public final Matrix<T> getMatrix() {
        if (EDT.isExecutedInEDT()) {
            return this.matrix;
        }
        return (Matrix)EDT.execute(new GuiRequest<Matrix<T>>(){

            @Override
            protected Matrix<T> execute() throws Throwable {
                return MatrixEditor.this.matrix;
            }
        });
    }

    public final void setMatrix(final Matrix<T> matrix) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetMatrix(matrix);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setMatrix"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.internalSetMatrix(matrix);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public int getMaskCount() {
        if (EDT.isExecutedInEDT()) {
            return this.masks.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return MatrixEditor.this.masks.size();
            }
        });
    }

    public Mask getMask(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.masks.get(n);
        }
        return EDT.execute(new GuiRequest<Mask>(){

            @Override
            protected Mask execute() throws Throwable {
                return (Mask)MatrixEditor.this.masks.get(n);
            }
        });
    }

    public void addMask(final Mask mask) {
        if (mask == null || this.masks.contains(mask)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.masks.add(mask);
            this.updateMatrixMask();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addMask"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.masks.add(mask);
                    MatrixEditor.this.updateMatrixMask();
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeMask(final Mask mask) {
        if (mask == null || !this.masks.contains(mask)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.masks.remove(mask);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeMask"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.masks.remove(mask);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public Color getElementBackground(final int n, final int n2) {
        if (EDT.isExecutedInEDT()) {
            return this.elementBackgrounds != null && this.elementBackgrounds.isInDimension(n, n2) ? (Color)this.elementBackgrounds.get(n, n2) : DEF_BACKGROUND;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return MatrixEditor.this.elementBackgrounds != null && MatrixEditor.this.elementBackgrounds.isInDimension(n, n2) ? (Color)MatrixEditor.this.elementBackgrounds.get(n, n2) : DEF_BACKGROUND;
            }
        });
    }

    public void setElementBackground(final int n, final int n2, final Color color) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            if (this.elementBackgrounds != null) {
                this.elementBackgrounds.set(n, n2, color);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setElementBackground"){

                @Override
                protected void execute() throws Throwable {
                    if (MatrixEditor.this.elementBackgrounds != null) {
                        MatrixEditor.this.elementBackgrounds.set(n, n2, color);
                    }
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public Color getElementForeground(final int n, final int n2) {
        if (EDT.isExecutedInEDT()) {
            return this.elementForegrounds != null && this.elementForegrounds.isInDimension(n, n2) ? (Color)this.elementForegrounds.get(n, n2) : DEF_FOREGROUND;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return MatrixEditor.this.elementForegrounds != null && MatrixEditor.this.elementForegrounds.isInDimension(n, n2) ? (Color)MatrixEditor.this.elementForegrounds.get(n, n2) : DEF_FOREGROUND;
            }
        });
    }

    public void setElementForeground(final int n, final int n2, final Color color) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            if (this.elementForegrounds != null) {
                this.elementForegrounds.set(n, n2, color);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setElementForeground"){

                @Override
                protected void execute() throws Throwable {
                    if (MatrixEditor.this.elementForegrounds != null) {
                        MatrixEditor.this.elementForegrounds.set(n, n2, color);
                    }
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public int getColumnSpacing() {
        if (EDT.isExecutedInEDT()) {
            return this.columnSpacing;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return MatrixEditor.this.columnSpacing;
            }
        });
    }

    public void setColumnSpacing(final int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.columnSpacing = n;
            this.calcColumnWidths = true;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setColumnSpacing"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.columnSpacing = n;
                    MatrixEditor.this.calcColumnWidths = true;
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public int getRowSpacing() {
        if (EDT.isExecutedInEDT()) {
            return this.rowSpacing;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return MatrixEditor.this.rowSpacing;
            }
        });
    }

    public void setRowSpacing(final int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.rowSpacing = n;
            this.calcRowHeight = true;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setRowSpacing"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.rowSpacing = n;
                    MatrixEditor.this.calcRowHeight = true;
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public boolean isPaintLabels() {
        if (EDT.isExecutedInEDT()) {
            return this.paintLabels;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return MatrixEditor.this.paintLabels;
            }
        });
    }

    public void setPaintLabels(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.paintLabels = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setPaintLabels"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.paintLabels = bl;
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setRowLabels(final Map<Integer, String> map) {
        if (EDT.isExecutedInEDT()) {
            this.rowLabels = map;
            this.calcRowLabelsWidth = true;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setRowLabels"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.rowLabels = map;
                    MatrixEditor.this.calcRowLabelsWidth = true;
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setColumnLabels(final Map<Integer, String> map) {
        if (EDT.isExecutedInEDT()) {
            this.columnLabels = map;
            this.calcColumnWidths = true;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setColumnLabels"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.columnLabels = map;
                    MatrixEditor.this.calcColumnWidths = true;
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void addRowStrikeout(final Strikeout strikeout) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.addStrikeout(this.rowStrikeouts, strikeout);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addRowStrikeout"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.addStrikeout(MatrixEditor.this.rowStrikeouts, strikeout);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeRowStrikeout(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.removeStrikeout(this.rowStrikeouts, n);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeRowStrikeout"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.removeStrikeout(MatrixEditor.this.rowStrikeouts, n);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeLastRowStrikeout() {
        if (EDT.isExecutedInEDT()) {
            this.removeLastStrikeout(this.rowStrikeouts);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeLastRowStrikeout"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.removeLastStrikeout(MatrixEditor.this.rowStrikeouts);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeAllRowStrikeouts() {
        if (EDT.isExecutedInEDT()) {
            this.rowStrikeouts.clear();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllRowStrikeouts"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.rowStrikeouts.clear();
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void addColumnStrikeout(final Strikeout strikeout) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.addStrikeout(this.columnStrikeouts, strikeout);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addColumnStrikeout"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.addStrikeout(MatrixEditor.this.columnStrikeouts, strikeout);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeColumnStrikeout(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.removeStrikeout(this.columnStrikeouts, n);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeColumnStrikeout"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.removeStrikeout(MatrixEditor.this.columnStrikeouts, n);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeLastColumnStrikeout() {
        if (EDT.isExecutedInEDT()) {
            this.removeLastStrikeout(this.columnStrikeouts);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeLastColumnStrikeout"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.removeLastStrikeout(MatrixEditor.this.columnStrikeouts);
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void removeAllColumnStrikeouts() {
        if (EDT.isExecutedInEDT()) {
            this.columnStrikeouts.clear();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllColumnStrikeouts"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.columnStrikeouts.clear();
                }
            });
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public int getRowHeight() {
        if (EDT.isExecutedInEDT()) {
            this.recomputeSize();
            return this.rowHeight;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                MatrixEditor.this.recomputeSize();
                return MatrixEditor.this.rowHeight;
            }
        });
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetFont(font);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    MatrixEditor.this.internalSetFont(font);
                }
            });
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    @Transient
    public Dimension getPreferredSize() {
        if (EDT.isExecutedInEDT()) {
            this.recomputeSize();
            return this.scrollPane.getPreferredSize();
        }
        return EDT.execute(new GuiRequest<Dimension>(){

            @Override
            protected Dimension execute() throws Throwable {
                MatrixEditor.this.recomputeSize();
                return MatrixEditor.this.scrollPane.getPreferredSize();
            }
        });
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        }
    }

    @Override
    protected void repaintComponent() {
        super.repaintComponent();
        this.matrixPanel.repaint();
    }

    private void keyReleased(KeyEvent keyEvent) {
        if (!this.editable) {
            return;
        }
        if (this.selElement == null || this.matrix == null) {
            return;
        }
        if (keyEvent.getKeyCode() == 38) {
            this.selElement = new ElementPosition(Math.max(this.selElement.rowIndex - 1, 0), this.selElement.colIndex);
        } else if (keyEvent.getKeyCode() == 40) {
            this.selElement = new ElementPosition(Math.min(this.selElement.rowIndex + 1, this.matrix.getRowCount() - 1), this.selElement.colIndex);
        } else if (keyEvent.getKeyCode() == 37) {
            this.selElement = new ElementPosition(this.selElement.rowIndex, Math.max(this.selElement.colIndex - 1, 0));
        } else if (keyEvent.getKeyCode() == 39) {
            this.selElement = new ElementPosition(this.selElement.rowIndex, Math.min(this.selElement.colIndex + 1, this.matrix.getColumnCount() - 1));
        } else if (keyEvent.getKeyCode() == 127 && keyEvent.getModifiers() == 0 && this.matrix.isInDimension(this.selElement.rowIndex, this.selElement.colIndex)) {
            this.matrix.set(this.selElement.rowIndex, this.selElement.colIndex, null);
            this.updateMatrixMask();
            this.calcColumnWidths = true;
        }
        this.matrixPanel.repaint();
    }

    private void keyTyped(KeyEvent keyEvent) {
        if (!this.editable) {
            return;
        }
        if (this.selElement == null || this.matrix == null) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c < ' ' || c == '~') {
            return;
        }
        this.keyTypedString = keyEvent.getWhen() - this.lastKeyTyped <= 500L && this.selElement == this.keyTypedSelElem ? this.keyTypedString + keyEvent.getKeyChar() : "" + keyEvent.getKeyChar();
        T t = this.elementFormat.parse(this.keyTypedString);
        if (t != null && this.matrix.isInDimension(this.selElement.rowIndex, this.selElement.colIndex)) {
            this.matrix.set(this.selElement.rowIndex, this.selElement.colIndex, t);
            this.updateMatrixMask();
        }
        this.keyTypedSelElem = this.selElement;
        this.lastKeyTyped = keyEvent.getWhen();
        this.calcColumnWidths = true;
        this.matrixPanel.repaint();
    }

    private void mouseDown(MouseEvent mouseEvent) {
        this.requestFocus();
        if (!this.editable) {
            return;
        }
        this.selElement = this.getElementFromPosition(mouseEvent.getX(), mouseEvent.getY());
        this.matrixPanel.repaint();
    }

    private void mouseMove(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        if (this.getElementFromPosition(mouseEvent.getX(), mouseEvent.getY()) != null) {
            this.matrixPanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.matrixPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.matrixPanel.setCursor(Cursor.getDefaultCursor());
    }

    private ElementPosition getElementFromPosition(int n, int n2) {
        if (n < this.getMatrixX() || n > this.getMatrixX() + this.getMatrixWidth() || this.matrix == null || this.rowHeight < 1) {
            return null;
        }
        int n3 = (n2 - this.getMatrixY()) / this.rowHeight;
        if (n3 < 0 && n3 >= this.matrix.getRowCount()) {
            return null;
        }
        int n4 = this.getMatrixX();
        for (int i = 0; i < this.columnWidths.length; ++i) {
            int n5 = n4 + this.columnWidths[i];
            if (n >= n4 && n < n5) {
                return new ElementPosition(n3, i);
            }
            n4 = n5;
        }
        return null;
    }

    private void addStrikeout(List<Strikeout> list, Strikeout strikeout) throws IllegalArgumentException {
        if (strikeout == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        int n = this.getListIndexOfStrikeout(list, strikeout.getIndex());
        if (n >= 0) {
            list.remove(n);
        }
        list.add(strikeout);
    }

    private void removeStrikeout(List<Strikeout> list, int n) {
        for (int i = list.size(); i >= 0; --i) {
            if (list.get(i).getIndex() != n) continue;
            list.remove(i);
            break;
        }
    }

    private void removeLastStrikeout(List<Strikeout> list) {
        if (list.size() > 0) {
            list.remove(list.size() - 1);
        }
    }

    private int getListIndexOfStrikeout(List<Strikeout> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getIndex() != n) continue;
            return i;
        }
        return -1;
    }

    private void internalSetMatrix(Matrix<T> matrix) {
        if (matrix != null) {
            boolean bl = this.matrix == null || this.matrix.getRowCount() != matrix.getRowCount() || this.matrix.getColumnCount() != matrix.getColumnCount();
            this.matrix = matrix.clone();
            if (bl) {
                ObjectMatrix<Color> objectMatrix = this.elementBackgrounds;
                ObjectMatrix<Color> objectMatrix2 = this.elementForegrounds;
                this.elementBackgrounds = new ObjectMatrix<Color>(matrix.getRowCount(), matrix.getColumnCount(), DEF_BACKGROUND);
                this.elementForegrounds = new ObjectMatrix<Color>(matrix.getRowCount(), matrix.getColumnCount(), DEF_FOREGROUND);
                if (objectMatrix != null) {
                    Matrix.copy(objectMatrix, this.elementBackgrounds);
                }
                if (objectMatrix2 != null) {
                    Matrix.copy(objectMatrix2, this.elementForegrounds);
                }
            }
            this.updateMatrixMask();
        } else {
            this.matrix = null;
            this.matrixMask = null;
            this.elementBackgrounds = null;
            this.elementForegrounds = null;
        }
        this.selElement = null;
        this.calcColumnWidths = true;
    }

    private void internalSetFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        this.labelFont = font.deriveFont(1);
        this.calcRowHeight = true;
        this.calcRowLabelsWidth = true;
        this.calcColumnWidths = true;
    }

    private void recomputeSize() {
        if (this.hasSizeChanged()) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.computeValues(graphics2D);
        }
    }

    private int getMatrixX() {
        return this.rowLabelsWidth + 10 + 4;
    }

    private int getMatrixY() {
        return (this.validLabelMap(this.columnLabels) ? this.rowFontHeight : 0) + 4;
    }

    private int getMatrixWidth() {
        return this.columnsWidth;
    }

    private int getMatrixWidthComplete() {
        return this.rowLabelsWidth + this.columnsWidth + 20 + 8;
    }

    private int getMatrixHeight() {
        return this.matrix != null ? this.matrix.getRowCount() * this.rowHeight : 0;
    }

    private int getMatrixHeightComplete() {
        return this.getMatrixHeight() + (this.validLabelMap(this.columnLabels) ? this.rowFontHeight : 0) + 8;
    }

    private Mask getMask(Object object) {
        for (Mask mask : this.masks) {
            if (!mask.matches(object)) continue;
            return mask;
        }
        return null;
    }

    private String getLabel(Map<Integer, String> map, int n) {
        String string = map != null ? map.get(n) : null;
        return string != null ? string : "";
    }

    private boolean validLabelMap(Map<Integer, String> map) {
        return map != null;
    }

    private void updateMatrixMask() {
        if (this.matrix == null) {
            return;
        }
        if (this.matrixMask == null || this.matrixMask.getRowCount() != this.matrix.getRowCount() || this.matrixMask.getColumnCount() != this.matrix.getColumnCount()) {
            this.matrixMask = new ObjectMatrix(this.matrix.getRowCount(), this.matrix.getColumnCount());
        }
        this.largestMaskIcon.height = 0;
        this.largestMaskIcon.width = 0;
        for (int i = 0; i < this.matrix.getRowCount(); ++i) {
            for (int j = 0; j < this.matrix.getColumnCount(); ++j) {
                Mask mask = this.getMask(this.matrix.get(i, j));
                this.matrixMask.set(i, j, mask);
                if (mask == null || mask.getType() != Mask.Type.ICON_MASK) continue;
                this.largestMaskIcon.width = Math.max(mask.getMaskIcon().getIconWidth(), this.largestMaskIcon.width);
                this.largestMaskIcon.height = Math.max(mask.getMaskIcon().getIconHeight(), this.largestMaskIcon.height);
            }
        }
    }

    private boolean hasSizeChanged() {
        return this.calcRowHeight || this.calcRowLabelsWidth || this.calcColumnWidths;
    }

    private void computeValues(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.matrix == null) {
            return;
        }
        graphics2D.setFont(this.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(this.labelFont);
        boolean bl = this.hasSizeChanged();
        if (this.calcRowHeight) {
            this.rowFontBaseline = fontMetrics.getAscent();
            this.rowFontHeight = fontMetrics.getHeight();
            this.rowHeight = (this.rowFontHeight >= this.largestMaskIcon.height ? this.rowFontHeight : this.largestMaskIcon.height) + this.rowSpacing;
        }
        if (this.calcRowLabelsWidth) {
            n4 = 0;
            if (this.validLabelMap(this.rowLabels)) {
                for (n3 = 0; n3 < this.matrix.getRowCount(); ++n3) {
                    n2 = fontMetrics2.stringWidth(this.getLabel(this.rowLabels, n3));
                    if (n2 <= n4) continue;
                    n4 = n2;
                }
            }
            this.rowLabelsWidth = n4 + 2;
        }
        if (this.calcColumnWidths) {
            this.columnWidths = new int[this.matrix.getColumnCount()];
            this.columnsWidth = 0;
            if (this.validLabelMap(this.columnLabels)) {
                for (n3 = 0; n3 < this.columnWidths.length; ++n3) {
                    this.columnWidths[n3] = fontMetrics2.stringWidth(this.getLabel(this.columnLabels, n3));
                }
            }
            for (n3 = 0; n3 < this.matrix.getColumnCount(); ++n3) {
                n4 = this.columnWidths[n3];
                for (n = 0; n < this.matrix.getRowCount(); ++n) {
                    n2 = fontMetrics.stringWidth(this.elementFormat.format(this.matrix.get(n, n3)));
                    if (n2 <= n4) continue;
                    n4 = n2;
                }
                if (n4 < this.largestMaskIcon.width) {
                    n4 = this.largestMaskIcon.width;
                }
                this.columnWidths[n3] = n4 + this.columnSpacing;
                this.columnsWidth += this.columnWidths[n3];
            }
        }
        if (bl) {
            n4 = this.getMatrixY();
            n2 = this.getMatrixHeight();
            n3 = this.getMatrixX() - 10;
            n = this.getMatrixX() + this.getMatrixWidth();
            this.leftParenthesisSpline = new CatmullRomSpline(new Point[]{new Point(n3 + 10 - 2, n4), new Point(n3 + 2, n4 + n2 * 1 / 5), new Point(n3 + 2, n4 + n2 * 4 / 5), new Point(n3 + 10 - 2, n4 + n2)});
            this.rightParenthesisSpline = new CatmullRomSpline(new Point[]{new Point(n + 2, n4), new Point(n + 10 - 2, n4 + n2 * 1 / 5), new Point(n + 10 - 2, n4 + n2 * 4 / 5), new Point(n + 2, n4 + n2)});
        }
        this.calcRowHeight = false;
        this.calcRowLabelsWidth = false;
        this.calcColumnWidths = false;
        if (bl) {
            this.matrixPanel.setPreferredSize(new Dimension(this.getMatrixWidthComplete(), this.getMatrixHeightComplete()));
            this.matrixPanel.revalidate();
        }
    }

    private void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        if (this.matrix == null) {
            return;
        }
        graphics2D.setFont(this.getFont());
        this.computeValues(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.parenthesisSplineStroke);
        graphics2D.draw(this.leftParenthesisSpline.getPath());
        graphics2D.draw(this.rightParenthesisSpline.getPath());
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(this.labelFont);
        int n3 = 4 + this.rowLabelsWidth + 10;
        int n4 = 4 + (this.validLabelMap(this.columnLabels) ? this.rowFontHeight : 0);
        int[] nArray = new int[this.columnWidths.length];
        int n5 = n3;
        int n6 = n4;
        for (n2 = 0; n2 < this.matrix.getRowCount(); ++n2) {
            String string = this.getLabel(this.rowLabels, n2);
            if (!string.isEmpty()) {
                graphics2D.setFont(this.labelFont);
                graphics2D.setColor(DEF_FOREGROUND);
                graphics2D.drawString(string, 4, n6 + this.rowFontBaseline);
            }
            for (n = 0; n < this.matrix.getColumnCount(); ++n) {
                if (n2 == 0) {
                    string = this.getLabel(this.columnLabels, n);
                    if (!string.isEmpty()) {
                        graphics2D.setFont(this.labelFont);
                        graphics2D.setColor(DEF_FOREGROUND);
                        graphics2D.drawString(string, n5 + (this.columnWidths[n] - fontMetrics2.stringWidth(string)) / 2, 4 + this.rowFontBaseline);
                    }
                    nArray[n] = n5;
                }
                Mask mask = (Mask)this.matrixMask.get(n2, n);
                String string2 = this.elementFormat.format(this.matrix.get(n2, n));
                Color color = (Color)this.elementBackgrounds.get(n2, n);
                Color color2 = (Color)this.elementForegrounds.get(n2, n);
                if (this.selElement != null && n2 == this.selElement.rowIndex && n == this.selElement.colIndex) {
                    color = this.selBackground;
                    color2 = this.selForeground;
                }
                if (!color.equals(DEF_BACKGROUND)) {
                    graphics2D.setColor(color);
                    graphics2D.fillRect(n5, n6, this.columnWidths[n], this.rowHeight);
                }
                graphics2D.setColor(color2);
                graphics2D.setFont(this.getFont());
                if (mask != null) {
                    switch (mask.getType()) {
                        case OBJECT_MASK: {
                            string2 = mask.getMaskObject().toString();
                            break;
                        }
                        case ICON_MASK: {
                            string2 = "";
                            Icon icon = mask.getMaskIcon();
                            icon.paintIcon(this.matrixPanel, graphics2D, n5 + (this.columnWidths[n] - icon.getIconWidth()) / 2, n6 + (this.rowHeight - icon.getIconHeight()) / 2);
                        }
                    }
                }
                if (!string2.isEmpty()) {
                    graphics2D.drawString(string2, n5 + (this.columnWidths[n] - fontMetrics.stringWidth(string2)) / 2, n6 + (this.rowHeight - this.rowFontHeight) / 2 + this.rowFontBaseline);
                }
                n5 += this.columnWidths[n];
            }
            n6 += this.rowHeight;
            n5 = n3;
        }
        n2 = n3 + this.columnsWidth + 10;
        n = n4 + this.rowHeight / 2;
        for (Strikeout strikeout : this.rowStrikeouts) {
            if (strikeout.getIndex() >= this.matrix.getRowCount()) continue;
            graphics2D.setColor(strikeout.getColor());
            graphics2D.setStroke(strikeout.getStroke());
            graphics2D.drawLine(4, n + this.rowHeight * strikeout.getIndex() - strikeout.getLineWidth() / 2, n2, n + this.rowHeight * strikeout.getIndex() - strikeout.getLineWidth() / 2);
        }
        for (Strikeout strikeout : this.columnStrikeouts) {
            if (strikeout.getIndex() >= this.matrix.getColumnCount()) continue;
            int n7 = nArray[strikeout.getIndex()] + (this.columnWidths[strikeout.getIndex()] - strikeout.getLineWidth()) / 2;
            graphics2D.setColor(strikeout.getColor());
            graphics2D.setStroke(strikeout.getStroke());
            graphics2D.drawLine(n7, 4, n7, n4 + this.matrix.getRowCount() * this.rowHeight);
        }
        graphics2D.setStroke(stroke);
    }

    public static class DoubleElementFormat
    extends NumericElementFormat<Double> {
        public DoubleElementFormat() {
        }

        public DoubleElementFormat(String string) throws IllegalArgumentException {
            super(string);
        }

        @Override
        protected Double getInfinity() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        protected Double parseElement(String string) throws ParseException {
            return NumberFormat.getInstance().parse(string).doubleValue();
        }
    }

    public static class FloatElementFormat
    extends NumericElementFormat<Float> {
        public FloatElementFormat() {
        }

        public FloatElementFormat(String string) throws IllegalArgumentException {
            super(string);
        }

        @Override
        protected Float getInfinity() {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }

        @Override
        protected Float parseElement(String string) throws ParseException {
            return Float.valueOf(NumberFormat.getInstance().parse(string).floatValue());
        }
    }

    public static class LongElementFormat
    extends NumericElementFormat<Long> {
        public LongElementFormat() {
        }

        public LongElementFormat(String string) throws IllegalArgumentException {
            super(string);
        }

        @Override
        protected Long getInfinity() {
            return Long.MAX_VALUE;
        }

        @Override
        protected Long parseElement(String string) throws ParseException {
            return NumberFormat.getInstance().parse(string).longValue();
        }
    }

    public static class IntegerElementFormat
    extends NumericElementFormat<Integer> {
        public IntegerElementFormat() {
        }

        public IntegerElementFormat(String string) throws IllegalArgumentException {
            super(string);
        }

        @Override
        protected Integer getInfinity() {
            return Integer.MAX_VALUE;
        }

        @Override
        protected Integer parseElement(String string) throws ParseException {
            return NumberFormat.getInstance().parse(string).intValue();
        }
    }

    public static abstract class NumericElementFormat<T extends Number>
    extends MatrixElementFormat<T> {
        private final String infinityChar;

        public NumericElementFormat() {
            this("-");
        }

        public NumericElementFormat(String string) throws IllegalArgumentException {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.infinityChar = string;
        }

        @Override
        public String format(T t) {
            if (t != null) {
                return MathUtils.formatDouble(((Number)t).doubleValue());
            }
            return "";
        }

        @Override
        public T parse(String string) {
            if (string.equals(this.infinityChar)) {
                return this.getInfinity();
            }
            try {
                return this.parseElement(string);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        protected abstract T getInfinity();

        protected abstract T parseElement(String var1) throws ParseException;
    }

    public static class StringElementFormat
    extends MatrixElementFormat<String> {
        @Override
        public String format(String string) {
            if (string == null) {
                return "";
            }
            return string;
        }

        @Override
        public String parse(String string) {
            return string;
        }
    }

    public static class Strikeout {
        private final int index;
        private final Color color;
        private final int lineWidth;
        private final Stroke stroke;

        public Strikeout(int n, Color color) throws IllegalArgumentException {
            this(n, color, 1);
        }

        public Strikeout(int n, Color color, int n2) throws IllegalArgumentException {
            if (n < 0 || color == null || n2 < 1) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.index = n;
            this.color = color;
            this.lineWidth = n2;
            this.stroke = new BasicStroke(n2);
        }

        public final int getIndex() {
            return this.index;
        }

        public final Color getColor() {
            return this.color;
        }

        public final int getLineWidth() {
            return this.lineWidth;
        }

        Stroke getStroke() {
            return this.stroke;
        }
    }

    private class EventController
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        private EventController() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MatrixEditor.this.mouseExited(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MatrixEditor.this.mouseDown(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MatrixEditor.this.mouseMove(mouseEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            MatrixEditor.this.keyReleased(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            MatrixEditor.this.keyTyped(keyEvent);
        }
    }

    private class MatrixDrawingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private MatrixDrawingPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            MatrixEditor.this.paint((Graphics2D)graphics);
        }
    }

    private class ElementPosition {
        public int rowIndex;
        public int colIndex;

        public ElementPosition(int n, int n2) {
            this.rowIndex = n;
            this.colIndex = n2;
        }
    }
}

