/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.Legend;
import lavesdk.resources.Resources;

class LegendItemGroup
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Legend legend;
    private final JLabel groupLbl;
    private final JLabel groupBtn;
    private boolean initialized;
    private boolean expanded;

    public LegendItemGroup(Legend legend, String string) throws IllegalArgumentException {
        if (legend == null || string == null || string.isEmpty()) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.initialized = false;
        this.legend = legend;
        this.groupLbl = new JLabel(string);
        this.expanded = true;
        this.groupBtn = new JLabel(Resources.getInstance().COLLAPSE_ICON);
        super.setLayout(new BorderLayout());
        this.add((Component)this.groupLbl, "Center");
        this.add((Component)this.groupBtn, "East");
        this.setBackground(legend.getGroupBackground());
        this.setForeground(legend.getGroupForeground());
        Font font = legend.getFont();
        if (font != null) {
            this.setFont(font);
        }
        this.initialized = true;
        this.groupBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.groupBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                LegendItemGroup.this.toggle();
            }
        });
    }

    public final String getGroupName() {
        if (EDT.isExecutedInEDT()) {
            return this.groupLbl.getText();
        }
        return EDT.execute(new GuiRequest<String>(){

            @Override
            protected String execute() throws Throwable {
                return LegendItemGroup.this.groupLbl.getText();
            }
        });
    }

    @Override
    public Color getBackground() {
        if (EDT.isExecutedInEDT()) {
            return super.getBackground();
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return LegendItemGroup.super.getBackground();
            }
        });
    }

    @Override
    public void setBackground(final Color color) {
        if (EDT.isExecutedInEDT()) {
            super.setBackground(color);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setBackground"){

                @Override
                protected void execute() throws Throwable {
                    LegendItemGroup.super.setBackground(color);
                }
            });
        }
    }

    @Override
    public Color getForeground() {
        if (EDT.isExecutedInEDT()) {
            return super.getForeground();
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return LegendItemGroup.super.getForeground();
            }
        });
    }

    @Override
    public void setForeground(final Color color) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetForeground(color);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setForeground"){

                @Override
                protected void execute() throws Throwable {
                    LegendItemGroup.this.internalSetForeground(color);
                }
            });
        }
    }

    public final boolean isExpanded() {
        if (EDT.isExecutedInEDT()) {
            return this.expanded;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return LegendItemGroup.this.expanded;
            }
        });
    }

    @Override
    public Font getFont() {
        if (EDT.isExecutedInEDT()) {
            return this.groupLbl != null ? this.groupLbl.getFont() : super.getFont();
        }
        return EDT.execute(new GuiRequest<Font>(){

            @Override
            protected Font execute() throws Throwable {
                return LegendItemGroup.this.groupLbl != null ? LegendItemGroup.this.groupLbl.getFont() : LegendItemGroup.super.getFont();
            }
        });
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            if (this.groupLbl != null) {
                this.groupLbl.setFont(font.deriveFont(1));
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    if (LegendItemGroup.this.groupLbl != null) {
                        LegendItemGroup.this.groupLbl.setFont(font.deriveFont(1));
                    }
                }
            });
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        }
    }

    private void toggle() {
        boolean bl = this.expanded = !this.expanded;
        if (this.expanded) {
            this.groupBtn.setIcon(Resources.getInstance().COLLAPSE_ICON);
        } else {
            this.groupBtn.setIcon(Resources.getInstance().EXPAND_ICON);
        }
        this.legend.toggleGroup(this);
    }

    private void internalSetForeground(Color color) {
        super.setForeground(color);
        if (this.groupLbl != null) {
            this.groupLbl.setForeground(color);
        }
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color));
    }
}

