/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;

public class LegendItem
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final String itemName;
    private final String groupName;
    private final JLabel lblText;
    private final JLabel lblIcon;
    private boolean initialized;
    private static final int DEF_ICONSIZE = 16;
    public static final int LINETYPE_LEFT_TO_RIGHT = 1;
    public static final int LINETYPE_TOP_TO_BOTTOM = 2;
    public static final int LINETYPE_TOPLEFT_TO_BOTTOMRIGHT = 3;
    public static final int LINETYPE_BOTTOMLEFT_TO_TOPRIGHT = 4;

    public LegendItem(String string, String string2, String string3) throws IllegalArgumentException {
        this(string, string2, string3, null);
    }

    public LegendItem(String string, String string2, String string3, Icon icon) throws IllegalArgumentException {
        if (string == null || string.isEmpty() || string2 == null || string3 == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.initialized = false;
        this.itemName = string;
        this.groupName = string2;
        this.lblText = new JLabel(!string3.isEmpty() ? "<html>" + string3 + "</html>" : "");
        this.lblIcon = new JLabel(icon);
        super.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.lblIcon, "West");
        this.add((Component)this.lblText, "Center");
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.initialized = true;
    }

    public final String getItemName() {
        return this.itemName;
    }

    public final String getGroupName() {
        return this.groupName;
    }

    @Override
    public Font getFont() {
        if (EDT.isExecutedInEDT()) {
            return this.lblText != null ? this.lblText.getFont() : super.getFont();
        }
        return EDT.execute(new GuiRequest<Font>(){

            @Override
            protected Font execute() throws Throwable {
                return LegendItem.this.lblText != null ? LegendItem.this.lblText.getFont() : LegendItem.super.getFont();
            }
        });
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            if (this.lblText != null) {
                this.lblText.setFont(font);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    if (LegendItem.this.lblText != null) {
                        LegendItem.this.lblText.setFont(font);
                    }
                }
            });
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        }
    }

    public static Icon createCircleIcon(Color color, Color color2, int n) throws IllegalArgumentException {
        return LegendItem.createCircleIcon(color, color2, n, 16, 16);
    }

    public static Icon createCircleIcon(final Color color, final Color color2, final int n, final int n2, final int n3) throws IllegalArgumentException {
        if (color == null || color2 == null || n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return new Icon(){
            private final Stroke edgeStroke;
            {
                this.edgeStroke = new BasicStroke(n);
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n4, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n32 = (int)((float)n / 2.0f + 0.5f);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setColor(color);
                graphics2D.fillOval(n4 + n32, n22 + n32, n2 - 2 * n32, n3 - 2 * n32);
                graphics2D.setColor(color2);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.edgeStroke);
                graphics2D.drawOval(n4 + n32, n22 + n32, n2 - 2 * n32, n3 - 2 * n32);
                graphics2D.setStroke(stroke);
            }

            @Override
            public int getIconWidth() {
                return n3;
            }

            @Override
            public int getIconHeight() {
                return n2;
            }
        };
    }

    public static Icon createLineIcon(Color color, int n) throws IllegalArgumentException {
        return LegendItem.createLineIcon(color, n, 1);
    }

    public static Icon createLineIcon(Color color, int n, int n2) throws IllegalArgumentException {
        return LegendItem.createLineIcon(color, n, n2, 16, 16);
    }

    public static Icon createLineIcon(final Color color, final int n, final int n2, final int n3, final int n4) throws IllegalArgumentException {
        if (color == null || n < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return new Icon(){
            private final Stroke lineStroke;
            {
                this.lineStroke = new BasicStroke(n);
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n7, int n22) {
                int n32;
                int n42;
                int n5;
                int n6;
                Graphics2D graphics2D = (Graphics2D)graphics;
                switch (n2) {
                    case 2: {
                        n5 = n6 = n7 + n3 / 2 + 1;
                        n42 = n22;
                        n32 = n22 + n4;
                        break;
                    }
                    case 3: {
                        n5 = n7;
                        n42 = n22;
                        n6 = n22 + n3;
                        n32 = n22 + n4;
                        break;
                    }
                    case 4: {
                        n5 = n7;
                        n42 = n22 + n4;
                        n6 = n22 + n3;
                        n32 = n22;
                        break;
                    }
                    default: {
                        n5 = n7;
                        n42 = n32 = n22 + n4 / 2 + 1;
                        n6 = n7 + n3;
                    }
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setColor(color);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.lineStroke);
                graphics2D.drawLine(n5, n42, n6, n32);
                graphics2D.setStroke(stroke);
            }

            @Override
            public int getIconWidth() {
                return n3;
            }

            @Override
            public int getIconHeight() {
                return n4;
            }
        };
    }

    public static Icon createRectangleIcon(Color color, Color color2, int n) throws IllegalArgumentException {
        return LegendItem.createRectangleIcon(color, color2, n, 16, 16);
    }

    public static Icon createRectangleIcon(final Color color, final Color color2, final int n, final int n2, final int n3) throws IllegalArgumentException {
        if (color == null || color2 == null || n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        return new Icon(){
            private final Stroke edgeStroke;
            {
                this.edgeStroke = new BasicStroke(n);
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n4, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n32 = (int)((float)n / 2.0f + 0.5f);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setColor(color);
                graphics2D.fillRect(n4 + n32, n22 + n32, n2 - 2 * n32, n3 - 2 * n32);
                graphics2D.setColor(color2);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.edgeStroke);
                graphics2D.drawRect(n4 + n32, n22 + n32, n2 - 2 * n32, n3 - 2 * n32);
                graphics2D.setStroke(stroke);
            }

            @Override
            public int getIconWidth() {
                return n3;
            }

            @Override
            public int getIconHeight() {
                return n2;
            }
        };
    }
}

