/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.LegendItem;
import lavesdk.gui.widgets.LegendItemGroup;

public class Legend
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final Map<String, LegendItem> items = new HashMap<String, LegendItem>();
    private final JPanel panelContainer = new JPanel();
    private final JPanel itemPanel = new JPanel();
    private final JScrollPane scrollPane = new JScrollPane(this.panelContainer);
    private boolean initialized = false;
    private Color groupBackground = Color.white;
    private Color groupForeground = new Color(40, 80, 180);

    public Legend() {
        this.panelContainer.setLayout(null);
        this.itemPanel.setLayout(new BoxLayout(this.itemPanel, 1));
        this.panelContainer.setBackground(Color.white);
        this.itemPanel.setBackground(Color.white);
        this.scrollPane.setBackground(Color.white);
        this.itemPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        super.setFont(UIManager.getFont("Label.font"));
        this.panelContainer.add(this.itemPanel);
        super.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.initialized = true;
        this.panelContainer.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Legend.this.itemPanel.setSize(Legend.this.panelContainer.getWidth(), ((Legend)Legend.this).itemPanel.getPreferredSize().height);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public final LegendItem getItem(final String string) {
        if (EDT.isExecutedInEDT()) {
            return this.items.get(string);
        }
        return EDT.execute(new GuiRequest<LegendItem>(){

            @Override
            protected LegendItem execute() throws Throwable {
                return (LegendItem)Legend.this.items.get(string);
            }
        });
    }

    public void add(final LegendItem legendItem) {
        if (EDT.isExecutedInEDT()) {
            this.addImpl(legendItem, null, -1);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    Legend.this.addImpl(legendItem, null, -1);
                }
            });
        }
    }

    @Override
    public Component add(final Component component) {
        if (EDT.isExecutedInEDT()) {
            return super.add(component);
        }
        return EDT.execute(new GuiRequest<Component>(){

            @Override
            protected Component execute() throws Throwable {
                return Legend.super.add(component);
            }
        });
    }

    public Color getGroupBackground() {
        if (EDT.isExecutedInEDT()) {
            return this.groupBackground;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return Legend.this.groupBackground;
            }
        });
    }

    public void setGroupBackground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.groupBackground = color;
            this.updateGroupColors();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setGroupBackground"){

                @Override
                protected void execute() throws Throwable {
                    Legend.this.groupBackground = color;
                    Legend.this.updateGroupColors();
                }
            });
        }
    }

    public Color getGroupForeground() {
        if (EDT.isExecutedInEDT()) {
            return this.groupForeground;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return Legend.this.groupForeground;
            }
        });
    }

    public void setGroupForeground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.groupForeground = color;
            this.updateGroupColors();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setGroupForeground"){

                @Override
                protected void execute() throws Throwable {
                    Legend.this.groupForeground = color;
                    Legend.this.updateGroupColors();
                }
            });
        }
    }

    @Override
    public Font getFont() {
        if (EDT.isExecutedInEDT()) {
            return super.getFont();
        }
        return EDT.execute(new GuiRequest<Font>(){

            @Override
            protected Font execute() throws Throwable {
                return Legend.super.getFont();
            }
        });
    }

    @Override
    public void setFont(final Font font) {
        if (EDT.isExecutedInEDT()) {
            super.setFont(font);
            for (Component component : this.itemPanel.getComponents()) {
                component.setFont(font);
            }
            this.updateSize();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setFont"){

                @Override
                protected void execute() throws Throwable {
                    Legend.super.setFont(font);
                    for (Component component : Legend.this.itemPanel.getComponents()) {
                        component.setFont(font);
                    }
                    Legend.this.updateSize();
                }
            });
        }
    }

    @Override
    public void removeAll() {
        this.itemPanel.removeAll();
        this.items.clear();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    void toggleGroup(LegendItemGroup legendItemGroup) {
        for (Component component : this.itemPanel.getComponents()) {
            LegendItem legendItem;
            if (!(component instanceof LegendItem) || !(legendItem = (LegendItem)component).getGroupName().equals(legendItemGroup.getGroupName())) continue;
            legendItem.setVisible(legendItemGroup.isExpanded());
        }
        this.updateSize();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        } else if (component instanceof LegendItem) {
            LegendItem legendItem = (LegendItem)component;
            if (this.items.containsKey(legendItem.getItemName())) {
                throw new IllegalArgumentException("legend already contains an item with the name " + legendItem.getItemName());
            }
            this.items.put(legendItem.getItemName(), legendItem);
            int n2 = this.getLastItemIndexOfGroup(legendItem.getGroupName());
            if (legendItem.getGroupName().isEmpty()) {
                this.itemPanel.add(component, n2 >= 0 ? n2 + 1 : 0);
            } else if (n2 >= 0) {
                this.itemPanel.add(component, n2 + 1);
            } else {
                this.itemPanel.add((Component)new LegendItemGroup(this, legendItem.getGroupName()), -1);
                this.itemPanel.add(component, -1);
            }
            legendItem.setFont(this.getFont());
            this.updateSize();
        }
    }

    private void updateSize() {
        Dimension dimension = this.itemPanel.getPreferredSize();
        this.itemPanel.setSize(this.panelContainer.getWidth(), dimension.height);
        this.panelContainer.setPreferredSize(new Dimension(dimension.width, dimension.height));
        this.panelContainer.revalidate();
    }

    private int getLastItemIndexOfGroup(String string) {
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < this.itemPanel.getComponentCount(); ++i) {
            Component component = this.itemPanel.getComponent(i);
            LegendItem legendItem = component instanceof LegendItem ? (LegendItem)component : null;
            if (bl && (legendItem == null || !legendItem.getGroupName().equals(string))) break;
            if (legendItem == null || !legendItem.getGroupName().equals(string)) continue;
            bl = true;
            n = i;
        }
        return n;
    }

    private void updateGroupColors() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof LegendItemGroup)) continue;
            LegendItemGroup legendItemGroup = (LegendItemGroup)component;
            legendItemGroup.setBackground(this.groupBackground);
            legendItemGroup.setForeground(this.groupForeground);
        }
    }
}

