/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import lavesdk.algorithm.plugin.AlgorithmPlugin;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;

public class InformationBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Component parent;
    private boolean initialized;
    private final JPanel assumptionPanel;
    private final JLabel lblAssumption;
    private final JLabel lblAssumptionValue;
    private final JLabel instructionsBtn;
    private final JLabel closeBtn;
    private final String titleInstructions;
    private boolean activatable;
    private String currInstructions;

    public InformationBar(Component component) {
        this(component, null, null);
    }

    public InformationBar(Component component, LanguageFile languageFile, String string) {
        Font font = UIManager.getFont("Label.font");
        this.initialized = false;
        this.parent = component;
        this.activatable = false;
        this.currInstructions = null;
        this.titleInstructions = LanguageFile.getLabel(languageFile, "INFORMATIONBAR_SHOWINSTRUCTIONS_TITLE", string, "Instructions");
        this.assumptionPanel = new JPanel(new BorderLayout(5, 0));
        this.lblAssumption = new JLabel(LanguageFile.getLabel(languageFile, "INFORMATIONBAR_ASSUMPTIONS", string, "Assumption(s):"));
        this.lblAssumptionValue = new JLabel();
        this.instructionsBtn = new JLabel(Resources.getInstance().INSTRUCTIONS_ICON);
        this.closeBtn = new JLabel(Resources.getInstance().CLOSE_ICON);
        this.lblAssumption.setFont(font.deriveFont(1));
        this.closeBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.closeBtn.setToolTipText(LanguageFile.getLabel(languageFile, "INFORMATIONBAR_CLOSE_TOOLTIP", string, "Close Information Bar"));
        this.closeBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InformationBar.this.closeBtn.setIcon(Resources.getInstance().CLOSE_ICON);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InformationBar.this.closeBtn.setIcon(Resources.getInstance().CLOSE_HOVER_ICON);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InformationBar.super.setVisible(false);
            }
        });
        this.instructionsBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.instructionsBtn.setToolTipText(LanguageFile.getLabel(languageFile, "INFORMATIONBAR_SHOWINSTRUCTIONS", string, "Show Instructions"));
        this.instructionsBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InformationBar.this.showInstructions();
            }
        });
        this.assumptionPanel.add((Component)this.lblAssumption, "West");
        this.assumptionPanel.add((Component)this.lblAssumptionValue, "Center");
        super.setLayout(new BorderLayout(10, 0));
        this.add((Component)this.closeBtn, "West");
        this.add((Component)this.assumptionPanel, "Center");
        this.add((Component)this.instructionsBtn, "East");
        super.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setBackground(new Color(240, 230, 200));
        super.setVisible(false);
        this.initialized = true;
    }

    public void update(AlgorithmPlugin algorithmPlugin) {
        boolean bl = algorithmPlugin.getAssumptions() != null && !algorithmPlugin.getAssumptions().isEmpty();
        boolean bl2 = algorithmPlugin.getInstructions() != null && !algorithmPlugin.getInstructions().isEmpty();
        this.activatable = bl || bl2;
        this.currInstructions = bl2 ? algorithmPlugin.getInstructions() : null;
        this.lblAssumption.setVisible(bl);
        this.lblAssumptionValue.setVisible(bl);
        this.lblAssumptionValue.setText("<html>" + (bl ? algorithmPlugin.getAssumptions() : "") + "</html>");
        this.instructionsBtn.setVisible(bl2);
        if (!this.activatable) {
            super.setVisible(false);
        } else {
            super.setVisible(true);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.assumptionPanel != null) {
            this.assumptionPanel.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.lblAssumption != null) {
            this.lblAssumption.setForeground(color);
        }
        if (this.lblAssumptionValue != null) {
            this.lblAssumptionValue.setForeground(color);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.activatable) {
            super.setVisible(bl);
        }
    }

    public boolean isActivatable() {
        return this.activatable;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        }
    }

    private void showInstructions() {
        JLabel jLabel = new JLabel("<html>" + this.currInstructions + "</html>");
        JOptionPane.showMessageDialog(this.parent, jLabel, this.titleInstructions, 1);
    }
}

