/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.Color;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.ExecutionTable;
import lavesdk.gui.widgets.ExecutionTableBorder;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.utils.MathUtils;

public class ExecutionTableItem {
    private final int id;
    private ExecutionTable table;
    private ExecutionTable.ExecutionTableModel model;
    private Color background;
    private Color foreground;
    private final Map<String, List<ParameterCache>> parameterDataCache;
    private ExecutionTableBorder border;
    private final int unsortedOrderIndex;
    private int index;
    private boolean editable;
    private InputParser<?> defInputParser;
    private boolean visible;
    private Object userData;
    private final List<Object> cellObjects;
    private final List<Color> cellBackgrounds;
    private final List<Color> cellForegrounds;
    private final List<Border> cellBorders;
    private final List<InputParser<?>> cellInputParsers;
    private static final Color DEF_BACKGROUND = Color.white;
    private static final Color DEF_FOREGROUND = Color.black;
    private static final String MK_SETCELLOBJECTBYID = "setCellObjectByID";
    private static final String MK_SETCELLDATABYID = "setCellDataByID";
    private static final String MK_SETCELLBACKGROUNDBYID = "setCellBackgroundByID";
    private static final String MK_SETCELLFOREGROUNDBYID = "setCellForegroundByID";
    private static final String MK_SETCELLBORDERBYID = "setCellBorderByID";
    private static int nextUnsortedOrderIndex = 1;

    public ExecutionTableItem() {
        this(null);
    }

    public ExecutionTableItem(int n) {
        this(null, n);
    }

    public ExecutionTableItem(Object[] objectArray) {
        this(objectArray, -1);
    }

    public ExecutionTableItem(Object[] objectArray, int n) {
        this.id = n;
        this.table = null;
        this.model = null;
        this.background = DEF_BACKGROUND;
        this.foreground = DEF_FOREGROUND;
        this.parameterDataCache = new HashMap<String, List<ParameterCache>>(3);
        this.cellObjects = new ArrayList<Object>();
        this.cellBackgrounds = new ArrayList<Color>();
        this.cellForegrounds = new ArrayList<Color>();
        this.cellBorders = new ArrayList<Border>();
        this.border = null;
        this.unsortedOrderIndex = nextUnsortedOrderIndex++;
        this.index = -1;
        this.editable = false;
        this.defInputParser = null;
        this.cellInputParsers = new ArrayList();
        this.visible = true;
        this.userData = null;
        if (objectArray != null) {
            for (Object object : objectArray) {
                this.cellObjects.add(object);
            }
        }
    }

    public ExecutionTableItem(Map<Integer, ? extends Object> map, boolean bl) {
        this(map, bl, -1);
    }

    public ExecutionTableItem(Map<Integer, ? extends Object> map, boolean bl, int n) {
        this.id = n;
        this.table = null;
        this.model = null;
        this.background = DEF_BACKGROUND;
        this.foreground = DEF_FOREGROUND;
        this.parameterDataCache = new HashMap<String, List<ParameterCache>>(3);
        this.cellObjects = new ArrayList<Object>();
        this.cellBackgrounds = new ArrayList<Color>();
        this.cellForegrounds = new ArrayList<Color>();
        this.cellBorders = new ArrayList<Border>();
        this.border = null;
        this.unsortedOrderIndex = nextUnsortedOrderIndex++;
        this.index = -1;
        this.editable = false;
        this.defInputParser = null;
        this.cellInputParsers = new ArrayList();
        this.visible = true;
        this.userData = null;
        if (map != null) {
            if (bl) {
                this.setCellDataByID(map);
            } else {
                this.setCellData(map);
            }
        }
    }

    public final int getID() {
        return this.id;
    }

    public Color getBackground() {
        if (EDT.isExecutedInEDT()) {
            return this.background;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return ExecutionTableItem.this.background;
            }
        });
    }

    public void setBackground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.background = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setBackground"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.background = color;
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public Color getForeground() {
        if (EDT.isExecutedInEDT()) {
            return this.foreground;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return ExecutionTableItem.this.foreground;
            }
        });
    }

    public void setForeground(final Color color) throws IllegalArgumentException {
        if (color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.foreground = color;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setForeground"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.foreground = color;
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public Object getCellObject(final int n) {
        if (this.table != null) {
            this.table.closeEditors();
        }
        if (EDT.isExecutedInEDT()) {
            return this.getListEntry(this.cellObjects, n);
        }
        return EDT.execute(new GuiRequest<Object>(){

            @Override
            protected Object execute() throws Throwable {
                return ExecutionTableItem.this.getListEntry(ExecutionTableItem.this.cellObjects, n);
            }
        });
    }

    public <T> void setCellObject(final int n, final T t) {
        if (EDT.isExecutedInEDT()) {
            this.setListEntry(this.cellObjects, n, t);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellObject"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.setListEntry(ExecutionTableItem.this.cellObjects, n, t);
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public <T> void setCellObjectByID(final int n, final T t) {
        EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellObjectByID"){

            @Override
            protected void execute() throws Throwable {
                if (ExecutionTableItem.this.table == null) {
                    ParameterCache parameterCache = new ParameterCache();
                    parameterCache.set("colID", n);
                    parameterCache.set("object", t);
                    ExecutionTableItem.this.updateDataCache(ExecutionTableItem.MK_SETCELLOBJECTBYID, parameterCache);
                } else {
                    ExecutionTableColumn executionTableColumn = ExecutionTableItem.this.table.getColumnByID(n);
                    if (executionTableColumn != null) {
                        ExecutionTableItem.this.setCellObject(executionTableColumn.getIndex(), t);
                    }
                }
            }
        });
    }

    public <T> void setCellData(final Map<Integer, T> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellData"){

            @Override
            protected void execute() throws Throwable {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    ExecutionTableItem.this.setCellObject(n, map.get(n));
                }
            }
        });
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public <T> void setCellDataByID(final Map<Integer, T> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellDataByID"){

            @Override
            protected void execute() throws Throwable {
                if (ExecutionTableItem.this.table == null) {
                    ParameterCache parameterCache = new ParameterCache();
                    parameterCache.set("data", map);
                    ExecutionTableItem.this.updateDataCache(ExecutionTableItem.MK_SETCELLDATABYID, parameterCache);
                } else {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        ExecutionTableItem.this.setCellObjectByID(n, map.get(n));
                    }
                }
            }
        });
    }

    public Color getCellBackground(final int n) {
        if (EDT.isExecutedInEDT()) {
            Color color = this.getListEntry(this.cellBackgrounds, n);
            return color != null ? color : this.background;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                Color color = (Color)ExecutionTableItem.this.getListEntry(ExecutionTableItem.this.cellBackgrounds, n);
                return color != null ? color : ExecutionTableItem.this.background;
            }
        });
    }

    public void setCellBackground(final int n, final Color color) {
        if (EDT.isExecutedInEDT()) {
            this.setListEntry(this.cellBackgrounds, n, color);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellBackground"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.setListEntry(ExecutionTableItem.this.cellBackgrounds, n, color);
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public void setCellBackgroundByID(final int n, final Color color) {
        EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellBackgroundByID"){

            @Override
            protected void execute() throws Throwable {
                if (ExecutionTableItem.this.table == null) {
                    ParameterCache parameterCache = new ParameterCache();
                    parameterCache.set("colID", n);
                    parameterCache.set("color", color);
                    ExecutionTableItem.this.updateDataCache(ExecutionTableItem.MK_SETCELLBACKGROUNDBYID, parameterCache);
                } else {
                    ExecutionTableColumn executionTableColumn = ExecutionTableItem.this.table.getColumnByID(n);
                    if (executionTableColumn != null) {
                        ExecutionTableItem.this.setCellBackground(executionTableColumn.getIndex(), color);
                    }
                }
            }
        });
    }

    public Color getCellForeground(final int n) {
        if (EDT.isExecutedInEDT()) {
            Color color = this.getListEntry(this.cellForegrounds, n);
            return color != null ? color : this.foreground;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                Color color = (Color)ExecutionTableItem.this.getListEntry(ExecutionTableItem.this.cellForegrounds, n);
                return color != null ? color : ExecutionTableItem.this.foreground;
            }
        });
    }

    public void setCellForeground(final int n, final Color color) {
        if (EDT.isExecutedInEDT()) {
            this.setListEntry(this.cellForegrounds, n, color);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellForeground"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.setListEntry(ExecutionTableItem.this.cellForegrounds, n, color);
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public void setCellForegroundByID(final int n, final Color color) {
        EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellForegroundByID"){

            @Override
            protected void execute() throws Throwable {
                if (ExecutionTableItem.this.table == null) {
                    ParameterCache parameterCache = new ParameterCache();
                    parameterCache.set("colID", n);
                    parameterCache.set("color", color);
                    ExecutionTableItem.this.updateDataCache(ExecutionTableItem.MK_SETCELLFOREGROUNDBYID, parameterCache);
                } else {
                    ExecutionTableColumn executionTableColumn = ExecutionTableItem.this.table.getColumnByID(n);
                    if (executionTableColumn != null) {
                        ExecutionTableItem.this.setCellForeground(executionTableColumn.getIndex(), color);
                    }
                }
            }
        });
    }

    public Border getCellBorder(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.getListEntry(this.cellBorders, n);
        }
        return EDT.execute(new GuiRequest<Border>(){

            @Override
            protected Border execute() throws Throwable {
                return (Border)ExecutionTableItem.this.getListEntry(ExecutionTableItem.this.cellBorders, n);
            }
        });
    }

    public void setCellBorder(final int n, final Border border) {
        if (EDT.isExecutedInEDT()) {
            this.setListEntry(this.cellBorders, n, border);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellBorder"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.setListEntry(ExecutionTableItem.this.cellBorders, n, border);
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public void setCellBorder(int n, Color color) throws IllegalArgumentException {
        this.setCellBorder(n, color, 1);
    }

    public void setCellBorder(int n, Color color, int n2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setCellBorder(n, color != null ? BorderFactory.createMatteBorder(n2, n2, n2, n2, color) : null);
    }

    public void setCellBorderByID(final int n, final Border border) {
        EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellBorderByID"){

            @Override
            protected void execute() throws Throwable {
                if (ExecutionTableItem.this.table == null) {
                    ParameterCache parameterCache = new ParameterCache();
                    parameterCache.set("colID", n);
                    parameterCache.set("border", border);
                    ExecutionTableItem.this.updateDataCache(ExecutionTableItem.MK_SETCELLBORDERBYID, parameterCache);
                } else {
                    ExecutionTableColumn executionTableColumn = ExecutionTableItem.this.table.getColumnByID(n);
                    if (executionTableColumn != null) {
                        ExecutionTableItem.this.setCellBorder(executionTableColumn.getIndex(), border);
                    }
                }
            }
        });
    }

    public void setCellBorderByID(int n, Color color) {
        this.setCellBorderByID(n, color, 1);
    }

    public void setCellBorderByID(int n, Color color, int n2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.setCellBorderByID(n, color != null ? BorderFactory.createMatteBorder(n2, n2, n2, n2, color) : null);
    }

    public ExecutionTableBorder getBorder() {
        if (EDT.isExecutedInEDT()) {
            return this.border;
        }
        return EDT.execute(new GuiRequest<ExecutionTableBorder>(){

            @Override
            protected ExecutionTableBorder execute() throws Throwable {
                return ExecutionTableItem.this.border;
            }
        });
    }

    public void setBorder(final ExecutionTableBorder executionTableBorder) {
        if (EDT.isExecutedInEDT()) {
            this.border = executionTableBorder;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setBorder"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.border = executionTableBorder;
                }
            });
        }
        if (this.table != null && this.visible) {
            this.table.autoRepaint();
        }
    }

    public final int getIndex() {
        if (EDT.isExecutedInEDT()) {
            return this.index;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTableItem.this.index;
            }
        });
    }

    public boolean isEditable() {
        if (EDT.isExecutedInEDT()) {
            return this.editable;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return ExecutionTableItem.this.editable;
            }
        });
    }

    public void setEditable(final boolean bl) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.editable = bl;
            if (this.table != null) {
                this.table.closeEditors();
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEditable"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.editable = bl;
                    if (ExecutionTableItem.this.table != null) {
                        ExecutionTableItem.this.table.closeEditors();
                    }
                }
            });
        }
    }

    public void setDefaultInputParser(final InputParser<?> inputParser) {
        if (EDT.isExecutedInEDT()) {
            this.defInputParser = inputParser;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setDefaultInputParser"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.defInputParser = inputParser;
                }
            });
        }
    }

    public void setCellInputParser(final int n, final InputParser<?> inputParser) {
        if (EDT.isExecutedInEDT()) {
            this.setListEntry(this.cellInputParsers, n, inputParser);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setCellInputParser"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.setListEntry(ExecutionTableItem.this.cellInputParsers, n, inputParser);
                }
            });
        }
    }

    public InputParser<?> getCellInputParser(final int n) {
        if (EDT.isExecutedInEDT()) {
            InputParser<?> inputParser = this.getListEntry(this.cellInputParsers, n);
            return inputParser != null ? inputParser : this.defInputParser;
        }
        return (InputParser)EDT.execute(new GuiRequest<InputParser<?>>(){

            @Override
            protected InputParser<?> execute() throws Throwable {
                InputParser inputParser = (InputParser)ExecutionTableItem.this.getListEntry(ExecutionTableItem.this.cellInputParsers, n);
                return inputParser != null ? inputParser : ExecutionTableItem.this.defInputParser;
            }
        });
    }

    public boolean isVisible() {
        if (EDT.isExecutedInEDT()) {
            return this.visible;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return ExecutionTableItem.this.visible;
            }
        });
    }

    public void setVisible(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.internalSetVisible(bl);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setVisible"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableItem.this.internalSetVisible(bl);
                }
            });
        }
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    final void setIndex(int n) {
        this.index = n;
    }

    final int getUnsortedOrderIndex() {
        return this.unsortedOrderIndex;
    }

    ExecutionTable getTable() {
        return this.table;
    }

    ExecutionTable.ExecutionTableModel getModel() {
        return this.model;
    }

    void setTableAndModel(ExecutionTable executionTable, ExecutionTable.ExecutionTableModel executionTableModel) {
        this.table = executionTable;
        this.model = executionTableModel;
        if (executionTable != null) {
            for (String string : this.parameterDataCache.keySet()) {
                this.invokeMethod(string, this.parameterDataCache.get(string));
            }
            this.parameterDataCache.clear();
        }
    }

    final void removeCell(int n) {
        this.removeCell(this.cellBackgrounds, n);
        this.removeCell(this.cellBorders, n);
        this.removeCell(this.cellForegrounds, n);
        this.removeCell(this.cellInputParsers, n);
        this.removeCell(this.cellObjects, n);
    }

    private <T> void removeCell(List<T> list, int n) {
        if (n >= 0 && n < list.size()) {
            list.remove(n);
        }
    }

    private <T> T getListEntry(List<T> list, int n) {
        if (n < 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    private <T> void setListEntry(List<T> list, int n, T t) {
        if (n < 0) {
            return;
        }
        for (int i = list.size(); i <= n; ++i) {
            list.add(null);
        }
        list.set(n, t);
    }

    private void updateDataCache(String string, ParameterCache parameterCache) throws IllegalArgumentException {
        if (string == null || parameterCache == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        List<ParameterCache> list = this.parameterDataCache.get(string);
        if (list == null) {
            list = new ArrayList<ParameterCache>(3);
            this.parameterDataCache.put(string, list);
        }
        list.add(parameterCache);
    }

    private void invokeMethod(String string, List<ParameterCache> list) {
        if (list == null) {
            return;
        }
        for (ParameterCache parameterCache : list) {
            switch (string) {
                case "setCellObjectByID": {
                    this.setCellObjectByID((Integer)parameterCache.get("colID"), parameterCache.get("object"));
                    break;
                }
                case "setCellDataByID": {
                    this.setCellDataByID((Map)parameterCache.get("data"));
                    break;
                }
                case "setCellBackgroundByID": {
                    this.setCellBackgroundByID((Integer)parameterCache.get("colID"), (Color)parameterCache.get("color"));
                    break;
                }
                case "setCellForegroundByID": {
                    this.setCellForegroundByID((Integer)parameterCache.get("colID"), (Color)parameterCache.get("color"));
                    break;
                }
                case "setCellBorderByID": {
                    this.setCellBorderByID((int)((Integer)parameterCache.get("colID")), (Border)parameterCache.get("border"));
                }
            }
        }
    }

    private void internalSetVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        if (this.model != null) {
            this.model.updateVisibility(this);
        }
    }

    public static class NumericInputParser
    implements InputParser<Number> {
        private final String infinityChar;
        private final Number infinityValue;

        public NumericInputParser() throws IllegalArgumentException {
            this("-", Float.valueOf(Float.POSITIVE_INFINITY));
        }

        public NumericInputParser(Number number) throws IllegalArgumentException {
            this("-", number);
        }

        public NumericInputParser(String string, Number number) throws IllegalArgumentException {
            if (string == null || string.isEmpty() || number == null) {
                throw new IllegalArgumentException("No valid argument!");
            }
            this.infinityChar = string;
            this.infinityValue = number;
        }

        @Override
        public Object prepareEditor(Object object) {
            if (object != null && object.equals(this.infinityValue)) {
                return this.infinityChar;
            }
            if (object != null && object instanceof Number) {
                return MathUtils.formatFloat(((Number)object).floatValue());
            }
            return object;
        }

        @Override
        public Number parse(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals(this.infinityChar)) {
                return this.infinityValue;
            }
            try {
                return NumberFormat.getInstance().parse(string);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public static class StringInputParser
    implements InputParser<String> {
        @Override
        public Object prepareEditor(Object object) {
            return object;
        }

        @Override
        public String parse(String string) {
            return string;
        }
    }

    public static interface InputParser<T> {
        public Object prepareEditor(Object var1);

        public T parse(String var1);
    }

    private class ParameterCache {
        private final Map<String, Object> data = new HashMap<String, Object>(2);

        public Object get(String string) {
            return this.data.get(string);
        }

        public void set(String string, Object object) {
            this.data.put(string, object);
        }
    }
}

