/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.ExecutionTable;
import lavesdk.gui.widgets.Mask;

public class ExecutionTableColumn {
    private ExecutionTable table;
    private String name;
    private final int id;
    private int index;
    private int alignment;
    private final List<Mask> masks;
    private boolean editable;
    private int userWidth;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 0;

    public ExecutionTableColumn(String string) throws IllegalArgumentException {
        this(string, -1);
    }

    public ExecutionTableColumn(String string, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.table = null;
        this.name = string;
        this.id = n;
        this.index = -1;
        this.alignment = 0;
        this.masks = new ArrayList<Mask>(3);
        this.editable = false;
        this.userWidth = -1;
    }

    public final String getName() {
        return this.name;
    }

    public final int getID() {
        return this.id;
    }

    public final int getIndex() {
        return this.index;
    }

    public int getAlignment() {
        if (EDT.isExecutedInEDT()) {
            return this.alignment;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTableColumn.this.alignment;
            }
        });
    }

    public void setAlignment(final int n) throws IllegalArgumentException {
        if (n != 2 && n != 0 && n != 4) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.alignment = n;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setAlignment"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableColumn.this.alignment = n;
                }
            });
        }
    }

    public int getMaskCount() {
        if (EDT.isExecutedInEDT()) {
            return this.masks.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTableColumn.this.masks.size();
            }
        });
    }

    public Mask getMask(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.masks.get(n);
        }
        return EDT.execute(new GuiRequest<Mask>(){

            @Override
            protected Mask execute() throws Throwable {
                return (Mask)ExecutionTableColumn.this.masks.get(n);
            }
        });
    }

    public void addMask(final Mask mask) {
        if (mask == null || this.masks.contains(mask)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.masks.add(mask);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addMask"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableColumn.this.masks.add(mask);
                }
            });
        }
    }

    public void removeMask(final Mask mask) {
        if (mask == null || !this.masks.contains(mask)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.masks.remove(mask);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeMask"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableColumn.this.masks.remove(mask);
                }
            });
        }
    }

    public boolean isEditable() {
        if (EDT.isExecutedInEDT()) {
            return this.editable;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return ExecutionTableColumn.this.editable;
            }
        });
    }

    public void setEditable(final boolean bl) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.editable = bl;
            if (this.table != null) {
                this.table.closeEditors();
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setEditable"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableColumn.this.editable = bl;
                    if (ExecutionTableColumn.this.table != null) {
                        ExecutionTableColumn.this.table.closeEditors();
                    }
                }
            });
        }
    }

    public int getWidth() {
        if (EDT.isExecutedInEDT()) {
            return this.userWidth;
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTableColumn.this.userWidth;
            }
        });
    }

    public void setWidth(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.userWidth = n;
            if (this.table != null) {
                this.table.setColumnWidth(this.index, this.userWidth);
            }
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setWidth"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTableColumn.this.userWidth = n;
                    if (ExecutionTableColumn.this.table != null) {
                        ExecutionTableColumn.this.table.setColumnWidth(ExecutionTableColumn.this.index, ExecutionTableColumn.this.userWidth);
                    }
                }
            });
        }
    }

    public String toString() {
        return ExecutionTableColumn.class.getSimpleName() + "[" + this.name + "]";
    }

    final ExecutionTable getTable() {
        return this.table;
    }

    final void setTable(ExecutionTable executionTable) {
        this.table = executionTable;
        if (executionTable != null && this.index >= 0 && this.userWidth >= 0) {
            executionTable.setColumnWidth(this.index, this.userWidth);
        }
    }

    final void setIndex(int n) {
        this.index = n;
        if (this.table != null && n >= 0 && this.userWidth >= 0) {
            this.table.setColumnWidth(n, this.userWidth);
        }
    }

    final Mask getMask(Object object) {
        for (Mask mask : this.masks) {
            if (!mask.matches(object)) continue;
            return mask;
        }
        return null;
    }
}

