/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class ExecutionTableBorder {
    private final int width;
    private final Color color;
    private final Stroke stroke;
    private static final Map<String, Border> borders = new HashMap<String, Border>();

    public ExecutionTableBorder(int n, Color color) throws IllegalArgumentException {
        if (n < 0 || color == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        this.width = n;
        this.color = color;
        this.stroke = new BasicStroke(n);
    }

    public final int getWidth() {
        return this.width;
    }

    public final Color getColor() {
        return this.color;
    }

    public String toString() {
        return ExecutionTableBorder.class.getSimpleName() + "[" + this.width + "," + this.color + "]";
    }

    public static Border createBorder(final ExecutionTableBorder executionTableBorder, final ExecutionTableBorder executionTableBorder2, final ExecutionTableBorder executionTableBorder3, final ExecutionTableBorder executionTableBorder4) {
        String string = ExecutionTableBorder.createBorderKey(executionTableBorder, executionTableBorder2, executionTableBorder3, executionTableBorder4);
        Border border = borders.get(string);
        if (border == null) {
            final Insets insets = new Insets(executionTableBorder3 != null ? executionTableBorder3.width : 0, executionTableBorder != null ? executionTableBorder.width : 0, executionTableBorder4 != null ? executionTableBorder4.width : 0, executionTableBorder2 != null ? executionTableBorder2.width : 0);
            border = new AbstractBorder(){
                private static final long serialVersionUID = 1L;

                @Override
                public Insets getBorderInsets(Component component) {
                    return insets;
                }

                @Override
                public Insets getBorderInsets(Component component, Insets insets2) {
                    return insets2;
                }

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    int n5;
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Stroke stroke = graphics2D.getStroke();
                    if (executionTableBorder != null) {
                        n5 = n + executionTableBorder.width / 2;
                        graphics2D.setColor(executionTableBorder.color);
                        graphics2D.setStroke(executionTableBorder.stroke);
                        graphics2D.drawLine(n5, n2, n5, n2 + n4);
                    }
                    if (executionTableBorder2 != null) {
                        n5 = n + n3 - (int)((float)executionTableBorder2.width / 2.0f + 0.5f);
                        graphics2D.setColor(executionTableBorder2.color);
                        graphics2D.setStroke(executionTableBorder2.stroke);
                        graphics2D.drawLine(n5, n2, n5, n2 + n4);
                    }
                    if (executionTableBorder3 != null) {
                        n5 = n2 + executionTableBorder3.width / 2;
                        graphics2D.setColor(executionTableBorder3.color);
                        graphics2D.setStroke(executionTableBorder3.stroke);
                        graphics2D.drawLine(n, n5, n + n3, n5);
                    }
                    if (executionTableBorder4 != null) {
                        n5 = n2 + n4 - (int)((float)executionTableBorder4.width / 2.0f + 0.5f);
                        graphics2D.setColor(executionTableBorder4.color);
                        graphics2D.setStroke(executionTableBorder4.stroke);
                        graphics2D.drawLine(n, n5, n + n3, n5);
                    }
                    graphics2D.setStroke(stroke);
                }
            };
            borders.put(string, border);
        }
        return border;
    }

    private static String createBorderKey(ExecutionTableBorder executionTableBorder, ExecutionTableBorder executionTableBorder2, ExecutionTableBorder executionTableBorder3, ExecutionTableBorder executionTableBorder4) {
        StringBuilder stringBuilder = new StringBuilder(75);
        ExecutionTableBorder.appendBorderKey(stringBuilder, executionTableBorder);
        ExecutionTableBorder.appendBorderKey(stringBuilder, executionTableBorder2);
        ExecutionTableBorder.appendBorderKey(stringBuilder, executionTableBorder3);
        ExecutionTableBorder.appendBorderKey(stringBuilder, executionTableBorder4);
        return stringBuilder.toString();
    }

    private static void appendBorderKey(StringBuilder stringBuilder, ExecutionTableBorder executionTableBorder) {
        if (executionTableBorder != null) {
            stringBuilder.append(executionTableBorder.width);
        }
        stringBuilder.append(',');
        if (executionTableBorder != null) {
            stringBuilder.append(executionTableBorder.color);
        }
        stringBuilder.append(';');
    }
}

