/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import lavesdk.gui.EDT;
import lavesdk.gui.GuiJob;
import lavesdk.gui.GuiRequest;
import lavesdk.gui.widgets.BaseComponent;
import lavesdk.gui.widgets.ExecutionTableBorder;
import lavesdk.gui.widgets.ExecutionTableColumn;
import lavesdk.gui.widgets.ExecutionTableGroup;
import lavesdk.gui.widgets.ExecutionTableItem;
import lavesdk.gui.widgets.Mask;
import lavesdk.gui.widgets.NumericCellRenderer;
import lavesdk.gui.widgets.enums.SelectionType;
import lavesdk.language.LanguageFile;
import lavesdk.resources.Resources;

public class ExecutionTable
extends BaseComponent {
    private static final long serialVersionUID = 1L;
    private final JScrollPane scrollPane;
    private final JTable table;
    private final ExecutionTableModel model = new ExecutionTableModel();
    private final List<ExecutionTableGroup> columnGroups;
    private final List<ExecutionTableGroup> itemGroups;
    private ExecutionTableBorder gridBorder;
    private final Color defGridColor;
    private boolean initialized = false;
    private final List<Class<?>> cellRendererClasses;
    private final List<TableCellRenderer> cellRenderers;
    private final TableCellRenderer defCellRenderer;
    private boolean autoScrollEnabled = true;
    private boolean autoRepaint = false;
    private SelectionType selType;
    private int columnHeaderHeight = -1;
    private final String toolTipSortUp;
    private final String toolTipSortDown;
    private boolean closingEditors = false;
    private static final Comparator<ExecutionTableItem> unsortedOrderComparator = new Comparator<ExecutionTableItem>(){

        @Override
        public int compare(ExecutionTableItem executionTableItem, ExecutionTableItem executionTableItem2) {
            return executionTableItem.getUnsortedOrderIndex() - executionTableItem2.getUnsortedOrderIndex();
        }
    };
    private static final Border cellPaddingBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Icon sortUpIcon = Resources.getInstance().SORT_UP_ICON;
    private static final Icon sortDownIcon;
    private static final int sortUpIconWidth;
    private static final int sortDownIconWidth;
    private static final int DEF_ITEMHEIGHT = 20;

    public ExecutionTable() {
        this(null, "");
    }

    public ExecutionTable(LanguageFile languageFile, String string) {
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                return ExecutionTable.this.prepareRenderer(tableCellRenderer, n, n2);
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                return ExecutionTable.this.prepareEditor(tableCellEditor, n, n2);
            }

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject instanceof MouseEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    } else {
                        ((JTextComponent)component).selectAll();
                    }
                }
                return bl;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return ExecutionTable.this.getCellRenderer(n, n2);
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        if (ExecutionTable.this.columnHeaderHeight > 0) {
                            dimension.height = ExecutionTable.this.columnHeaderHeight;
                        }
                        return dimension;
                    }

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        String string;
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        String string2 = string = n >= 0 ? ExecutionTable.this.model.getColumnName(n) : "";
                        if (string.isEmpty()) {
                            return null;
                        }
                        return "<html>" + string + "</html>";
                    }
                };
            }
        };
        this.scrollPane = new JScrollPane(this.table);
        this.columnGroups = new ArrayList<ExecutionTableGroup>(3);
        this.itemGroups = new ArrayList<ExecutionTableGroup>(3);
        this.gridBorder = new ExecutionTableBorder(1, this.table.getGridColor());
        this.defGridColor = this.table.getGridColor();
        this.cellRendererClasses = new ArrayList();
        this.cellRenderers = new ArrayList<TableCellRenderer>();
        this.defCellRenderer = new DefaultTableCellRenderer();
        this.selType = SelectionType.NONE;
        this.toolTipSortUp = LanguageFile.getLabel(languageFile, "EXECUTIONTABLE_SORTUP_BTN_TOOLTIP", string, "Up");
        this.toolTipSortDown = LanguageFile.getLabel(languageFile, "EXECUTIONTABLE_SORTDOWN_BTN_TOOLTIP", string, "Down");
        super.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoCreateRowSorter(false);
        this.table.setRowHeight(20);
        final DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer();
        this.table.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setText("<html>" + jLabel.getText() + "</html>");
                return jLabel;
            }
        });
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.getSelectionModel().setSelectionMode(0);
        this.addDefaultCellRenderer(Number.class, new NumericCellRenderer());
        this.addDefaultCellRenderer(Boolean.class, this.table.getDefaultRenderer(Boolean.class));
        this.addDefaultCellRenderer(Icon.class, this.table.getDefaultRenderer(Icon.class));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ExecutionTable.this.mouseReleased(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ExecutionTable.this.mouseExited(mouseEvent);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ExecutionTable.this.mouseMoved(mouseEvent);
            }
        });
        this.initialized = true;
    }

    public boolean getAutoRepaint() {
        return this.autoRepaint;
    }

    public void setAutoRepaint(boolean bl) {
        this.autoRepaint = bl;
    }

    public void addDefaultCellRenderer(final Class<?> clazz, final TableCellRenderer tableCellRenderer) throws IllegalArgumentException {
        if (clazz == null || tableCellRenderer == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.internalAddDefaultCellRenderer(clazz, tableCellRenderer);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addDefaultCellRenderer"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.internalAddDefaultCellRenderer(clazz, tableCellRenderer);
                }
            });
        }
    }

    public ExecutionTableBorder getGridBorder() {
        if (EDT.isExecutedInEDT()) {
            return this.gridBorder;
        }
        return EDT.execute(new GuiRequest<ExecutionTableBorder>(){

            @Override
            protected ExecutionTableBorder execute() throws Throwable {
                return ExecutionTable.this.gridBorder;
            }
        });
    }

    public void setGridBorder(final ExecutionTableBorder executionTableBorder) {
        if (EDT.isExecutedInEDT()) {
            this.gridBorder = executionTableBorder;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setGridBorder"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.gridBorder = executionTableBorder;
                }
            });
        }
        this.autoRepaint();
    }

    public Color getDefaultGridColor() {
        if (EDT.isExecutedInEDT()) {
            return this.defGridColor;
        }
        return EDT.execute(new GuiRequest<Color>(){

            @Override
            protected Color execute() throws Throwable {
                return ExecutionTable.this.defGridColor;
            }
        });
    }

    public int getItemHeight() {
        if (EDT.isExecutedInEDT()) {
            return this.table.getRowHeight();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.table.getRowHeight();
            }
        });
    }

    public void setItemHeight(final int n) {
        if (EDT.isExecutedInEDT()) {
            this.table.setRowHeight(n);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setItemHeight"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.table.setRowHeight(n);
                }
            });
        }
    }

    public void setColumnHeaderHeight(final int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.columnHeaderHeight = n;
            this.scrollPane.revalidate();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setColumnHeaderHeight"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.columnHeaderHeight = n;
                    ExecutionTable.this.scrollPane.revalidate();
                }
            });
        }
    }

    public boolean getAutoResizeColumns() {
        if (EDT.isExecutedInEDT()) {
            return this.table.getAutoResizeMode() == 2;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return ExecutionTable.this.table.getAutoResizeMode() == 2;
            }
        });
    }

    public void setAutoResizeColumns(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.table.setAutoResizeMode(bl ? 2 : 0);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setAutoResizeColumns"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.table.setAutoResizeMode(bl ? 2 : 0);
                }
            });
        }
    }

    public boolean isSortable() {
        if (EDT.isExecutedInEDT()) {
            return this.model.isSortable();
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return ExecutionTable.this.model.isSortable();
            }
        });
    }

    public void setSortable(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.model.setSortable(bl);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setSortable"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.setSortable(bl);
                }
            });
        }
    }

    public boolean isAutoScrollEnabled() {
        if (EDT.isExecutedInEDT()) {
            return this.autoScrollEnabled;
        }
        return EDT.execute(new GuiRequest<Boolean>(){

            @Override
            protected Boolean execute() throws Throwable {
                return ExecutionTable.this.autoScrollEnabled;
            }
        });
    }

    public void setAutoScrollEnabled(final boolean bl) {
        if (EDT.isExecutedInEDT()) {
            this.autoScrollEnabled = bl;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setAutoScrollEnabled"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.autoScrollEnabled = bl;
                }
            });
        }
    }

    public SelectionType getSelectionType() {
        if (EDT.isExecutedInEDT()) {
            return this.selType;
        }
        return EDT.execute(new GuiRequest<SelectionType>(){

            @Override
            protected SelectionType execute() throws Throwable {
                return ExecutionTable.this.selType;
            }
        });
    }

    public void setSelectionType(final SelectionType selectionType) throws IllegalArgumentException {
        if (selectionType == null) {
            throw new IllegalArgumentException("No valid argument!");
        }
        if (EDT.isExecutedInEDT()) {
            this.table.setCellSelectionEnabled(selectionType == SelectionType.CELL);
            this.table.setRowSelectionAllowed(selectionType == SelectionType.ROW || selectionType == SelectionType.ROWS);
            this.table.getSelectionModel().setSelectionMode(selectionType == SelectionType.ROWS ? 2 : 0);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".setSelectionType"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.table.setCellSelectionEnabled(selectionType == SelectionType.CELL);
                    ExecutionTable.this.table.setRowSelectionAllowed(selectionType == SelectionType.ROW || selectionType == SelectionType.ROWS);
                    ExecutionTable.this.table.getSelectionModel().setSelectionMode(selectionType == SelectionType.ROWS ? 2 : 0);
                }
            });
        }
        this.clearSelection();
    }

    public ExecutionTableColumn getSelectedColumn() {
        if (EDT.isExecutedInEDT()) {
            return this.table.getSelectedColumn() >= 0 ? this.getColumn(this.table.convertColumnIndexToModel(this.table.getSelectedColumn())) : null;
        }
        return EDT.execute(new GuiRequest<ExecutionTableColumn>(){

            @Override
            protected ExecutionTableColumn execute() throws Throwable {
                return ExecutionTable.this.table.getSelectedColumn() >= 0 ? ExecutionTable.this.getColumn(ExecutionTable.this.table.convertColumnIndexToModel(ExecutionTable.this.table.getSelectedColumn())) : null;
            }
        });
    }

    public ExecutionTableItem getSelectedItem() {
        if (EDT.isExecutedInEDT()) {
            return this.table.getSelectedRow() >= 0 ? this.getItem(this.table.convertRowIndexToModel(this.table.getSelectedRow())) : null;
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.table.getSelectedRow() >= 0 ? ExecutionTable.this.getItem(ExecutionTable.this.table.convertRowIndexToModel(ExecutionTable.this.table.getSelectedRow())) : null;
            }
        });
    }

    public int getSelectedItemCount() {
        if (EDT.isExecutedInEDT()) {
            return this.table.getSelectedRowCount();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.table.getSelectedRowCount();
            }
        });
    }

    public ExecutionTableItem getSelectedItem(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.getItem(this.table.convertRowIndexToModel(this.table.getSelectedRows()[n]));
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.getItem(ExecutionTable.this.table.convertRowIndexToModel(ExecutionTable.this.table.getSelectedRows()[n]));
            }
        });
    }

    public void clearSelection() {
        if (EDT.isExecutedInEDT()) {
            this.table.clearSelection();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".clearSelection"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.table.clearSelection();
                }
            });
        }
    }

    public void add(final ExecutionTableColumn executionTableColumn) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.model.add(executionTableColumn);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.add(executionTableColumn);
                }
            });
        }
    }

    public void add(final ExecutionTableColumn[] executionTableColumnArray) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.model.add(executionTableColumnArray);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.add(executionTableColumnArray);
                }
            });
        }
    }

    public void add(final ExecutionTableItem executionTableItem) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.model.add(-1, executionTableItem);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.add(-1, executionTableItem);
                }
            });
        }
    }

    public void add(final int n, final ExecutionTableItem executionTableItem) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            this.model.add(n, executionTableItem);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.add(n, executionTableItem);
                }
            });
        }
    }

    public void add(final ExecutionTableItem[] executionTableItemArray) throws IllegalArgumentException {
        if (EDT.isExecutedInEDT()) {
            this.model.add(executionTableItemArray);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".add"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.add(executionTableItemArray);
                }
            });
        }
    }

    public void remove(final ExecutionTableColumn executionTableColumn) {
        if (EDT.isExecutedInEDT()) {
            this.model.remove(executionTableColumn);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".remove"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.remove(executionTableColumn);
                }
            });
        }
    }

    public void remove(final ExecutionTableItem executionTableItem) {
        if (EDT.isExecutedInEDT()) {
            this.model.remove(executionTableItem);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".remove"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.remove(executionTableItem);
                }
            });
        }
    }

    public void removeAllColumns() {
        if (EDT.isExecutedInEDT()) {
            this.model.removeAllColumns();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllColumns"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.removeAllColumns();
                }
            });
        }
    }

    public void removeAllItems() {
        if (EDT.isExecutedInEDT()) {
            this.model.removeAllItems();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllItems"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.removeAllItems();
                }
            });
        }
    }

    public int getColumnCount() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getRealColumnCount();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.model.getRealColumnCount();
            }
        });
    }

    public ExecutionTableColumn getColumn(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.model.getRealColumn(n, false);
        }
        return EDT.execute(new GuiRequest<ExecutionTableColumn>(){

            @Override
            protected ExecutionTableColumn execute() throws Throwable {
                return ExecutionTable.this.model.getRealColumn(n, false);
            }
        });
    }

    public ExecutionTableColumn getColumnByID(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.model.getRealColumnByID(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableColumn>(){

            @Override
            protected ExecutionTableColumn execute() throws Throwable {
                return ExecutionTable.this.model.getRealColumnByID(n);
            }
        });
    }

    public ExecutionTableColumn getFirstColumn() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getRealColumnCount() > 0 ? this.model.getRealColumn(0, false) : null;
        }
        return EDT.execute(new GuiRequest<ExecutionTableColumn>(){

            @Override
            protected ExecutionTableColumn execute() throws Throwable {
                return ExecutionTable.this.model.getRealColumnCount() > 0 ? ExecutionTable.this.model.getRealColumn(0, false) : null;
            }
        });
    }

    public ExecutionTableColumn getLastColumn() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getRealColumnCount() > 0 ? this.model.getRealColumn(this.model.getRealColumnCount() - 1, false) : null;
        }
        return EDT.execute(new GuiRequest<ExecutionTableColumn>(){

            @Override
            protected ExecutionTableColumn execute() throws Throwable {
                return ExecutionTable.this.model.getRealColumnCount() > 0 ? ExecutionTable.this.model.getRealColumn(ExecutionTable.this.model.getRealColumnCount() - 1, false) : null;
            }
        });
    }

    public int getItemCount() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getItemCount();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.model.getItemCount();
            }
        });
    }

    public ExecutionTableItem getItem(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.model.getItem(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.model.getItem(n);
            }
        });
    }

    public ExecutionTableItem getItemByID(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.model.getItemByID(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.model.getItemByID(n);
            }
        });
    }

    public ExecutionTableItem getFirstItem() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getItemCount() > 0 ? this.model.getItem(0) : null;
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.model.getItemCount() > 0 ? ExecutionTable.this.model.getItem(0) : null;
            }
        });
    }

    public ExecutionTableItem getLastItem() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getItemCount() > 0 ? this.model.getItem(this.model.getItemCount() - 1) : null;
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.model.getItemCount() > 0 ? ExecutionTable.this.model.getItem(ExecutionTable.this.model.getItemCount() - 1) : null;
            }
        });
    }

    public int getVisibleRowCount() {
        if (EDT.isExecutedInEDT()) {
            return this.model.getRowCount();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.model.getRowCount();
            }
        });
    }

    public ExecutionTableItem getVisibleRow(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.model.getVisibleRow(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.model.getVisibleRow(n);
            }
        });
    }

    public ExecutionTableItem getVisibleRowByID(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.model.getVisibleRowByID(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableItem>(){

            @Override
            protected ExecutionTableItem execute() throws Throwable {
                return ExecutionTable.this.model.getVisibleRowByID(n);
            }
        });
    }

    public int convertItemIndexToVisible(final int n) {
        if (EDT.isExecutedInEDT()) {
            return this.model.convertItemIndexToVisible(n);
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.model.convertItemIndexToVisible(n);
            }
        });
    }

    public void sortItems(final int n, final SortOrder sortOrder) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            this.model.sortItems(n, sortOrder);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".sortItems"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.model.sortItems(n, sortOrder);
                }
            });
        }
    }

    public void addColumnGroup(final ExecutionTableGroup executionTableGroup) {
        if (executionTableGroup == null || this.columnGroups.contains(executionTableGroup)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.columnGroups.add(executionTableGroup);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addColumnGroup"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.columnGroups.add(executionTableGroup);
                }
            });
        }
        this.autoRepaint();
    }

    public void removeColumnGroup(final ExecutionTableGroup executionTableGroup) {
        if (!this.columnGroups.contains(executionTableGroup)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.columnGroups.remove(executionTableGroup);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeColumnGroup"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.columnGroups.remove(executionTableGroup);
                }
            });
        }
        this.autoRepaint();
    }

    public int getColumnGroupCount() {
        if (EDT.isExecutedInEDT()) {
            return this.columnGroups.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.columnGroups.size();
            }
        });
    }

    public ExecutionTableGroup getColumnGroup(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.columnGroups.get(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableGroup>(){

            @Override
            protected ExecutionTableGroup execute() throws Throwable {
                return (ExecutionTableGroup)ExecutionTable.this.columnGroups.get(n);
            }
        });
    }

    public void removeAllColumnGroups() {
        if (EDT.isExecutedInEDT()) {
            this.columnGroups.clear();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllColumnGroups"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.columnGroups.clear();
                }
            });
        }
        this.autoRepaint();
    }

    public void addItemGroup(final ExecutionTableGroup executionTableGroup) {
        if (executionTableGroup == null || this.itemGroups.contains(executionTableGroup)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.itemGroups.add(executionTableGroup);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".addItemGroup"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.itemGroups.add(executionTableGroup);
                }
            });
        }
        this.autoRepaint();
    }

    public void removeItemGroup(final ExecutionTableGroup executionTableGroup) {
        if (!this.itemGroups.contains(executionTableGroup)) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.itemGroups.remove(executionTableGroup);
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeItemGroup"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.itemGroups.remove(executionTableGroup);
                }
            });
        }
        this.autoRepaint();
    }

    public int getItemGroupCount() {
        if (EDT.isExecutedInEDT()) {
            return this.itemGroups.size();
        }
        return EDT.execute(new GuiRequest<Integer>(){

            @Override
            protected Integer execute() throws Throwable {
                return ExecutionTable.this.itemGroups.size();
            }
        });
    }

    public ExecutionTableGroup getItemGroup(final int n) throws IndexOutOfBoundsException {
        if (EDT.isExecutedInEDT()) {
            return this.itemGroups.get(n);
        }
        return EDT.execute(new GuiRequest<ExecutionTableGroup>(){

            @Override
            protected ExecutionTableGroup execute() throws Throwable {
                return (ExecutionTableGroup)ExecutionTable.this.itemGroups.get(n);
            }
        });
    }

    public void removeAllItemGroups() {
        if (EDT.isExecutedInEDT()) {
            this.itemGroups.clear();
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".removeAllItemGroups"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.itemGroups.clear();
                }
            });
        }
        this.autoRepaint();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    @Override
    public void removeAll() {
        this.removeAllColumns();
        this.removeAllItems();
        this.removeAllColumnGroups();
        this.removeAllItemGroups();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.initialized) {
            super.addImpl(component, object, n);
        }
    }

    @Override
    protected void repaintComponent() {
        super.repaintComponent();
        this.table.repaint();
    }

    void autoRepaint() {
        if (this.autoRepaint) {
            if (this.getParent() != null) {
                this.getParent().repaint();
            } else {
                this.table.repaint();
            }
        }
    }

    void setColumnWidth(int n, int n2) {
        int n3 = this.model.convertRealIndexToColumn(n);
        if (n3 < this.table.getColumnModel().getColumnCount()) {
            this.table.getColumnModel().getColumn(n3).setPreferredWidth(n2);
        }
    }

    void closeEditors() {
        if (this.closingEditors) {
            return;
        }
        if (EDT.isExecutedInEDT()) {
            this.closingEditors = true;
            this.table.editCellAt(-1, -1);
            this.closingEditors = false;
        } else {
            EDT.execute(new GuiJob(this.getClass().getSimpleName() + ".closeEditors"){

                @Override
                protected void execute() throws Throwable {
                    ExecutionTable.this.closingEditors = true;
                    ExecutionTable.this.table.editCellAt(-1, -1);
                    ExecutionTable.this.closingEditors = false;
                }
            });
        }
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        if (!this.model.isSortable()) {
            return;
        }
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = this.table.convertRowIndexToModel(n);
        int n4 = this.table.convertColumnIndexToModel(n2);
        int n5 = this.model.convertColumnIndexToReal(n4);
        if (this.model.isSortUpColumn(n5)) {
            this.model.sortUp(n3);
        } else if (this.model.isSortDownColumn(n5)) {
            this.model.sortDown(n3);
        }
    }

    private void mouseMoved(MouseEvent mouseEvent) {
        if (!this.model.isSortable()) {
            return;
        }
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (n < 0 || n2 < 0) {
            this.table.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int n3 = this.table.convertColumnIndexToModel(n2);
        int n4 = this.model.convertColumnIndexToReal(n3);
        if (this.model.isSortColumn(n4)) {
            this.table.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.table.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void mouseExited(MouseEvent mouseEvent) {
        if (!this.model.isSortable()) {
            return;
        }
        this.table.setCursor(Cursor.getDefaultCursor());
    }

    private TableCellRenderer getCellRenderer(int n, int n2) {
        Mask mask;
        int n3 = this.table.convertRowIndexToModel(n);
        int n4 = this.table.convertColumnIndexToModel(n2);
        ExecutionTableColumn executionTableColumn = this.model.getRealColumn(n4, true);
        Object object = this.model.getValueAt(n3, n4);
        Mask mask2 = mask = executionTableColumn != null ? executionTableColumn.getMask(object) : null;
        if (mask != null) {
            switch (mask.getType()) {
                case OBJECT_MASK: {
                    object = mask.getMaskObject();
                    break;
                }
                case ICON_MASK: {
                    object = mask.getMaskIcon();
                }
            }
        }
        return object != null ? this.getDefaultCellRenderer(object.getClass()) : this.defCellRenderer;
    }

    private Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component;
        int n3 = this.table.convertRowIndexToModel(n);
        int n4 = this.table.convertColumnIndexToModel(n2);
        ExecutionTableItem executionTableItem = this.model.getVisibleRow(n3);
        ExecutionTableColumn executionTableColumn = this.model.getRealColumn(n4, true);
        boolean bl = executionTableColumn != null ? this.table.isCellSelected(n, n2) : false;
        Object object = this.model.getValueAt(n3, n4);
        Mask mask = executionTableColumn != null ? executionTableColumn.getMask(object) : null;
        Object object2 = object;
        if (mask != null) {
            switch (mask.getType()) {
                case OBJECT_MASK: {
                    object2 = mask.getMaskObject();
                    break;
                }
                case ICON_MASK: {
                    object2 = mask.getMaskIcon();
                }
            }
        }
        if ((component = tableCellRenderer.getTableCellRendererComponent(this.table, object2, bl, false, n, n2)) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            ExecutionTableBorder executionTableBorder = executionTableItem.getBorder();
            Border border = executionTableColumn != null ? executionTableItem.getCellBorder(executionTableColumn.getIndex()) : null;
            ExecutionTableBorder executionTableBorder2 = executionTableColumn != null ? this.getGroupBorder(this.columnGroups, executionTableColumn.getIndex()) : null;
            ExecutionTableBorder executionTableBorder3 = this.getGroupBorder(this.itemGroups, n3);
            if (executionTableBorder2 == null) {
                executionTableBorder2 = this.gridBorder;
            }
            if (executionTableBorder3 == null) {
                executionTableBorder3 = this.gridBorder;
            }
            Border border2 = executionTableBorder != null && executionTableColumn != null ? (this.model.getRealColumnCount() == 1 ? ExecutionTableBorder.createBorder(executionTableBorder, executionTableBorder, executionTableBorder, executionTableBorder) : (executionTableColumn.getIndex() == 0 ? ExecutionTableBorder.createBorder(executionTableBorder, executionTableBorder2, executionTableBorder, executionTableBorder) : (executionTableColumn.getIndex() == this.model.getRealColumnCount() - 1 ? ExecutionTableBorder.createBorder(null, executionTableBorder, executionTableBorder, executionTableBorder) : ExecutionTableBorder.createBorder(null, executionTableBorder2, executionTableBorder, executionTableBorder)))) : ExecutionTableBorder.createBorder(null, executionTableBorder2, null, executionTableBorder3);
            if (border != null) {
                border2 = BorderFactory.createCompoundBorder(border2, border);
            }
            jComponent.setBorder(BorderFactory.createCompoundBorder(border2, cellPaddingBorder));
            if (executionTableColumn == null) {
                if (this.model.isSortUpColumn(this.model.convertColumnIndexToReal(n4))) {
                    jComponent.setToolTipText(this.toolTipSortUp);
                } else if (this.model.isSortDownColumn(this.model.convertColumnIndexToReal(n4))) {
                    jComponent.setToolTipText(this.toolTipSortDown);
                }
            }
        }
        if (executionTableColumn != null) {
            if (!bl) {
                component.setBackground(executionTableItem.getCellBackground(executionTableColumn.getIndex()));
                component.setForeground(executionTableItem.getCellForeground(executionTableColumn.getIndex()));
            }
            if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(executionTableColumn.getAlignment());
            } else if (component instanceof AbstractButton) {
                ((AbstractButton)component).setHorizontalAlignment(executionTableColumn.getAlignment());
            }
        }
        return component;
    }

    private Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        int n3 = this.table.convertRowIndexToModel(n);
        int n4 = this.table.convertColumnIndexToModel(n2);
        ExecutionTableItem executionTableItem = this.model.getVisibleRow(n3);
        ExecutionTableColumn executionTableColumn = this.model.getRealColumn(n4, true);
        boolean bl = this.table.isCellSelected(n, n2);
        Object object = this.model.getValueAt(n3, n4);
        return tableCellEditor.getTableCellEditorComponent(this.table, executionTableItem.getCellInputParser(executionTableColumn.getIndex()).prepareEditor(object), bl, n, n2);
    }

    private ExecutionTableBorder getGroupBorder(List<ExecutionTableGroup> list, int n) {
        for (ExecutionTableGroup executionTableGroup : list) {
            int n2 = n - executionTableGroup.getStart() + 1;
            if (n2 < 1 || !executionTableGroup.isRepeatable() && n2 > executionTableGroup.getAmount() || n2 % executionTableGroup.getAmount() != 0) continue;
            return executionTableGroup.getBorder();
        }
        return null;
    }

    private void internalAddDefaultCellRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        int n = this.getDefaultCellRendererIndex(clazz);
        if (n < 0) {
            this.cellRendererClasses.add(0, clazz);
            this.cellRenderers.add(0, tableCellRenderer);
        } else {
            this.cellRendererClasses.set(0, clazz);
            this.cellRenderers.set(0, tableCellRenderer);
        }
    }

    private int getDefaultCellRendererIndex(Class<?> clazz) {
        int n = -1;
        if (clazz != null) {
            for (int i = 0; i < this.cellRendererClasses.size(); ++i) {
                if (!this.cellRendererClasses.get(i).isAssignableFrom(clazz)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private TableCellRenderer getDefaultCellRenderer(Class<?> clazz) {
        int n = this.getDefaultCellRendererIndex(clazz);
        return n >= 0 ? this.cellRenderers.get(n) : this.defCellRenderer;
    }

    private void scrollToItem(ExecutionTableItem executionTableItem) {
        this.scrollPane.getViewport().scrollRectToVisible(this.table.getCellRect(executionTableItem.getIndex(), this.table.convertColumnIndexToView(0), true));
    }

    static {
        sortUpIconWidth = sortUpIcon != null ? sortUpIcon.getIconWidth() : 0;
        sortDownIcon = Resources.getInstance().SORT_DOWN_ICON;
        sortDownIconWidth = sortDownIcon != null ? sortDownIcon.getIconWidth() : 0;
    }

    class ExecutionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final List<ExecutionTableColumn> columns = new ArrayList<ExecutionTableColumn>(5);
        private final Map<Integer, ExecutionTableColumn> columnsByID = new HashMap<Integer, ExecutionTableColumn>();
        private final List<ExecutionTableItem> items = new ArrayList<ExecutionTableItem>();
        private final Map<Integer, ExecutionTableItem> itemsByID = new HashMap<Integer, ExecutionTableItem>();
        private final List<ExecutionTableItem> visibleRows = new ArrayList<ExecutionTableItem>();
        private boolean sortable = false;

        public void add(ExecutionTableColumn executionTableColumn) throws IllegalArgumentException {
            this.internalAdd(executionTableColumn);
            this.fireTableStructureChanged();
        }

        public void add(ExecutionTableColumn[] executionTableColumnArray) throws IllegalArgumentException {
            if (executionTableColumnArray == null) {
                return;
            }
            for (ExecutionTableColumn executionTableColumn : executionTableColumnArray) {
                this.internalAdd(executionTableColumn);
            }
            this.fireTableStructureChanged();
        }

        public void remove(ExecutionTableColumn executionTableColumn) {
            int n;
            if (executionTableColumn == null || executionTableColumn.getTable() != ExecutionTable.this) {
                return;
            }
            ExecutionTable.this.closeEditors();
            this.columns.remove(executionTableColumn.getIndex());
            if (executionTableColumn.getID() != -1) {
                this.columnsByID.remove(executionTableColumn.getID());
            }
            for (n = 0; n < this.items.size(); ++n) {
                this.items.get(n).removeCell(executionTableColumn.getIndex());
            }
            for (n = executionTableColumn.getIndex(); n < this.columns.size(); ++n) {
                this.columns.get(n).setIndex(n);
            }
            executionTableColumn.setTable(null);
            executionTableColumn.setIndex(-1);
            this.fireTableStructureChanged();
        }

        public void removeAllColumns() {
            ExecutionTable.this.closeEditors();
            this.columns.clear();
            this.columnsByID.clear();
            this.fireTableStructureChanged();
        }

        public int getRealColumnCount() {
            return this.columns.size();
        }

        public ExecutionTableColumn getRealColumn(int n, boolean bl) throws IndexOutOfBoundsException {
            int n2 = this.convertColumnIndexToReal(n);
            if (bl && this.isSortColumn(n2)) {
                return null;
            }
            return this.columns.get(n2);
        }

        public ExecutionTableColumn getRealColumnByID(int n) {
            return this.columnsByID.get(n);
        }

        public void add(int n, ExecutionTableItem executionTableItem) throws IllegalArgumentException, IndexOutOfBoundsException {
            this.internalAdd(n, executionTableItem);
            this.fireTableRowsInserted(executionTableItem.getIndex(), executionTableItem.getIndex());
            if (ExecutionTable.this.autoScrollEnabled) {
                ExecutionTable.this.scrollToItem(executionTableItem);
            }
        }

        public void add(ExecutionTableItem[] executionTableItemArray) throws IllegalArgumentException {
            if (executionTableItemArray == null) {
                return;
            }
            for (ExecutionTableItem executionTableItem : executionTableItemArray) {
                this.internalAdd(-1, executionTableItem);
            }
            if (executionTableItemArray.length > 0) {
                this.fireTableRowsInserted(executionTableItemArray[0].getIndex(), executionTableItemArray[executionTableItemArray.length - 1].getIndex());
                if (ExecutionTable.this.autoScrollEnabled) {
                    ExecutionTable.this.scrollToItem(executionTableItemArray[executionTableItemArray.length - 1]);
                }
            }
        }

        public void remove(ExecutionTableItem executionTableItem) {
            if (executionTableItem == null || executionTableItem.getTable() != ExecutionTable.this) {
                return;
            }
            ExecutionTable.this.closeEditors();
            int n = executionTableItem.getIndex();
            this.items.remove(executionTableItem);
            if (executionTableItem.getID() != -1) {
                this.itemsByID.remove(executionTableItem.getID());
            }
            this.visibleRows.remove(this.convertItemIndexToVisible(n));
            for (int i = executionTableItem.getIndex(); i < this.items.size(); ++i) {
                this.items.get(i).setIndex(i);
            }
            executionTableItem.setTableAndModel(null, null);
            executionTableItem.setIndex(-1);
            this.fireTableRowsDeleted(n, n);
        }

        public void removeAllItems() {
            ExecutionTable.this.closeEditors();
            this.items.clear();
            this.itemsByID.clear();
            this.visibleRows.clear();
            this.fireTableStructureChanged();
        }

        public int getItemCount() {
            return this.items.size();
        }

        public ExecutionTableItem getItem(int n) throws IndexOutOfBoundsException {
            return this.items.get(n);
        }

        public ExecutionTableItem getItemByID(int n) {
            return this.itemsByID.get(n);
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public void setSortable(boolean bl) {
            if (bl == this.sortable) {
                return;
            }
            this.sortable = bl;
            ExecutionTable.this.closeEditors();
            ExecutionTable.this.table.setCursor(Cursor.getDefaultCursor());
            this.fireTableStructureChanged();
        }

        public void sortUp(int n) {
            if (!this.sortable) {
                return;
            }
            if (n > 0) {
                this.swapRows(n - 1, n);
                this.fireTableRowsUpdated(n - 1, n);
            }
        }

        public void sortDown(int n) {
            if (!this.sortable) {
                return;
            }
            if (n < this.visibleRows.size() - 1) {
                this.swapRows(n, n + 1);
                this.fireTableRowsUpdated(n, n + 1);
            }
        }

        public void sortItems(final int n, final SortOrder sortOrder) throws IndexOutOfBoundsException {
            if (n < 0 || n >= this.columns.size()) {
                throw new IndexOutOfBoundsException("column index out of range");
            }
            ExecutionTable.this.closeEditors();
            if (sortOrder == null || sortOrder == SortOrder.UNSORTED) {
                Collections.sort(this.items, unsortedOrderComparator);
            } else {
                Collections.sort(this.items, new Comparator<ExecutionTableItem>(){

                    @Override
                    public int compare(ExecutionTableItem executionTableItem, ExecutionTableItem executionTableItem2) {
                        Object object = executionTableItem.getCellObject(n);
                        Object object2 = executionTableItem2.getCellObject(n);
                        int n2 = 0;
                        n2 = object == null && object2 == null ? executionTableItem.getUnsortedOrderIndex() - executionTableItem2.getUnsortedOrderIndex() : (object == null ? -1 : (object2 == null ? 1 : (object instanceof Comparable && object2 instanceof Comparable ? ((Comparable)object).compareTo((Comparable)object2) : object.toString().compareTo(object2.toString()))));
                        return sortOrder == SortOrder.ASCENDING ? n2 : -n2;
                    }
                });
            }
            this.visibleRows.clear();
            for (int i = 0; i < this.items.size(); ++i) {
                this.items.get(i).setIndex(i);
                if (!this.items.get(i).isVisible()) continue;
                this.visibleRows.add(this.items.get(i));
            }
            this.fireTableStructureChanged();
        }

        public int convertColumnIndexToReal(int n) {
            return this.sortable ? n - 2 : n;
        }

        public int convertRealIndexToColumn(int n) {
            return this.sortable ? n + 2 : n;
        }

        public boolean isSortColumn(int n) {
            return this.isSortUpColumn(n) || this.isSortDownColumn(n);
        }

        public boolean isSortUpColumn(int n) {
            return n == -2;
        }

        public boolean isSortDownColumn(int n) {
            return n == -1;
        }

        public int convertItemIndexToVisible(int n) {
            if (n == this.items.size() - 1) {
                return this.visibleRows.size() - 1;
            }
            int n2 = n >= this.items.size() ? this.items.size() - 1 : n - 1;
            int n3 = 0;
            for (int i = 0; i <= n2; ++i) {
                if (this.items.get(i).isVisible()) continue;
                ++n3;
            }
            return n - n3;
        }

        @Override
        public int getColumnCount() {
            if (this.sortable) {
                return this.getRealColumnCount() + 2;
            }
            return this.getRealColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            ExecutionTableColumn executionTableColumn = this.getRealColumn(n, true);
            if (executionTableColumn == null) {
                return "";
            }
            return executionTableColumn.getName();
        }

        @Override
        public int getRowCount() {
            return this.visibleRows.size();
        }

        public ExecutionTableItem getVisibleRow(int n) throws IndexOutOfBoundsException {
            return this.visibleRows.get(n);
        }

        public ExecutionTableItem getVisibleRowByID(int n) {
            for (ExecutionTableItem executionTableItem : this.visibleRows) {
                if (executionTableItem.getID() != n) continue;
                return executionTableItem;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            ExecutionTableColumn executionTableColumn = this.getRealColumn(n2, true);
            return this.visibleRows.get(n).isEditable() && executionTableColumn != null && executionTableColumn.isEditable();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = this.convertColumnIndexToReal(n2);
            if (this.isSortUpColumn(n3)) {
                return sortUpIcon;
            }
            if (this.isSortDownColumn(n3)) {
                return sortDownIcon;
            }
            return this.visibleRows.get(n).getCellObject(n3);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = this.convertColumnIndexToReal(n2);
            if (this.isSortColumn(n3)) {
                return;
            }
            ExecutionTableItem executionTableItem = this.visibleRows.get(n);
            ExecutionTableItem.InputParser<?> inputParser = executionTableItem.getCellInputParser(n3);
            if (!executionTableItem.isEditable() || !this.columns.get(n3).isEditable()) {
                object = executionTableItem.getCellObject(n3);
            } else if (inputParser != null) {
                object = inputParser.parse(object.toString());
            }
            executionTableItem.setCellObject(n3, object);
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            for (int i = 0; i < this.columns.size(); ++i) {
                if (this.columns.get(i).getWidth() < 0) continue;
                ExecutionTable.this.setColumnWidth(i, this.columns.get(i).getWidth());
            }
            if (this.sortable) {
                TableColumn tableColumn = ExecutionTable.this.table.getColumnModel().getColumn(0);
                TableColumn tableColumn2 = ExecutionTable.this.table.getColumnModel().getColumn(1);
                tableColumn.setPreferredWidth(sortUpIconWidth);
                tableColumn.setMaxWidth(sortUpIconWidth);
                tableColumn.setMinWidth(sortUpIconWidth);
                tableColumn2.setPreferredWidth(sortDownIconWidth);
                tableColumn2.setMaxWidth(sortDownIconWidth);
                tableColumn2.setMinWidth(sortDownIconWidth);
            }
        }

        void updateVisibility(ExecutionTableItem executionTableItem) {
            int n = this.convertItemIndexToVisible(executionTableItem.getIndex());
            boolean bl = this.visibleRows.contains(executionTableItem);
            if (!executionTableItem.isVisible() && bl) {
                this.visibleRows.remove(executionTableItem);
                this.fireTableRowsDeleted(n, n);
            } else if (executionTableItem.isVisible() && !bl) {
                this.visibleRows.add(this.convertItemIndexToVisible(executionTableItem.getIndex()), executionTableItem);
                this.fireTableRowsInserted(n, n);
            }
        }

        private void internalAdd(ExecutionTableColumn executionTableColumn) throws IllegalArgumentException {
            if (executionTableColumn == null) {
                return;
            }
            if (executionTableColumn.getTable() != null) {
                throw new IllegalArgumentException("column is already added to another table");
            }
            if (executionTableColumn.getID() != -1 && this.columnsByID.containsKey(executionTableColumn.getID())) {
                throw new IllegalArgumentException("their already exists a column with the id " + executionTableColumn.getID());
            }
            ExecutionTable.this.closeEditors();
            this.columns.add(executionTableColumn);
            if (executionTableColumn.getID() != -1) {
                this.columnsByID.put(executionTableColumn.getID(), executionTableColumn);
            }
            executionTableColumn.setTable(ExecutionTable.this);
            executionTableColumn.setIndex(this.columns.size() - 1);
        }

        private void internalAdd(int n, ExecutionTableItem executionTableItem) throws IllegalArgumentException, IndexOutOfBoundsException {
            boolean bl;
            if (executionTableItem == null) {
                return;
            }
            if (executionTableItem.getTable() != null) {
                throw new IllegalArgumentException("item is already added to another table");
            }
            if (executionTableItem.getID() != -1 && this.itemsByID.containsKey(executionTableItem.getID())) {
                throw new IllegalArgumentException("their already exists an item with the id " + executionTableItem.getID());
            }
            ExecutionTable.this.closeEditors();
            boolean bl2 = bl = n < 0;
            if (bl) {
                n = this.items.size();
                this.items.add(executionTableItem);
            } else {
                this.items.add(n, executionTableItem);
            }
            if (executionTableItem.getID() != -1) {
                this.itemsByID.put(executionTableItem.getID(), executionTableItem);
            }
            if (executionTableItem.isVisible()) {
                this.visibleRows.add(bl ? this.visibleRows.size() : this.convertItemIndexToVisible(n), executionTableItem);
            }
            executionTableItem.setTableAndModel(ExecutionTable.this, this);
            executionTableItem.setIndex(n);
        }

        private void swapRows(int n, int n2) {
            ExecutionTableItem executionTableItem = this.visibleRows.get(n);
            ExecutionTableItem executionTableItem2 = this.visibleRows.get(n2);
            ExecutionTableItem executionTableItem3 = this.items.get(executionTableItem.getIndex());
            ExecutionTableItem executionTableItem4 = this.items.get(executionTableItem2.getIndex());
            int n3 = executionTableItem3.getIndex();
            int n4 = executionTableItem4.getIndex();
            this.items.set(n3, executionTableItem4);
            this.items.set(n4, executionTableItem3);
            this.visibleRows.set(n, executionTableItem4);
            this.visibleRows.set(n2, executionTableItem3);
            executionTableItem3.setIndex(n4);
            executionTableItem4.setIndex(n3);
        }
    }
}

