/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ColorCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private Border unselectedBorder;
    private Border selectedBorder;
    private final boolean displayRGB;

    public ColorCellRenderer(boolean bl) {
        this.displayRGB = bl;
        this.unselectedBorder = null;
        this.selectedBorder = null;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        try {
            this.setBackground((Color)object);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (bl) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            if (this.unselectedBorder == null) {
                this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
            }
            this.setBorder(this.unselectedBorder);
        }
        if (this.displayRGB) {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setForeground(new Color(255 - this.getBackground().getRed(), 255 - this.getBackground().getGreen(), 255 - this.getBackground().getBlue()));
            this.setFont(jTable.getFont());
            this.setText(this.getBackground().getRed() + ", " + this.getBackground().getGreen() + ", " + this.getBackground().getBlue());
        }
        return this;
    }
}

