/*
 * Decompiled with CFR 0.152.
 */
package lavesdk.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private Color color = Color.white;
    private final JPanel editorPanel;
    private final JPanel colorPanel;
    private final JButton button;
    private final JColorChooser colorChooser;
    private final JDialog colorDialog;
    private final EventController eventController = new EventController();

    public ColorCellEditor(String string) {
        this.editorPanel = new JPanel();
        this.colorPanel = new JPanel();
        this.button = new JButton("...");
        this.colorChooser = new JColorChooser();
        this.colorDialog = JColorChooser.createDialog(this.button, string, true, this.colorChooser, this.eventController, null);
        this.button.addActionListener(this.eventController);
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add((Component)this.colorPanel, "Center");
        this.editorPanel.add((Component)this.button, "East");
    }

    @Override
    public Object getCellEditorValue() {
        return this.color;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        try {
            this.color = (Color)object;
            this.colorPanel.setBackground(this.color);
            this.editorPanel.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.editorPanel;
    }

    private class EventController
    implements ActionListener {
        private EventController() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ColorCellEditor.this.button) {
                ColorCellEditor.this.colorPanel.setBackground(ColorCellEditor.this.color);
                ColorCellEditor.this.colorChooser.setColor(ColorCellEditor.this.color);
                ColorCellEditor.this.colorDialog.setVisible(true);
                ColorCellEditor.this.fireEditingStopped();
            } else {
                ColorCellEditor.this.color = ColorCellEditor.this.colorChooser.getColor();
            }
        }
    }
}

